/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.support.annotation.Nullable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class UrlParamUtils {
    @Nullable
    public static String toString(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (!UrlParamUtils.a(obj.getClass())) {
            throw new IllegalArgumentException("Invalid parameter: " + obj);
        }
        return obj.toString();
    }

    public static Integer toInteger(@Nullable Object obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return UrlParamUtils.toInteger(obj);
    }

    @Nullable
    public static Integer toInteger(@Nullable Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        String string = UrlParamUtils.toString(obj);
        return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }

    @Nullable
    public static Long toLong(@Nullable Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        String string = UrlParamUtils.toString(obj);
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    public static Long toLong(@Nullable Object obj, long defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return UrlParamUtils.toLong(obj);
    }

    public static boolean toBoolean(@Nullable Object obj, boolean defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() != 0.0;
        }
        return Boolean.parseBoolean(UrlParamUtils.toString(obj));
    }

    @Nullable
    public static Date toDate(@Nullable Object obj, @Nullable String[] patterns) {
        if (obj == null) {
            return null;
        }
        Date date = null;
        if (obj instanceof Date) {
            date = (Date)obj;
        } else if (obj instanceof String) {
            date = UrlParamUtils.a(UrlParamUtils.toString(obj), patterns);
        }
        if (date == null) {
            try {
                date = UrlParamUtils.a(UrlParamUtils.toLong(obj));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (date == null) {
            StringBuilder stringBuilder = new StringBuilder("DateTime is malformed: " + obj + ".");
            if (patterns == null) {
                stringBuilder.append(" (Expected a Long format.");
            } else {
                stringBuilder.append(" (Expected date formats: ");
                for (int i = 0; i < patterns.length; ++i) {
                    stringBuilder.append(patterns[i]);
                    if (i == patterns.length - 1) {
                        stringBuilder.append(").");
                        continue;
                    }
                    stringBuilder.append(", ");
                }
            }
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        return date;
    }

    @Nullable
    private static Date a(@Nullable String string, @Nullable String[] stringArray) {
        if (string == null || stringArray == null) {
            return null;
        }
        Date date = null;
        Arrays.sort(stringArray, new Comparator<String>(){

            public int a(String string, String string2) {
                return string2.length() - string.length();
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((String)object, (String)object2);
            }
        });
        for (String string2 : stringArray) {
            try {
                date = new SimpleDateFormat(string2, Locale.US).parse(string);
                if (date == null) continue;
                break;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    @Nullable
    private static Date a(@Nullable Long l) {
        if (l == null) {
            return null;
        }
        return new Date(l);
    }

    @Nullable
    public static List<String> toStringList(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        List<String> list = null;
        if (obj instanceof Collection) {
            ArrayList arrayList = Collections.list(Collections.enumeration((Collection)obj));
            list = new ArrayList<String>(arrayList.size());
            for (Object e : arrayList) {
                list.add(UrlParamUtils.toString(e));
            }
        } else {
            String string = UrlParamUtils.toString(obj);
            if (string != null) {
                list = Collections.singletonList(string);
            }
        }
        if (list == null) {
            throw new IllegalArgumentException("Invalid parameter: " + obj + ". Expected a Collection or a single String.");
        }
        return list;
    }

    @Nullable
    public static List<Date> toDateList(@Nullable Object obj, @Nullable String[] patterns) {
        if (obj == null) {
            return null;
        }
        List<Date> list = null;
        if (obj instanceof Collection) {
            ArrayList arrayList = Collections.list(Collections.enumeration((Collection)obj));
            list = new ArrayList<Date>(arrayList.size());
            for (Object e : arrayList) {
                list.add(UrlParamUtils.toDate(e, patterns));
            }
        } else {
            Date date = UrlParamUtils.toDate(obj, patterns);
            if (date != null) {
                list = Collections.singletonList(date);
            }
        }
        if (list == null) {
            throw new IllegalArgumentException("Invalid parameter: " + obj + ". Expected a Collection or a single Date.");
        }
        return list;
    }

    @Nullable
    public static List<Integer> toIntegerList(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        List<Integer> list = null;
        if (obj instanceof Collection) {
            ArrayList arrayList = Collections.list(Collections.enumeration((Collection)obj));
            list = new ArrayList<Integer>(arrayList.size());
            for (Object e : arrayList) {
                list.add(UrlParamUtils.toInteger(e));
            }
        } else {
            Integer n = UrlParamUtils.toInteger(obj);
            if (n != null) {
                list = Collections.singletonList(n);
            }
        }
        if (list == null) {
            throw new IllegalArgumentException("Invalid parameter: " + obj + ". Expected a Collection or a single Integer.");
        }
        return list;
    }

    private static boolean a(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == String.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Integer.class || clazz == Boolean.class;
    }
}

