/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.Validator;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SharedPreferencesManager {
    private static final String a = Logger.makeTag(SharedPreferencesManager.class);
    @VisibleForTesting
    protected SharedPreferences mSharedPreferences;
    private static SharedPreferencesManager b;
    private ConcurrentHashMap<String, Entry> c = new ConcurrentHashMap();
    @VisibleForTesting
    protected static final String SDK_PREFS_NAME = "SDK_SHARED_PREFERENCES";
    @SuppressLint(value={"SdCardPath"})
    @VisibleForTesting
    protected static final String PREFS_FILE_PATH = "/data/data/%s/shared_prefs/%s.xml";
    private Context d;

    private SharedPreferencesManager(Context context) {
        this.d = context.getApplicationContext();
        this.mSharedPreferences = context.getSharedPreferences(SDK_PREFS_NAME, 0);
    }

    public static synchronized SharedPreferencesManager getInstance(Context context) {
        if (b == null) {
            b = new SharedPreferencesManager(context);
        }
        return b;
    }

    @VisibleForTesting
    protected void resetMemory() {
        this.c = new ConcurrentHashMap();
    }

    public Entry getEntry(String key) {
        if (key == null) {
            return null;
        }
        Entry entry = this.c.get(key);
        if (entry == null) {
            String string = this.mSharedPreferences.getString(key, null);
            if (string != null) {
                ConcurrentHashMap<String, Object> concurrentHashMap = Serializer.deserialize(string);
                if (concurrentHashMap != null) {
                    entry = new Entry(key, this.mSharedPreferences.edit(), concurrentHashMap);
                    this.c.put(key, entry);
                }
            } else if (SharedPreferencesManager.hasSharedPreferencesFile(key, this.d.getPackageName())) {
                SharedPreferences sharedPreferences = this.d.getSharedPreferences(key, 0);
                entry = this.retrieveOldFileContent(sharedPreferences, key);
                this.c.put(key, entry);
                if (entry.commit()) {
                    SharedPreferencesManager.b(sharedPreferences.edit().clear());
                    SharedPreferencesManager.a(key, this.d.getPackageName());
                }
            } else {
                entry = new Entry(key, this.mSharedPreferences.edit());
                this.c.put(key, entry);
            }
        } else {
            SharedPreferencesManager.a(key, this.d.getPackageName());
        }
        return entry;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    @VisibleForTesting
    protected Entry retrieveOldFileContent(SharedPreferences prefs, String key) {
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        Map map = prefs.getAll();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (string == null || v == null) continue;
            concurrentHashMap.put(string, v);
        }
        return new Entry(key, this.mSharedPreferences.edit(), concurrentHashMap);
    }

    @VisibleForTesting
    protected static boolean hasSharedPreferencesFile(String key, String packageName) {
        File file = new File(String.format(PREFS_FILE_PATH, packageName, key));
        return file.exists();
    }

    private static void a(String string, String string2) {
        File file = new File(String.format(PREFS_FILE_PATH, string2, string));
        if (file.exists()) {
            boolean bl = file.delete();
        }
    }

    private static boolean b(SharedPreferences.Editor editor) {
        if (Validator.isAboveAndroid8() && Validator.isMainThread()) {
            editor.apply();
            return true;
        }
        return editor.commit();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    @VisibleForTesting
    public static void reset(Context context) {
        if (b != null) {
            b.resetMemory();
            SharedPreferencesManager.b(SharedPreferencesManager.b.mSharedPreferences.edit().clear());
            SharedPreferencesManager.a(SDK_PREFS_NAME, context.getPackageName());
            b = null;
        }
    }

    public static class Serializer {
        private static final String a = Logger.makeTag(Serializer.class);

        public static String serialize(ConcurrentHashMap<String, Object> hash) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : hash.entrySet()) {
                Object object = entry.getValue();
                try {
                    stringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append(":");
                    if (object != null && object instanceof String) {
                        stringBuilder.append('\"').append(URLEncoder.encode(object.toString(), "UTF-8")).append('\"');
                    } else {
                        stringBuilder.append(object);
                    }
                    stringBuilder.append(";");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            return stringBuilder.toString();
        }

        public static ConcurrentHashMap<String, Object> deserialize(String serializedString) {
            String[] stringArray;
            ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
            for (String string : stringArray = serializedString.split(";")) {
                String[] stringArray2 = string.split(":");
                try {
                    if (stringArray2.length != 2) continue;
                    if (stringArray2[1].length() >= 2 && stringArray2[1].charAt(0) == '\"') {
                        concurrentHashMap.put(URLDecoder.decode(stringArray2[0], "UTF-8"), URLDecoder.decode(stringArray2[1].substring(1, stringArray2[1].length() - 1), "UTF-8"));
                        continue;
                    }
                    concurrentHashMap.put(URLDecoder.decode(stringArray2[0], "UTF-8"), URLDecoder.decode(stringArray2[1], "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            return concurrentHashMap;
        }

        public static String serializeSet(Set<String> set) {
            if (set == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            for (String string : set) {
                try {
                    if (string == null) {
                        stringBuilder.append((String)null);
                        continue;
                    }
                    stringBuilder.append('\"').append(URLEncoder.encode(string, "UTF-8")).append('\"').append(",");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        public static Set<String> deserializeSet(String value) {
            if (value == null) {
                return null;
            }
            HashSet<String> hashSet = new HashSet<String>();
            if (value.startsWith("{") && value.endsWith("}")) {
                String[] stringArray;
                if (value.length() == 2) {
                    return hashSet;
                }
                String string = value.substring(1, value.length() - 1);
                for (String string2 : stringArray = string.split(",")) {
                    try {
                        if (string2.equals("null")) {
                            hashSet.add(null);
                            continue;
                        }
                        if (string2.length() < 2 || string2.charAt(0) != '\"' || string2.charAt(string2.length() - 1) != '\"') continue;
                        hashSet.add(URLDecoder.decode(string2.substring(1, string2.length() - 1), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return null;
                    }
                }
            }
            return hashSet;
        }
    }

    public static class Entry {
        private String a;
        private ConcurrentHashMap<String, Object> b;
        private SharedPreferences.Editor c;

        public Entry(String key, SharedPreferences.Editor editor) {
            this.a = key;
            this.c = editor;
            this.b = new ConcurrentHashMap();
        }

        public Entry(String key, SharedPreferences.Editor editor, ConcurrentHashMap<String, Object> hash) {
            this.a = key;
            this.c = editor;
            this.b = hash;
        }

        public String getKey() {
            return this.a;
        }

        @VisibleForTesting
        protected SharedPreferences.Editor getEditor() {
            return this.c;
        }

        public boolean isEmpty() {
            return this.b.size() == 0;
        }

        public int getInt(String key) {
            if (key == null) {
                return 0;
            }
            Object object = this.b.get(key);
            if (object instanceof String) {
                return Integer.parseInt((String)object);
            }
            return (Integer)object;
        }

        public int getInt(String key, int defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return Integer.parseInt((String)object);
            }
            return (Integer)object;
        }

        public Entry put(String key, int value) {
            if (key != null) {
                this.b.put(key, value);
            }
            return this;
        }

        public boolean getBoolean(String key) {
            if (key == null) {
                return false;
            }
            Object object = this.b.get(key);
            if (object instanceof String) {
                return Boolean.parseBoolean((String)object);
            }
            return (Boolean)object;
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return Boolean.parseBoolean((String)object);
            }
            return (Boolean)object;
        }

        public Entry put(String key, boolean value) {
            if (key != null) {
                this.b.put(key, value);
            }
            return this;
        }

        public double getDouble(String key) {
            if (key == null) {
                return 0.0;
            }
            Object object = this.b.get(key);
            if (object instanceof String) {
                return Double.parseDouble((String)this.b.get(key));
            }
            return (Double)object;
        }

        public double getDouble(String key, double defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return Double.parseDouble((String)object);
            }
            return (Double)object;
        }

        public Entry put(String key, double value) {
            if (key != null) {
                this.b.put(key, value);
            }
            return this;
        }

        public float getFloat(String key) {
            if (key == null) {
                return 0.0f;
            }
            Object object = this.b.get(key);
            if (object instanceof String) {
                return Float.parseFloat((String)this.b.get(key));
            }
            return ((Float)object).floatValue();
        }

        public float getFloat(String key, float defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return Float.parseFloat((String)object);
            }
            return ((Float)object).floatValue();
        }

        public Entry put(String key, float value) {
            if (key != null) {
                this.b.put(key, Float.valueOf(value));
            }
            return this;
        }

        public long getLong(String key) {
            if (key == null) {
                return 0L;
            }
            Object object = this.b.get(key);
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            return (Long)object;
        }

        public long getLong(String key, long defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            return (Long)object;
        }

        public Entry put(String key, long value) {
            if (key != null) {
                this.b.put(key, value);
            }
            return this;
        }

        public String getString(String key) {
            if (key == null) {
                return null;
            }
            return (String)this.b.get(key);
        }

        public String getString(String key, String defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            return object != null ? (String)object : defaultValue;
        }

        public Entry put(String key, String value) {
            if (key != null && value != null) {
                this.b.put(key, value);
            }
            return this;
        }

        public Set<String> getStringSet(String key) {
            if (key == null) {
                return null;
            }
            return Serializer.deserializeSet((String)this.b.get(key));
        }

        public Set<String> getStringSet(String key, Set<String> defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return this.getStringSet(key);
            }
            return defaultValue;
        }

        public Entry put(String key, Set<String> set) {
            if (key != null && set != null) {
                String string = Serializer.serializeSet(set);
                this.b.put(key, string);
            }
            return this;
        }

        public Entry remove(String key) {
            if (key != null) {
                this.b.remove(key);
            }
            return this;
        }

        public boolean commit() {
            String string = Serializer.serialize(this.b);
            if (string != null) {
                this.c.putString(this.a, string);
                return SharedPreferencesManager.b(this.c);
            }
            return false;
        }

        public boolean clear() {
            this.b.clear();
            if (this.c != null) {
                this.c.remove(this.a);
                return SharedPreferencesManager.b(this.c);
            }
            return false;
        }

        public boolean contains(String key) {
            return this.b != null && this.b.containsKey(key);
        }
    }
}

