/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.content.Context;
import android.graphics.Rect;
import com.inlocomedia.android.core.models.Size;
import com.inlocomedia.android.core.util.ScreenHelper;

public class MetricsUtils {
    private MetricsUtils() {
    }

    public static float dipToPx(Context context, float dip) {
        return dip * ScreenHelper.getDensity(context);
    }

    public static float pxToDip(Context context, float px) {
        return px / ScreenHelper.getDensity(context);
    }

    public static void pxToDip(Context context, Rect rectPx, Rect rectDip) {
        rectDip.set((int)MetricsUtils.pxToDip(context, rectPx.left), (int)MetricsUtils.pxToDip(context, rectPx.top), (int)MetricsUtils.pxToDip(context, rectPx.right), (int)MetricsUtils.pxToDip(context, rectPx.bottom));
    }

    public static void dipToPx(Context context, Rect rectDip, Rect rectPx) {
        rectPx.set((int)MetricsUtils.dipToPx(context, rectDip.left), (int)MetricsUtils.dipToPx(context, rectDip.top), (int)MetricsUtils.dipToPx(context, rectDip.right), (int)MetricsUtils.dipToPx(context, rectDip.bottom));
    }

    public static void pxToDip(Context context, Size sizePx, Size sizeDip) {
        sizeDip.set(MetricsUtils.pxToDip(context, sizePx.width), MetricsUtils.pxToDip(context, sizePx.height));
    }

    public static void dipToPx(Context context, Size sizeDip, Size sizePx) {
        sizePx.set(MetricsUtils.dipToPx(context, sizeDip.width), MetricsUtils.dipToPx(context, sizeDip.height));
    }
}

