/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;

public class MediaScanner {
    @VisibleForTesting
    protected final Context mContext;
    @VisibleForTesting
    protected final String mPath;
    @VisibleForTesting
    protected final String mMimeType;
    private MediaScannerConnection a;

    public MediaScanner(@NonNull Context context, @NonNull String path) {
        this(context, path, null);
    }

    public MediaScanner(@NonNull Context context, @NonNull String path, @Nullable String mimeType) {
        this.mContext = context;
        this.mPath = path;
        this.mMimeType = mimeType;
    }

    public boolean scan(final @Nullable OnMediaScanListener listener) {
        if (this.a != null) {
            return false;
        }
        this.a = new MediaScannerConnection(this.mContext, new MediaScannerConnection.MediaScannerConnectionClient(){

            public void onMediaScannerConnected() {
                MediaScanner.this.a.scanFile(MediaScanner.this.mPath, MediaScanner.this.mMimeType);
            }

            public void onScanCompleted(String path, Uri uri) {
                MediaScanner.this.a.disconnect();
                if (listener != null) {
                    if (uri == null) {
                        listener.onFailure();
                    } else {
                        listener.onMediaScanned(path);
                    }
                }
            }
        });
        this.a.connect();
        return true;
    }

    public static interface OnMediaScanListener {
        public void onMediaScanned(String var1);

        public void onFailure();
    }
}

