/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.support.annotation.Nullable;
import android.util.Log;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.util.MD5CheckFailedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MD5 {
    private static final String a = MD5.class.getSimpleName();

    private MD5() {
    }

    public static InputStream checkMD5(String md5, InputStream inputStream) throws IOException, MD5CheckFailedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = MD5.calculateMD5(inputStream, byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        if (!string.equalsIgnoreCase(md5)) {
            throw new MD5CheckFailedException("MD5 " + md5 + " is not equal to MD5 from file " + string);
        }
        if (Environment.isCommunicationDebug()) {
            Log.v((String)a, (String)("Calculated digest: " + string));
            Log.v((String)a, (String)("Provided digest: " + md5));
            Log.v((String)a, (String)("MD5 is equal? " + string.equalsIgnoreCase(md5)));
        }
        return byteArrayInputStream;
    }

    public static String calculateMD5(InputStream inputStream, ByteArrayOutputStream byteOutput) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (Environment.isCommunicationDebug()) {
                Log.e((String)a, (String)"Exception while getting digest", (Throwable)noSuchAlgorithmException);
            }
            return null;
        }
        byte[] byArray = new byte[8192];
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                if (byteOutput != null) {
                    byteOutput.write(byArray, 0, n);
                }
                messageDigest.update(byArray, 0, n);
            }
            if (byteOutput != null) {
                byteOutput.flush();
            }
            byte[] byArray2 = messageDigest.digest();
            BigInteger bigInteger = new BigInteger(1, byArray2);
            String string = bigInteger.toString(16);
            String string2 = string = String.format("%32s", string).replace(' ', '0');
            return string2;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to process file for MD5", iOException);
        }
        finally {
            block15: {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    if (!Environment.isCommunicationDebug()) break block15;
                    Log.e((String)a, (String)"Exception on closing MD5 input stream", (Throwable)iOException);
                }
            }
        }
    }

    @Nullable
    public static String calculateMD5(String string) {
        if (string == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(Integer.toHexString(0xFF & by));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            if (Environment.isCommunicationDebug()) {
                Log.e((String)a, (String)"Exception on closing MD5 input stream", (Throwable)exception);
            }
            return null;
        }
    }
}

