/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.serialization.json;

import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.serialization.json.JsonReflector;
import com.inlocomedia.android.core.serialization.json.Jsonable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.json.JSONObject;

public abstract class JsonableModel
implements Jsonable {
    public JsonableModel() {
    }

    public JsonableModel(JSONObject jsonObj) throws InvalidMappingException {
        this.parseFromJSON(jsonObj);
    }

    @Override
    public void parseFromJSON(JSONObject json) throws InvalidMappingException {
        JsonReflector.fromJson(json, (Object)this);
    }

    @Override
    public JSONObject parseToJSON() throws InvalidMappingException {
        return JsonReflector.toJson(this);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface JsonField {
        public String key();

        public boolean required() default false;
    }
}

