/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.resources.ui.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.Scroller;
import com.inlocomedia.android.core.resources.ui.interfaces.Centralizable;
import com.inlocomedia.android.core.resources.ui.interfaces.InteractiveChildInterface;
import com.inlocomedia.android.core.resources.ui.interfaces.Scalable;
import com.inlocomedia.android.core.resources.ui.util.Zoomer;
import com.inlocomedia.android.core.resources.ui.views.ScalableViewInterface;
import com.inlocomedia.android.core.util.TimeUtils;
import java.util.concurrent.atomic.AtomicLong;

public abstract class InteractiveView
extends FrameLayout
implements Scalable {
    private float a;
    private float b;
    private int c;
    private int d;
    private int e;
    private int f;
    private ScaleGestureDetector g;
    private GestureDetector h;
    private Matrix i;
    private View j;
    private float k;
    private float l;
    private float m;
    private float n;
    private long o;
    private Zoomer p;
    private Scroller q;
    private boolean r;
    private boolean s;
    private boolean t;
    private boolean u;
    private boolean v;
    private boolean w;
    private boolean x;
    private b y;

    public abstract void onPointClick(PointF var1);

    public abstract void onLongPress(PointF var1);

    public abstract void onScroll(float var1, float var2);

    public InteractiveView(Context context) {
        super(context);
        this.a(context);
    }

    public InteractiveView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.a(context);
    }

    public InteractiveView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.a(context);
    }

    private void a(Context context) {
        this.g = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new c());
        this.h = new GestureDetector(context, (GestureDetector.OnGestureListener)new a());
        this.i = new Matrix();
        this.i.reset();
        this.p = new Zoomer(this);
        this.q = new Scroller(this.getContext());
        this.y = new b();
        this.w = true;
        this.setClipChildren(false);
        this.r = true;
        this.s = true;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return false;
    }

    private void a(float[] fArray) {
        Matrix matrix = new Matrix();
        this.i.invert(matrix);
        matrix.mapPoints(fArray);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean bl = false;
        if (!bl) {
            if (this.t) {
                event.setLocation(this.k, this.l);
            }
            this.g.onTouchEvent(event);
            if (!this.g.isInProgress()) {
                this.h.onTouchEvent(event);
            }
            if (event.getAction() == 1) {
                if (!this.g.isInProgress() && !this.v && this.x) {
                    this.a(true);
                }
                this.x = false;
            }
        }
        this.t = false;
        return true;
    }

    @SuppressLint(value={"NewApi"})
    protected void dispatchDraw(@NonNull Canvas canvas) {
        if (this.p.computeZoomOffset() && this.a(this.p.getCurrentScaleFactor())) {
            this.scaleTo(this.p.getCurrentScaleFactor(), this.p.getCurrentFocusX(), this.p.getCurrentFocusY());
        }
        if (this.q.computeScrollOffset()) {
            this.translateTo(this.q.getCurrX(), this.q.getCurrY());
        }
        float f = this.getTotalScaled();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            View view = this.getChildAt(i);
            view.setPivotX(0.0f);
            view.setPivotY(0.0f);
            if (view instanceof InteractiveChildInterface) {
                object = (InteractiveChildInterface)view;
                float[] fArray = new float[]{object.getXOnMap(), object.getYOnMap()};
                this.i.mapPoints(fArray);
                view.setTranslationX(fArray[0] - object.getXOffset());
                view.setTranslationY(fArray[1] - object.getYOffset());
            }
            if (view instanceof ScalableViewInterface) {
                object = (ScalableViewInterface)view;
                boolean bl = object.setScale(f);
                if (!bl) {
                    view.setScaleX(f);
                    view.setScaleY(f);
                }
            } else if (view instanceof InteractiveChildInterface && ((InteractiveChildInterface)view).isScalable()) {
                view.setScaleX(f);
                view.setScaleY(f);
            }
            if (view.getVisibility() != 0) continue;
            this.drawChild(canvas, view, 0L);
        }
    }

    public void setCenterView(View v) {
        this.j = v;
        if (v != null) {
            this.a(v);
        }
    }

    private void a(View view) {
        if (((Centralizable)view).isToChangeScaleBoundaries()) {
            float f = this.b(view);
            this.a = f - 0.05f;
            this.b = f - 0.25f;
            if (this.getTotalScaled() < this.b) {
                this.i.postScale(this.a, this.a);
            }
        }
    }

    private float b(View view) {
        float f;
        float f2;
        view.requestLayout();
        if (view instanceof Centralizable) {
            f2 = ((Centralizable)view).getRealWidth();
            f = ((Centralizable)view).getRealHeight();
        } else {
            f2 = view.getMeasuredWidth();
            f = view.getMeasuredHeight();
        }
        float f3 = (float)this.getMeasuredWidth() / f2;
        float f4 = (float)this.getMeasuredHeight() / f;
        return Math.min(f3, f4);
    }

    public void centralize(View view, boolean scaled) {
        if (view != null) {
            float f;
            float f2;
            float f3;
            float f4 = this.getTotalScaled();
            this.i.reset();
            float[] fArray = new float[4];
            boolean bl = this.a(view, fArray);
            float f5 = fArray[0];
            float f6 = fArray[1];
            float f7 = fArray[2];
            float f8 = fArray[3];
            if (bl && scaled) {
                f3 = (float)this.getMeasuredWidth() / f5;
                f2 = (float)this.getMeasuredHeight() / f6;
                f = Math.min(f3, f2);
                this.i.postScale(f, f);
            } else {
                this.i.postScale(f4, f4);
            }
            f3 = 0.0f;
            f2 = 0.0f;
            if (!(view instanceof InteractiveChildInterface) || ((InteractiveChildInterface)view).isScalable()) {
                f3 = this.i.mapRadius(f5);
                f2 = this.i.mapRadius(f6);
            }
            f = this.i.mapRadius(f7);
            float f9 = this.i.mapRadius(f8);
            float f10 = this.getWidth();
            float f11 = this.getHeight();
            this.i.postTranslate(-f, -f9);
            this.i.postTranslate(-f3 / 2.0f, -f2 / 2.0f);
            this.i.postTranslate(f10 / 2.0f, f11 / 2.0f);
            this.invalidate();
        }
    }

    private boolean a(View view, float[] fArray) {
        float f;
        float f2;
        float f3;
        float f4;
        boolean bl = false;
        view.requestLayout();
        if (view instanceof Centralizable) {
            f4 = ((Centralizable)view).getRealWidth();
            f3 = ((Centralizable)view).getRealHeight();
            f2 = ((Centralizable)view).getRealX();
            f = ((Centralizable)view).getRealY();
            bl = ((Centralizable)view).isToFitOnScreen();
        } else {
            f4 = view.getMeasuredWidth();
            f3 = view.getMeasuredHeight();
            f2 = 0.0f;
            f = 0.0f;
        }
        fArray[0] = f4;
        fArray[1] = f3;
        fArray[2] = f2;
        fArray[3] = f;
        return bl;
    }

    private void a(boolean bl) {
        if (this.j == null || !this.w) {
            return;
        }
        int n = this.j.getMeasuredWidth();
        int n2 = this.j.getMeasuredHeight();
        float[] fArray = new float[]{0.0f, 0.0f, n, n2};
        this.i.mapPoints(fArray);
        float f = (fArray[2] - fArray[0]) / 2.0f;
        float f2 = (fArray[3] - fArray[1]) / 2.0f;
        float f3 = (float)this.getWidth() / 2.0f;
        float f4 = (float)this.getHeight() / 2.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (fArray[0] > (float)this.e && fArray[0] > f3 - f) {
            f5 = Math.max((float)this.e, f3 - f) - fArray[0];
        } else if (fArray[2] < (float)this.c && fArray[2] < f3 + f) {
            f5 = Math.min((float)this.c, f3 + f) - fArray[2];
        }
        if (fArray[1] > (float)this.f && fArray[1] > f4 - f2) {
            f6 = Math.max((float)this.f, f4 - f2) - fArray[1];
        } else if (fArray[3] < (float)this.d && fArray[3] < f4 + f2) {
            f6 = Math.min((float)this.d, f4 + f2) - fArray[3];
        }
        if (f5 != 0.0f || f6 != 0.0f) {
            this.q.startScroll((int)fArray[0], (int)fArray[1], Math.round(f5), Math.round(f6));
            this.y.a(this.q.getDuration());
        }
    }

    private void a() {
        this.e = 10;
        this.f = 10;
        this.c = this.getMeasuredWidth() - 10;
        this.d = this.getMeasuredHeight() - 10;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b2) {
        super.onLayout(changed, l, t, r, b2);
        this.a();
    }

    @Override
    public void scaleTo(float scaleFactor, float x, float y) {
        float f = scaleFactor / this.getTotalScaled();
        this.postScale(f, f, x, y);
    }

    @Override
    public float getTotalScaled() {
        return this.i.mapRadius(1000.0f) / 1000.0f;
    }

    private boolean a(float f) {
        return f > this.b && 2.1474836E9f > f;
    }

    public void returnToZoomBoundaries() {
        if (this.w) {
            float f = this.getTotalScaled();
            if (f > 2.1474836E9f) {
                this.p.startZoom(2.1474836E9f - f, this.m, this.n);
                this.y.a(this.p.getDuration());
            } else if (f < this.a) {
                this.p.startZoom(this.a - f, this.m, this.n);
                this.y.a(this.p.getDuration());
            }
        }
    }

    public boolean postScale(float factorX, float factorY, float px, float py) {
        boolean bl = this.i.postScale(factorX, factorY, px, py);
        this.a(true);
        return bl;
    }

    public void translateTo(float distanceX, float distanceY) {
        float[] fArray = new float[]{0.0f, 0.0f};
        this.i.mapPoints(fArray);
        float f = distanceX - fArray[0];
        float f2 = distanceY - fArray[1];
        this.i.postTranslate(f, f2);
    }

    public void zoomFadeIn() {
        float f = (float)this.getWidth() / 2.0f;
        float f2 = (float)this.getHeight() / 2.0f;
        this.zoomFadeIn(f, f2);
    }

    public void zoomFadeIn(float x, float y) {
        float f = 0.5f;
        float f2 = this.getTotalScaled();
        if (f2 + f < 2.1474836E9f) {
            this.p.startZoom(f, x, y);
        } else {
            this.p.startZoom(2.1474836E9f - f2, x, y);
        }
        this.y.a(this.p.getDuration());
    }

    public void zoomFadeOut() {
        float f = (float)this.getWidth() / 2.0f;
        float f2 = (float)this.getHeight() / 2.0f;
        this.zoomFadeOut(f, f2);
    }

    public void zoomFadeOut(float x, float y) {
        float f = 0.5f;
        float f2 = this.getTotalScaled();
        if (f2 - f > this.a) {
            this.p.startZoom(-f, x, y);
        } else {
            this.p.startZoom(this.a - f2, x, y);
        }
        this.y.a(this.p.getDuration());
    }

    private void b() {
        long l = SystemClock.elapsedRealtime();
        if (TimeUtils.hasElapsedEnoughTime(this.o, 17L)) {
            this.invalidate();
            this.o = l;
        }
    }

    public void setBoundariesActivated(boolean boundariesActivated) {
        this.w = boundariesActivated;
    }

    public void setScaleActivated(boolean scaleActivated) {
        this.s = scaleActivated;
    }

    public void setFlingActivated(boolean flingActivated) {
        this.r = flingActivated;
    }

    class b
    implements Runnable {
        private final AtomicLong b = new AtomicLong();

        @Override
        public void run() {
            if (this.b.get() > 0L) {
                this.b.set(Math.max(this.b.get() - 17L, 0L));
                this.a(Math.max(this.b.get() - 17L, 0L));
                InteractiveView.this.invalidate();
                InteractiveView.this.postDelayed(this, 17L);
            } else {
                InteractiveView.this.invalidate();
                if (InteractiveView.this.v) {
                    InteractiveView.this.v = false;
                    InteractiveView.this.a(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void a(long l) {
            if (this.b.compareAndSet(0L, l)) {
                InteractiveView.this.post(this);
            } else {
                b b2 = this;
                synchronized (b2) {
                    this.b.set(Math.max(l, this.b.get()));
                }
            }
        }
    }

    private class c
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private c() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (InteractiveView.this.s && InteractiveView.this.a(InteractiveView.this.getTotalScaled() * detector.getScaleFactor())) {
                InteractiveView.this.m = detector.getFocusX();
                InteractiveView.this.n = detector.getFocusY();
                InteractiveView.this.i.postScale(detector.getScaleFactor(), detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY());
                InteractiveView.this.b();
            }
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            super.onScaleEnd(detector);
            InteractiveView.this.returnToZoomBoundaries();
            InteractiveView.this.a(true);
        }
    }

    private class a
    extends GestureDetector.SimpleOnGestureListener {
        private a() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            InteractiveView.this.i.postTranslate(-distanceX, -distanceY);
            InteractiveView.this.b();
            InteractiveView.this.onScroll(distanceX, distanceY);
            InteractiveView.this.x = true;
            return true;
        }

        public boolean onDown(MotionEvent ev) {
            InteractiveView.this.p.forceFinished(true);
            InteractiveView.this.q.forceFinished(true);
            InteractiveView.this.v = false;
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (InteractiveView.this.r && InteractiveView.this.j != null) {
                if (InteractiveView.this.u) {
                    return true;
                }
                float[] fArray = new float[]{0.0f, 0.0f, InteractiveView.this.j.getMeasuredWidth(), InteractiveView.this.j.getMeasuredHeight()};
                InteractiveView.this.i.mapPoints(fArray);
                float f = fArray[2] - fArray[0];
                float f2 = fArray[3] - fArray[1];
                float f3 = (float)InteractiveView.this.getWidth() / 2.0f;
                float f4 = (float)InteractiveView.this.getHeight() / 2.0f;
                int n = (int)Math.min((float)InteractiveView.this.c - f, f3 - f / 2.0f);
                int n2 = (int)Math.max((float)InteractiveView.this.e, f3 - f / 2.0f);
                int n3 = (int)Math.min((float)InteractiveView.this.d - f2, f4 - f2 / 2.0f);
                int n4 = (int)Math.max((float)InteractiveView.this.f, f4 - f2 / 2.0f);
                InteractiveView.this.q.fling((int)fArray[0], (int)fArray[1], (int)velocityX, (int)velocityY, n, n2, n3, n4);
                InteractiveView.this.y.a(InteractiveView.this.q.getDuration());
                InteractiveView.this.v = true;
            }
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            float[] fArray = new float[]{e.getX(), e.getY()};
            InteractiveView.this.a(fArray);
            InteractiveView.this.onPointClick(new PointF(fArray[0], fArray[1]));
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            InteractiveView.this.zoomFadeIn(e.getX(), e.getY());
            return true;
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
            float[] fArray = new float[]{e.getX(), e.getY()};
            InteractiveView.this.a(fArray);
            InteractiveView.this.onLongPress(new PointF(fArray[0], fArray[1]));
        }
    }
}

