/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.log;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.database.IdAndValueList;
import com.inlocomedia.android.core.database.LazyCloseSQLiteOpenHelper;
import com.inlocomedia.android.core.log.Dumpable;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.util.Validator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import org.json.JSONException;
import org.json.JSONObject;

final class a
extends LazyCloseSQLiteOpenHelper
implements Dumpable {
    private static final DateFormat a = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'", Locale.US);
    private final HashMap<String, Object> b = new HashMap();
    private boolean c = true;

    protected a(Context context, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        super(context, "inlocomedia_othudatoneuhdantehu", null, 9, uncaughtExceptionHandler);
    }

    public void onCreate(SQLiteDatabase db) {
        if (!this.c) {
            return;
        }
        try {
            db.execSQL("CREATE TABLE error(_id INTEGER PRIMARY KEY AUTOINCREMENT, date INTEGER, tag TEXT, module TEXT, error TEXT, stacktrace TEXT, error_sdk_version_code INTEGER,  INTEGER);");
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (!this.c) {
            return;
        }
        try {
            db.execSQL("DROP TABLE IF EXISTS error");
            this.onCreate(db);
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (!this.c) {
            return;
        }
        try {
            db.execSQL("DROP TABLE IF EXISTS error");
            this.onCreate(db);
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
        }
    }

    synchronized long a(String string, Module module, String string2, String string3) {
        if (!this.c) {
            return -1L;
        }
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("date", Long.valueOf(System.currentTimeMillis()));
            contentValues.put("tag", string);
            contentValues.put("module", String.valueOf(module));
            contentValues.put("error", string2);
            contentValues.put("stacktrace", string3);
            contentValues.put("error_sdk_version_code", Integer.valueOf(20500));
            SQLiteDatabase sQLiteDatabase = this.openDatabase();
            if (sQLiteDatabase == null) {
                return -1L;
            }
            long l = sQLiteDatabase.insert("error", null, contentValues);
            this.closeDatabase();
            return l;
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
            return -1L;
        }
    }

    @Override
    @Nullable
    public synchronized IdAndValueList<String> dump(Context context) {
        return this.dump(context, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public synchronized IdAndValueList<String> dump(Context context, int limit) {
        if (!this.c) {
            return null;
        }
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.openDatabase();
            Validator.notNull(sQLiteDatabase, "Analytics Database");
            String string = limit > 0 ? String.valueOf(limit) : null;
            cursor = sQLiteDatabase.query("error", null, null, null, null, null, null, string);
            IdAndValueList<String> idAndValueList = new IdAndValueList<String>();
            int n = cursor.getColumnIndex("_id");
            while (cursor.moveToNext()) {
                long l = cursor.getLong(n);
                String string2 = this.a(context, cursor);
                idAndValueList.add(l, string2);
            }
            IdAndValueList<String> idAndValueList2 = idAndValueList;
            return idAndValueList2;
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
            IdAndValueList<String> idAndValueList = null;
            return idAndValueList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.closeDatabase();
        }
    }

    protected String a(Context context, Cursor cursor) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("type", (Object)"sdk_error_log");
            jSONObject.put("sdk_version_code", 20500);
            jSONObject.put("sdk_code_version", 20500);
            jSONObject.put("sender_name", (Object)"Android-API");
            jSONObject.put("os", (Object)"android");
            jSONObject.put("os_version", Device.ANDROID_VERSION_CODE);
            jSONObject.put("device_model", (Object)Device.MODEL);
            jSONObject.put("device_manufacturer", (Object)Device.MANUFACTURER);
            jSONObject.put("@version", 9);
            jSONObject.put("mad_id", (Object)Device.getAdOrDeviceId(context));
            jSONObject.put("google_aid", (Object)Device.getGoogleAdvertisingId(context));
            jSONObject.put("ilm_id", (Object)Device.getDeviceId(context));
            jSONObject.put("app_package_name", (Object)context.getPackageName());
            jSONObject.put("module", (Object)cursor.getString(cursor.getColumnIndex("module")));
            long l = cursor.getLong(cursor.getColumnIndex("date"));
            jSONObject.put("sdt", (Object)a.format(l));
            String string = cursor.getString(cursor.getColumnIndex("tag"));
            string = com.inlocomedia.android.core.log.a.a(string);
            jSONObject.put("tag", (Object)string);
            jSONObject.put("error_msg", (Object)cursor.getString(cursor.getColumnIndex("error")));
            jSONObject.put("stacktrace", (Object)cursor.getString(cursor.getColumnIndex("stacktrace")));
            jSONObject.put("error_sdk_version_code", cursor.getInt(cursor.getColumnIndex("error_sdk_version_code")));
            for (Map.Entry<String, Object> entry : this.b.entrySet()) {
                jSONObject.put(entry.getKey(), entry.getValue());
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            throw new RuntimeException("LogCentralLogLineComposer failed: ", jSONException);
        }
    }

    @Override
    public synchronized void deleteIn(List<Long> ids) {
        if (!this.c) {
            return;
        }
        try {
            SQLiteDatabase sQLiteDatabase = this.openDatabase();
            if (sQLiteDatabase == null) {
                return;
            }
            String string = "DELETE FROM %s WHERE %s IN (%s);";
            String string2 = TextUtils.join((CharSequence)", ", ids);
            String string3 = String.format("DELETE FROM %s WHERE %s IN (%s);", "error", "_id", string2);
            sQLiteDatabase.execSQL(string3);
            this.closeDatabase();
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
        }
    }

    @Override
    public synchronized void cleanup() {
        if (!this.c) {
            return;
        }
        try {
            SQLiteDatabase sQLiteDatabase = this.openDatabase();
            if (sQLiteDatabase == null) {
                return;
            }
            long l = DatabaseUtils.queryNumEntries((SQLiteDatabase)sQLiteDatabase, (String)"error");
            if (l > 1000L) {
                long l2 = l - 1000L;
                String string = "SELECT _id FROM error ORDER BY _id ASC LIMIT " + l2;
                String string2 = "DELETE FROM %s WHERE %s IN (%s);";
                String string3 = String.format("DELETE FROM %s WHERE %s IN (%s);", "error", "_id", string);
                sQLiteDatabase.execSQL(string3);
            }
            this.closeDatabase();
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
        }
    }

    protected static String a(String string) {
        return string.replace(' ', '_').replace('\t', '_');
    }

    public void a(String string, Object object) {
        this.b.put(string, object);
    }

    public Object b(String string) {
        return this.b.get(string);
    }

    static {
        a.setTimeZone(new SimpleTimeZone(0, "UTC"));
    }
}

