/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.log;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.inlocomedia.android.core.database.LazyCloseSQLiteOpenHelper;
import com.inlocomedia.android.core.log.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class FileLogger
extends LazyCloseSQLiteOpenHelper {
    protected static final int DB_VERSION = 1;
    private static final String a = Logger.makeTag(FileLogger.class);
    @SuppressLint(value={"SimpleDateFormat"})
    private static final DateFormat b = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss.SSS");
    protected static final String TABLE_NAME = "entries";
    protected static final String COL_ID = "_id";
    protected static final String COL_DATE = "date";
    protected static final String COL_MESSAGE = "message";
    private static FileLogger c;

    protected FileLogger(Context context, Thread.UncaughtExceptionHandler exceptionHandler) {
        super(context, "inlocomedia_eoitnhdentuiolceaoafdsfasueid", null, 1, exceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FileLogger a(Context context) {
        if (c != null) return c;
        Class<FileLogger> clazz = FileLogger.class;
        synchronized (FileLogger.class) {
            if (c != null) return c;
            c = new FileLogger(context, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable ex) {
                    throw new RuntimeException(ex);
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return c;
        }
    }

    public synchronized void onCreate(SQLiteDatabase db) {
        try {
            db.execSQL("CREATE TABLE entries(_id INTEGER PRIMARY KEY AUTOINCREMENT, date INTEGER, message TEXT);");
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
        }
    }

    public synchronized void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        try {
            db.execSQL("DROP TABLE IF EXISTS entries");
            this.onCreate(db);
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
        }
    }

    public synchronized void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        try {
            db.execSQL("DROP TABLE IF EXISTS entries");
            this.onCreate(db);
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
        }
    }

    public static void clearDatabase(Context context) {
        FileLogger fileLogger = FileLogger.a(context);
        try {
            SQLiteDatabase sQLiteDatabase = fileLogger.openDatabase();
            if (sQLiteDatabase == null) {
                return;
            }
            sQLiteDatabase.delete(TABLE_NAME, null, null);
            fileLogger.closeDatabase();
        }
        catch (Throwable throwable) {
            fileLogger.onUnexpectedError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static synchronized List<LogEntry> getEntries(Context context) {
        Cursor cursor = null;
        ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>();
        FileLogger fileLogger = FileLogger.a(context);
        try {
            SQLiteDatabase sQLiteDatabase = fileLogger.openDatabase();
            if (sQLiteDatabase == null) {
                List<LogEntry> list = null;
                return list;
            }
            cursor = sQLiteDatabase.query(TABLE_NAME, null, null, null, null, null, null);
            int n = cursor.getColumnIndex(COL_DATE);
            int n2 = cursor.getColumnIndex(COL_MESSAGE);
            while (cursor.moveToNext()) {
                LogEntry logEntry = new LogEntry(cursor.getLong(n), cursor.getString(n2));
                arrayList.add(0, logEntry);
            }
            Collections.sort(arrayList, new Comparator<LogEntry>(){

                public int a(LogEntry logEntry, LogEntry logEntry2) {
                    long l = logEntry2.date;
                    long l2 = logEntry.date;
                    if (l > l2) {
                        return 1;
                    }
                    if (l2 > l) {
                        return -1;
                    }
                    return 0;
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((LogEntry)object, (LogEntry)object2);
                }
            });
        }
        catch (Throwable throwable) {
            fileLogger.onUnexpectedError(throwable);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            fileLogger.closeDatabase();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void dumpToFile(Context context) {
        BufferedWriter bufferedWriter = null;
        try {
            File file = Environment.getExternalStorageDirectory();
            File file2 = new File(file.getAbsolutePath() + "/inlocomedia_logs/");
            boolean bl = file2.mkdirs();
            if (!bl && !file2.exists()) {
                throw new IllegalStateException("Failed to create log file at: " + file2);
            }
            List<LogEntry> list = FileLogger.getEntries(context);
            File file3 = new File(file2, "sdk_logs");
            if (file3.exists()) {
                file3.delete();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file3, true));
            for (LogEntry logEntry : list) {
                bufferedWriter.write(b.format(new Date(logEntry.date)));
                bufferedWriter.write(": ");
                bufferedWriter.write(logEntry.message);
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            Log.w((String)a, (Throwable)exception);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @VisibleForTesting
    public static void reset(Context context) {
        if (c != null) {
            FileLogger fileLogger = FileLogger.a(context);
            SQLiteDatabase sQLiteDatabase = fileLogger.openDatabase();
            if (sQLiteDatabase != null) {
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS entries");
            }
            fileLogger.closeDatabase();
            fileLogger.closeNow();
            c = null;
        }
    }

    public static void insert(Context context, String message) {
    }

    public static class LogEntry {
        public final long date;
        public final String message;

        public LogEntry(long date, String message) {
            this.date = date;
            this.message = message;
        }
    }
}

