/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.Nullable;
import com.inlocomedia.android.core.util.TimeoutTimer;
import com.inlocomedia.android.core.util.Validator;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LazyCloseSQLiteOpenHelper
extends SQLiteOpenHelper {
    private final AtomicInteger a = new AtomicInteger();
    private SQLiteDatabase b;
    private TimeoutTimer c;
    private WeakReference<Thread.UncaughtExceptionHandler> d;
    private Runnable e = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper = LazyCloseSQLiteOpenHelper.this;
                synchronized (lazyCloseSQLiteOpenHelper) {
                    Validator.notMainThread("Database methods should not be called on the main thread");
                    if (LazyCloseSQLiteOpenHelper.this.a.intValue() == 0 && LazyCloseSQLiteOpenHelper.this.b != null && LazyCloseSQLiteOpenHelper.this.b.isOpen()) {
                        LazyCloseSQLiteOpenHelper.this.b.close();
                    }
                }
            }
            catch (Throwable throwable) {
                LazyCloseSQLiteOpenHelper.this.onUnexpectedError(throwable);
            }
        }
    };

    protected LazyCloseSQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, Thread.UncaughtExceptionHandler exceptionHandler) {
        super(context, name, factory, version);
        if (exceptionHandler != null) {
            this.d = new WeakReference<Thread.UncaughtExceptionHandler>(exceptionHandler);
        }
    }

    protected int getDelaySeconds() {
        return 60;
    }

    @Nullable
    public synchronized SQLiteDatabase openDatabase() {
        try {
            Validator.notMainThread("Database methods should not be called on the main thread");
            if (this.a.incrementAndGet() == 1) {
                this.b = this.getWritableDatabase();
            }
            if (this.c != null) {
                this.c.stop();
            }
            this.c = new TimeoutTimer();
            this.c.start(this.e, this.getDelaySeconds(), TimeUnit.SECONDS);
            return this.b;
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
            return null;
        }
    }

    public synchronized void closeDatabase() {
        try {
            Validator.notMainThread("Database methods should not be called on the main thread");
            this.a.decrementAndGet();
        }
        catch (Throwable throwable) {
            this.onUnexpectedError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeNow() {
        block6: {
            try {
                Validator.notMainThread("Database methods should not be called on the main thread");
                if (this.a.intValue() != 0 || this.b == null || !this.b.isOpen()) break block6;
                this.b.close();
                LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper = this;
                synchronized (lazyCloseSQLiteOpenHelper) {
                    if (this.c != null) {
                        this.c.stop();
                    }
                }
            }
            catch (Throwable throwable) {
                this.onUnexpectedError(throwable);
            }
        }
    }

    protected final void onUnexpectedError(Throwable t) {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        if (this.d != null && (uncaughtExceptionHandler = (Thread.UncaughtExceptionHandler)this.d.get()) != null) {
            uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
        }
    }
}

