/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.cache;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.StatFs;
import android.util.Log;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.ThreadPool;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class DiskCache<K, V> {
    public static final int AUTO_MAX_CACHE_SIZE = 0;
    public static final int DEFAULT_AUTO_TRIM_FREQUENCY = 10;
    public static final long DEFAULT_TRIM_BY_DATE_FREQUENCY_LIMIT = 259200000L;
    public static final int AUTO_TRIM_DISABLED = 0;
    static final String a = Logger.makeTag(DiskCache.class);
    private final File b;
    private final String c;
    private final String d;
    private final ConcurrentLinkedQueue<File> e = new ConcurrentLinkedQueue();
    private final a f;
    private final Comparator<File> g = new Comparator<File>(){

        public int a(File file, File file2) {
            return Long.valueOf(file.lastModified()).compareTo(file2.lastModified());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((File)object, (File)object2);
        }
    };
    private ThreadPoolExecutor h;
    private long i = 0L;
    private MessageDigest j;
    private int k = 10;
    private long l = 259200000L;
    private int m = 1;
    private long n;
    private long o;

    public DiskCache(File cacheBase, String cachePrefix, String cacheSuffix, long expirationTime) {
        this.b = cacheBase;
        this.c = cachePrefix;
        this.d = cacheSuffix;
        this.l = expirationTime;
        this.f = new a();
        this.h = ThreadPool.cacheExecutor();
        try {
            this.j = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                this.j = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                RuntimeException runtimeException = new RuntimeException("No available hashing algorithm");
                runtimeException.initCause(noSuchAlgorithmException2);
                throw runtimeException;
            }
        }
        this.b();
    }

    public static void inputStreamToOutputStream(InputStream is, OutputStream os) throws IOException {
        int n = 81960;
        byte[] byArray = new byte[81960];
        int n2 = is.read(byArray, 0, 81960);
        while (n2 > 0) {
            os.write(byArray, 0, n2);
            n2 = is.read(byArray, 0, 81960);
        }
    }

    public void setCacheMaxSize(long maxSize) {
        this.i = maxSize;
    }

    public void setCacheTimeLimit(long maxTime) {
        this.l = maxTime;
    }

    public void setAutoTrimFrequency(int autoTrimFrequency) {
        this.k = autoTrimFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        long l = this.getCacheDiskUsage();
        long l2 = this.c();
        DiskCache diskCache = this;
        synchronized (diskCache) {
            this.n = l;
            this.o = l2;
        }
    }

    private void b() {
        this.h.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskCache.this.a();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    private long c() {
        if (Build.VERSION.SDK_INT >= 9) {
            return this.b.getUsableSpace();
        }
        StatFs statFs = new StatFs(this.b.getAbsolutePath());
        return (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
    }

    public long getUsedSpace() {
        return this.n;
    }

    public File getFile(K key) {
        return new File(this.b, (this.c != null ? this.c : "") + this.hash(key) + (this.d != null ? this.d : ""));
    }

    public synchronized void put(K key, V value) throws IOException {
        File file = this.getFile(key);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.toDisk(key, value, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        this.n += file.length();
        this.a(file);
        this.d();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream putRaw(K key, InputStream value) throws IOException {
        FileInputStream fileInputStream = null;
        File file = this.getFile(key);
        File file2 = new File(file.getAbsolutePath() + ".temp");
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            DiskCache.inputStreamToOutputStream(value, fileOutputStream);
            DiskCache diskCache = this;
            synchronized (diskCache) {
                file.delete();
                file2.renameTo(file);
            }
            bl = true;
        }
        finally {
            if (!bl) {
                file.delete();
                file2.delete();
            }
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        if (bl) {
            this.n += file.length();
            this.a(file);
            this.d();
            fileInputStream = new FileInputStream(file);
        }
        return fileInputStream;
    }

    private void a(File file) {
        if (this.e.contains(file)) {
            this.e.remove(file);
        }
        file.setLastModified(System.currentTimeMillis());
        this.e.add(file);
    }

    protected void touchKey(K key) {
        this.a(this.getFile(key));
    }

    private void d() {
        if (this.k == 0) {
            return;
        }
        this.m = (this.m + 1) % this.k;
        if (this.m == 0 && this.n > Math.min(this.o, this.i)) {
            this.h.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DiskCache.this.trim();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        this.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized V get(K key) throws IOException {
        File file = this.getFile(key);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        V v = null;
        try {
            fileInputStream = new FileInputStream(file);
            v = this.fromDisk(key, fileInputStream);
            this.a(file);
        }
        finally {
            if (fileInputStream != null && fileInputStream != v) {
                ((InputStream)fileInputStream).close();
            }
        }
        return v;
    }

    public final synchronized boolean contains(K key) {
        File file = this.getFile(key);
        return file.exists();
    }

    public synchronized boolean clear(K key) {
        File file = this.getFile(key);
        if (!file.exists()) {
            return true;
        }
        long l = file.length();
        boolean bl = file.delete();
        if (bl) {
            this.n -= l;
        }
        return bl;
    }

    private synchronized boolean b(File file) {
        if (!file.exists()) {
            return true;
        }
        long l = file.length();
        boolean bl = file.delete();
        if (bl) {
            this.n -= l;
        }
        return bl;
    }

    public synchronized boolean clear() {
        boolean bl = true;
        for (File file : this.b.listFiles(this.f)) {
            if (file.delete()) continue;
            Log.e((String)a, (String)("error deleting " + file));
            bl = false;
        }
        return bl;
    }

    public void waitForThreadsToFinish() throws InterruptedException {
        this.h.shutdownNow();
        this.h.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        this.h = ThreadPool.cacheExecutor();
    }

    public int getCacheEntryCount() {
        return this.b.listFiles(this.f).length;
    }

    public long getCacheDiskUsage() {
        long l = 0L;
        File[] fileArray = this.b.listFiles(this.f);
        if (fileArray != null) {
            for (File file : fileArray) {
                l += file.length();
            }
        }
        return l;
    }

    public synchronized void trimByDate() {
        File[] fileArray = this.b.listFiles(this.f);
        Arrays.sort(fileArray, new Comparator<File>(){

            public int a(File file, File file2) {
                return Long.valueOf(file.lastModified()).compareTo(file2.lastModified());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((File)object, (File)object2);
            }
        });
        int n = fileArray.length - 1;
        long l = System.currentTimeMillis();
        for (int i = n; i >= n / 2; --i) {
            if (l - fileArray[i].lastModified() <= this.l) continue;
            if (Environment.isCommunicationDebug()) {
                Log.d((String)a, (String)("Removing old file: " + fileArray[i]));
            }
            this.b(fileArray[i]);
        }
    }

    public synchronized long trim() {
        this.trimByDate();
        long l = this.c();
        long l2 = this.i > 0L ? this.i : this.c() / 10L;
        l2 = Math.min(l, l2);
        long l3 = Math.max(0L, this.getCacheDiskUsage() - l2);
        if (l3 == 0L) {
            return 0L;
        }
        long l4 = 0L;
        List<File> list = Arrays.asList(this.b.listFiles(this.f));
        Collections.sort(list, this.g);
        Object object = list.iterator();
        while (object.hasNext()) {
            File file = object.next();
            if (this.e.contains(file)) continue;
            long l5 = file.length();
            if (this.b(file)) {
                l4 += l5;
                if (Environment.isCommunicationDebug()) {
                    Log.d((String)a, (String)("trimmed unqueued " + file.getName() + " from cache."));
                }
            }
            if (l4 < l3) continue;
            break;
        }
        while (l4 < l3 && !this.e.isEmpty() && (object = this.e.poll()) != null) {
            long l6 = ((File)object).length();
            if (this.b((File)object)) {
                l4 += l6;
                if (!Environment.isCommunicationDebug()) continue;
                Log.d((String)a, (String)("trimmed " + ((File)object).getName() + " from cache."));
                continue;
            }
            Log.e((String)a, (String)("error deleting " + object));
        }
        if (Environment.isCommunicationDebug()) {
            Log.d((String)a, (String)("trimmed a total of " + l4 + " bytes from cache."));
        }
        return l4;
    }

    protected abstract void toDisk(K var1, V var2, OutputStream var3);

    protected abstract V fromDisk(K var1, InputStream var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hash(K key) {
        byte[] byArray;
        Object object = this.j;
        synchronized (object) {
            this.j.update(key.toString().getBytes());
            byArray = this.j.digest();
        }
        object = new BigInteger(1, byArray);
        String string = ((BigInteger)object).toString(16);
        if (string.length() % 2 != 0) {
            return "0" + string;
        }
        return string;
    }

    private class a
    implements FileFilter {
        private a() {
        }

        @Override
        public boolean accept(File pathname) {
            String string = pathname.getName();
            return !(DiskCache.this.c != null && !string.startsWith(DiskCache.this.c) || DiskCache.this.d != null && !string.endsWith(DiskCache.this.d));
        }
    }
}

