/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.cache;

import android.util.Log;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.communication.cache.DiskCache;
import com.inlocomedia.android.core.util.StreamHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayDiskCache
extends DiskCache<String, byte[]> {
    public ByteArrayDiskCache(File cacheBase, String cachePrefix, String cacheSufix, long expirationTime) {
        super(cacheBase, cachePrefix, cacheSufix, expirationTime);
    }

    public ByteArrayDiskCache(File cacheBase, String cachePrefix, String cacheSufix) {
        super(cacheBase, cachePrefix, cacheSufix, 259200000L);
    }

    @Override
    protected void toDisk(String key, byte[] data, OutputStream out) {
        block2: {
            try {
                out.write(data);
            }
            catch (IOException iOException) {
                if (!Environment.isCommunicationDebug()) break block2;
                Log.w((String)a, (String)("Writing the key '" + key + "' to the cache has failed"), (Throwable)iOException);
            }
        }
    }

    @Override
    protected byte[] fromDisk(String key, InputStream in) {
        try {
            return StreamHelper.toByteArray(in);
        }
        catch (IOException iOException) {
            if (Environment.isCommunicationDebug()) {
                Log.w((String)a, (String)("Reading the key '" + key + "' from the cache has failed"), (Throwable)iOException);
            }
            return null;
        }
    }
}

