/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication;

import com.inlocomedia.android.core.communication.builders.HttpRequestBuilder;
import com.inlocomedia.android.core.communication.requests.HttpRequest;
import com.inlocomedia.android.core.communication.util.LoadState;
import java.util.concurrent.Future;

public final class CommunicationRequest<T> {
    private final HttpRequestBuilder<T> a;
    private LoadState b;
    private HttpRequest c;
    private Future<T> d;

    CommunicationRequest(HttpRequestBuilder<T> builder) {
        this.a = builder;
    }

    public synchronized void finish() {
        if (this.b != LoadState.CANCELED) {
            this.b = LoadState.FINISHED;
        }
        if (this.c != null && !this.c.isFinished()) {
            this.c.cancel();
        }
    }

    public synchronized boolean isActive() {
        return this.b != LoadState.CANCELED && this.b != LoadState.FINISHED;
    }

    public synchronized boolean isCanceled() {
        return this.b == LoadState.CANCELED;
    }

    public synchronized boolean isActiveAndFinish() {
        boolean bl = this.isActive();
        if (bl) {
            this.finish();
        }
        return bl;
    }

    public synchronized void start() {
        if (this.b != LoadState.CANCELED) {
            this.b = LoadState.RUNNING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        this.b = LoadState.CANCELED;
        if (this.d != null) {
            this.d.cancel(true);
        }
        if (this.c != null) {
            this.c.cancel();
        }
        CommunicationRequest communicationRequest = this;
        synchronized (communicationRequest) {
            this.notifyAll();
        }
    }

    public HttpRequestBuilder<T> getBuilder() {
        return this.a;
    }

    public HttpRequest getHttpRequest() {
        return this.c;
    }

    public synchronized void setHttpRequest(HttpRequest httpRequest) {
        this.c = httpRequest;
    }

    public void setFuture(Future<T> future) {
        this.d = future;
    }
}

