/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication;

import android.content.Context;
import android.util.Log;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.serialization.json.JsonableModel;
import com.inlocomedia.android.core.serialization.json.PersistentJsonableModel;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AuthenticationToken
extends PersistentJsonableModel {
    private static final String a = Logger.makeTag(AuthenticationToken.class);
    @JsonableModel.JsonField(key="app_id")
    private String b;
    @JsonableModel.JsonField(key="app_secret")
    private String c;
    @JsonableModel.JsonField(key="access_token")
    private String d = "";
    @JsonableModel.JsonField(key="expires_in")
    private long e = 7000000L;
    private long f = 0L;

    public abstract String getAuthenticationUrl();

    public AuthenticationToken(int version) {
        super(version);
    }

    public AuthenticationToken(Context context, int version, String id, String secret) {
        super(version);
        this.setAppIdAndSecret(context, id, secret);
    }

    public String getClientId() {
        return this.b;
    }

    public String getSecret() {
        return this.c;
    }

    public String getToken() {
        return this.d;
    }

    public long getTokenExpirationTime() {
        return this.e;
    }

    public long getTokenT1() {
        return this.f;
    }

    public boolean isTokenValueValid() {
        return this.d != null && !this.d.isEmpty();
    }

    public void setAppIdAndSecret(Context context, String clientId, String secret) {
        if (clientId != null && secret != null) {
            this.b = clientId;
            this.c = secret;
            this.d = "";
            this.e = 7000000L;
            this.f = 1L;
            this.save(context);
        }
    }

    public void setToken(String token) {
        this.d = token;
    }

    public void setTokenExpirationTime(long tokenExpiresIn) {
        this.e = tokenExpiresIn;
    }

    public void setTokenDefaultExpirationTime() {
        this.e = 7000000L;
    }

    public void setTokenT1(long tokenT1) {
        this.f = tokenT1;
    }

    public boolean isValid() {
        return this.b != null && this.c != null;
    }

    public void update(JSONObject json) {
        block5: {
            try {
                if (json.has("access_token")) {
                    this.d = json.getString("access_token");
                }
                if (json.has("expires_in")) {
                    this.e = json.getLong("expires_in") * 1000L;
                } else {
                    this.setTokenDefaultExpirationTime();
                }
                this.f = System.currentTimeMillis();
            }
            catch (JSONException jSONException) {
                if (!Environment.isCommunicationDebug()) break block5;
                Log.w((String)a, (String)"Authentication Error", (Throwable)jSONException);
            }
        }
    }

    @Override
    public boolean clear(Context context) {
        return super.clear(context);
    }

    public String getTokenKey() {
        return "access_token";
    }

    @Override
    public synchronized boolean restore(Context context) {
        return super.restore(context);
    }
}

