/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.common;

import android.location.Address;
import android.support.annotation.NonNull;
import com.inlocomedia.android.common.private.jx;
import com.inlocomedia.android.core.annotations.ApiAccess;
import java.util.Locale;

@ApiAccess
public class TransactionAddress {
    private static final String BILLING_TYPE = "billing";
    private static final String SHIPPING_TYPE = "shipping";
    private static final String HOME_TYPE = "home";
    private final String type;
    private final Address address;

    public TransactionAddress(@NonNull String type, @NonNull Address address) {
        this.type = type;
        this.address = address;
    }

    private TransactionAddress(Builder builder) {
        this.type = builder.type;
        this.address = new Address(builder.locale);
        this.address.setCountryName(builder.countryName);
        this.address.setCountryCode(builder.countryCode);
        this.address.setAdminArea(builder.adminArea);
        this.address.setSubAdminArea(builder.subAdminArea);
        this.address.setLocality(builder.locality);
        this.address.setSubLocality(builder.subLocality);
        this.address.setThoroughfare(builder.thoroughfare);
        this.address.setSubThoroughfare(builder.subThoroughfare);
        this.address.setPostalCode(builder.postalCode);
        if (builder.latitude != null && builder.longitude != null) {
            this.address.setLatitude(builder.latitude.doubleValue());
            this.address.setLongitude(builder.longitude.doubleValue());
        }
        if (builder.addressLine != null) {
            this.address.setAddressLine(0, builder.addressLine);
        }
    }

    public static TransactionAddress billingAddress(@NonNull Address address) {
        return new TransactionAddress(BILLING_TYPE, address);
    }

    public static TransactionAddress shippingAddress(@NonNull Address address) {
        return new TransactionAddress(SHIPPING_TYPE, address);
    }

    public static TransactionAddress homeAddress(@NonNull Address address) {
        return new TransactionAddress(HOME_TYPE, address);
    }

    public static Builder newBillingAddressBuilder(@NonNull Locale locale) {
        return new Builder(BILLING_TYPE, locale);
    }

    public static Builder newShippingAddressBuilder(@NonNull Locale locale) {
        return new Builder(SHIPPING_TYPE, locale);
    }

    public static Builder newHomeAddressBuilder(@NonNull Locale locale) {
        return new Builder(HOME_TYPE, locale);
    }

    public String getType() {
        return this.type;
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        TransactionAddress transactionAddress = (TransactionAddress)o2;
        if (this.type != null ? !this.type.equals(transactionAddress.type) : transactionAddress.type != null) {
            return false;
        }
        return jx.a(this.address, transactionAddress.address);
    }

    public int hashCode() {
        int n2 = this.type != null ? this.type.hashCode() : 0;
        n2 = 31 * n2 + (this.address != null ? jx.a(this.address) : 0);
        return n2;
    }

    public String toString() {
        return "TransactionAddress{type='" + this.type + '\'' + ", address=" + this.address + '}';
    }

    @ApiAccess
    public static class Builder {
        @NonNull
        private String type;
        @NonNull
        private Locale locale;
        private String countryName;
        private String countryCode;
        private String adminArea;
        private String subAdminArea;
        private String locality;
        private String subLocality;
        private String thoroughfare;
        private String subThoroughfare;
        private String postalCode;
        private Double latitude;
        private Double longitude;
        private String addressLine;

        public Builder(@NonNull String type, @NonNull Locale locale) {
            this.locale = locale;
            this.type = type;
        }

        public Builder countryName(String countryName) {
            this.countryName = countryName;
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder adminArea(String adminArea) {
            this.adminArea = adminArea;
            return this;
        }

        public Builder subAdminArea(String subAdminArea) {
            this.subAdminArea = subAdminArea;
            return this;
        }

        public Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder subLocality(String subLocality) {
            this.subLocality = subLocality;
            return this;
        }

        public Builder thoroughfare(String thoroughfare) {
            this.thoroughfare = thoroughfare;
            return this;
        }

        public Builder subThoroughfare(String subThoroughfare) {
            this.subThoroughfare = subThoroughfare;
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder addressLine(String addressLine) {
            this.addressLine = addressLine;
            return this;
        }

        public TransactionAddress build() {
            return new TransactionAddress(this);
        }
    }
}

