/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.common;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.inlocomedia.android.common.ConsentDialogOptions;
import com.inlocomedia.android.common.ConsentResult;
import com.inlocomedia.android.common.InLoco;
import com.inlocomedia.android.common.listener.ConsentListener;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.util.Validator;

@ApiAccess
public class ConsentRequest {
    private Dialog dialog;
    private boolean finished = false;

    void show(final @NonNull ConsentDialogOptions options, final @Nullable ConsentListener consentListener) {
        final Context context = options.getContext();
        InLoco.checkConsent(context, new ConsentListener(){

            @Override
            public void onConsentResult(ConsentResult result) {
                block9: {
                    try {
                        if (result.isWaitingConsent()) {
                            ConsentRequest.this.dialog = (Dialog)new AlertDialog.Builder(options.getContext()).setTitle((CharSequence)options.getTitle()).setPositiveButton((CharSequence)options.getAcceptText(), new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int id2) {
                                    InLoco.allowConsentTypes(context, options.getConsentTypes());
                                    if (consentListener != null) {
                                        InLoco.checkConsent(context, consentListener, options.getConsentTypes());
                                    }
                                }
                            }).setNegativeButton((CharSequence)options.getDenyText(), new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int id2) {
                                    InLoco.denyConsentTypes(context, options.getConsentTypes());
                                    if (consentListener != null) {
                                        InLoco.checkConsent(context, consentListener, options.getConsentTypes());
                                    }
                                }
                            }).setMessage((CharSequence)options.getMessage()).setCancelable(false).create();
                            if (!ConsentRequest.this.finished) {
                                if (options.getContext() instanceof Activity) {
                                    Activity activity = (Activity)options.getContext();
                                    if (!(activity.isFinishing() || Validator.isAboveOrEqualsAndroid17() && activity.isDestroyed())) {
                                        ConsentRequest.this.dialog.show();
                                    }
                                } else {
                                    ConsentRequest.this.dialog.show();
                                }
                            }
                        } else if (consentListener != null) {
                            consentListener.onConsentResult(result);
                        }
                    }
                    catch (Throwable throwable) {
                        DevLogger.e((String)"Failed to present consent dialog", (Throwable)throwable);
                        if (consentListener == null) break block9;
                        consentListener.onConsentResult(new ConsentResult());
                    }
                }
            }
        }, options.getConsentTypes());
    }

    public void dismiss() {
        this.finished = true;
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }
}

