/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.common;

import android.content.Context;
import android.location.Address;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.inlocomedia.android.common.ConsentDialogOptions;
import com.inlocomedia.android.common.ConsentRequest;
import com.inlocomedia.android.common.ConsentResult;
import com.inlocomedia.android.common.ConsentState;
import com.inlocomedia.android.common.ConsentTypes;
import com.inlocomedia.android.common.InLocoOptions;
import com.inlocomedia.android.common.core.d;
import com.inlocomedia.android.common.core.i;
import com.inlocomedia.android.common.listener.ConsentListener;
import com.inlocomedia.android.common.listener.InLocoListener;
import com.inlocomedia.android.common.listener.Result;
import com.inlocomedia.android.common.private.an;
import com.inlocomedia.android.common.private.gd;
import com.inlocomedia.android.common.private.gp;
import com.inlocomedia.android.common.private.jb;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@ApiAccess
public class InLoco {
    private InLoco() {
    }

    public static void init(@NonNull Context context) {
        i.a(context);
    }

    public static void init(@NonNull Context context, @NonNull InLocoOptions inLocoOptions) {
        i.a(context, inLocoOptions);
    }

    public static void setUserId(Context context, final String userId) {
        if (userId == null || userId.isEmpty()) {
            DevLogger.w((String)"Invalid UserId received: user won't be set. To clear the UserId, please call clearUserId().");
            return;
        }
        i.a(context, new d(){

            @Override
            public void a() {
                gp.o().a(userId);
            }

            @Override
            public void b() {
                DevLogger.w((String)"SDK initialization unsuccessful. Check the logs for more details.");
            }
        });
    }

    public static void clearUserId(Context context) {
        i.a(context, new d(){

            @Override
            public void a() {
                gp.o().a();
            }

            @Override
            public void b() {
                DevLogger.w((String)"SDK initialization unsuccessful. Check the logs for more details.");
            }
        });
    }

    public static void setAddress(Context context, final Address address) {
        if (address == null) {
            DevLogger.w((String)"Null Address received: user address won't be set. If you wanted to clear user address, please call clearUserAddress().");
            return;
        }
        i.a(context, new d(){

            @Override
            public void a() {
                gp.o().a(new jb(address).a());
            }

            @Override
            public void b() {
                DevLogger.w((String)"SDK initialization unsuccessful. Check the logs for more details.");
            }
        });
    }

    public static void clearAddress(Context context) {
        i.a(context, new d(){

            @Override
            public void a() {
                gp.o().b();
            }

            @Override
            public void b() {
                DevLogger.w((String)"SDK initialization unsuccessful. Check the logs for more details.");
            }
        });
    }

    public static ConsentRequest requestPrivacyConsent(@NonNull ConsentDialogOptions options) {
        return InLoco.requestPrivacyConsent(options, null);
    }

    public static ConsentRequest requestPrivacyConsent(final @NonNull ConsentDialogOptions options, final @Nullable ConsentListener listener) {
        final ConsentRequest consentRequest = new ConsentRequest();
        i.a(options.getContext(), new d(){

            @Override
            public void a() {
                consentRequest.show(options, listener);
            }

            @Override
            public void b() {
                DevLogger.w((String)"SDK initialization unsuccessful. Check the logs for more details.");
                if (listener != null) {
                    InLoco.runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onConsentResult(new ConsentResult());
                        }
                    });
                }
            }
        });
        return consentRequest;
    }

    public static void givePrivacyConsent(@NonNull Context context, boolean consent) {
        Set<String> set = consent ? ConsentTypes.ALL : ConsentTypes.NONE;
        InLoco.givePrivacyConsent(context, set);
    }

    public static void givePrivacyConsent(@NonNull Context context, @NonNull Set<String> consentTypes) {
        InLoco.setAllowedConsentTypes(context, consentTypes);
    }

    public static void setAllowedConsentTypes(@NonNull Context context, final @NonNull Set<String> consentTypes) {
        final Context context2 = context.getApplicationContext();
        i.a(context, new d(){

            @Override
            public void a() {
                an an2 = an.a(context2);
                gd gd2 = gd.a(consentTypes, an2.h());
                an2.a(gd2);
                gp.i().a(gd2);
            }

            @Override
            public void b() {
                DevLogger.w((String)"SDK initialization unsuccessful. Check the logs for more details.");
            }
        });
    }

    public static void allowConsentTypes(@NonNull Context context, String ... consentTypes) {
        InLoco.allowConsentTypes(context, new HashSet<String>(Arrays.asList(consentTypes)));
    }

    public static void allowConsentTypes(@NonNull Context context, final @NonNull Set<String> consentTypes) {
        Context context2 = context.getApplicationContext();
        i.a(context, new d(){

            @Override
            public void a() {
                gp.i().b(consentTypes);
            }

            @Override
            public void b() {
                DevLogger.w((String)"SDK initialization unsuccessful. Check the logs for more details.");
            }
        });
    }

    public static void denyConsentTypes(@NonNull Context context, String ... consentTypes) {
        InLoco.denyConsentTypes(context, new HashSet<String>(Arrays.asList(consentTypes)));
    }

    public static void denyConsentTypes(@NonNull Context context, final @NonNull Set<String> consentType) {
        Context context2 = context.getApplicationContext();
        i.a(context, new d(){

            @Override
            public void a() {
                gp.i().c(consentType);
            }

            @Override
            public void b() {
                DevLogger.w((String)"SDK initialization unsuccessful. Check the logs for more details.");
            }
        });
    }

    public static void checkConsent(@NonNull Context context, @NonNull ConsentListener listener, String ... types) {
        InLoco.checkConsent(context, listener, new HashSet<String>(Arrays.asList(types)));
    }

    public static void checkConsent(@NonNull Context context, final @NonNull ConsentListener listener, final @NonNull Set<String> types) {
        Context context2 = context.getApplicationContext();
        i.a(context, new d(){

            @Override
            public void a() {
                final Map<String, ConsentState> map = gp.i().a(types);
                InLoco.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onConsentResult(new ConsentResult(map));
                    }
                });
            }

            @Override
            public void b() {
                DevLogger.w((String)"SDK initialization unsuccessful. Check the logs for more details.");
            }
        });
    }

    @Deprecated
    public static void checkPrivacyConsentMissing(@NonNull Context context, final @NonNull InLocoListener<Boolean> listener) {
        Context context2 = context.getApplicationContext();
        HashSet<String> hashSet = new HashSet<String>(ConsentTypes.ALL);
        hashSet.addAll(gd.a);
        InLoco.checkConsent(context, new ConsentListener(){

            @Override
            public void onConsentResult(ConsentResult result) {
                final Result<Boolean> result2 = new Result<Boolean>(true, result.isWaitingConsent());
                InLoco.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onResult(result2);
                    }
                });
            }
        }, hashSet);
    }

    public static void getInstallationId(@NonNull Context context, final @NonNull InLocoListener<String> listener) {
        Context context2 = context.getApplicationContext();
        i.a(context, new d(){

            @Override
            public void a() {
                final String string = gp.z().a();
                InLoco.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onResult(new Result<String>(string != null, string));
                    }
                });
            }

            @Override
            public void b() {
                DevLogger.w((String)"SDK initialization unsuccessful. Check the logs for more details.");
                InLoco.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onResult(new Result<Object>(false, null));
                    }
                });
            }
        });
    }

    private static void runOnMainThread(Runnable r2) {
        new Handler(Looper.getMainLooper()).post(r2);
    }
}

