/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.nativeads.adapters;

import android.content.Context;
import android.database.DataSetObserver;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.core.o;
import com.inlocomedia.android.ads.nativeads.NativeAdViewMapper;
import com.inlocomedia.android.ads.nativeads.adapters.a;
import com.inlocomedia.android.ads.private.ba;
import com.inlocomedia.android.core.annotations.ApiAccess;
import java.lang.ref.WeakReference;

@ApiAccess
public class NativeAdListAdapter
extends BaseAdapter {
    private final a mManager;
    private final BaseAdapter mOriginalAdapter;
    private WeakReference<ListView> mListViewRef;
    private AbsListView.OnScrollListener mExternalScrollListener;
    private AbsListView.OnScrollListener mOnScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (NativeAdListAdapter.this.mExternalScrollListener != null) {
                NativeAdListAdapter.this.mExternalScrollListener.onScrollStateChanged(view, scrollState);
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            NativeAdListAdapter.this.mManager.a(firstVisibleItem, firstVisibleItem + visibleItemCount - 1);
            if (NativeAdListAdapter.this.mExternalScrollListener != null) {
                NativeAdListAdapter.this.mExternalScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        }
    };

    public NativeAdListAdapter(Context context, BaseAdapter adapter, @LayoutRes int resource) {
        this(context, adapter, resource, -1, null);
    }

    public NativeAdListAdapter(Context context, BaseAdapter adapter, @LayoutRes int resource, NativeAdViewMapper mapper) {
        this(context, adapter, resource, -1, mapper);
    }

    public NativeAdListAdapter(Context context, BaseAdapter adapter, @LayoutRes int resource, @IdRes int adFeedItemResId) {
        this(context, adapter, resource, adFeedItemResId, null);
    }

    public NativeAdListAdapter(Context context, BaseAdapter adapter, @LayoutRes int resource, @IdRes int adFeedItemResId, NativeAdViewMapper mapper) {
        o.e.a(context);
        this.registerDataSetObserver(adapter);
        this.mOriginalAdapter = adapter;
        this.mListViewRef = new WeakReference<Object>(null);
        this.mManager = new a(context, new ba(adapter), resource, adFeedItemResId, new a.b(){

            @Override
            public void a(int n2) {
                NativeAdListAdapter.this.notifyDataSetChanged();
            }
        }, mapper);
    }

    public void loadAds(AdRequest adRequest) {
        this.mManager.a(adRequest);
    }

    private void registerDataSetObserver(BaseAdapter adapter) {
        adapter.registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                NativeAdListAdapter.this.mManager.c();
                NativeAdListAdapter.this.notifyDataSetChanged();
            }

            public void onInvalidated() {
                NativeAdListAdapter.this.notifyDataSetInvalidated();
            }
        });
    }

    public int getCount() {
        return this.mManager.b();
    }

    public int getViewTypeCount() {
        return this.mManager.a();
    }

    public int getItemViewType(int position) {
        return this.mManager.a(position);
    }

    public Object getItem(int position) {
        return this.mManager.c(position);
    }

    public long getItemId(int position) {
        return this.mManager.d(position);
    }

    public boolean areAllItemsEnabled() {
        return this.mOriginalAdapter.areAllItemsEnabled();
    }

    public boolean hasStableIds() {
        return this.mOriginalAdapter.hasStableIds();
    }

    public boolean isEnabled(int position) {
        return this.mManager.f(position) || this.mOriginalAdapter.isEnabled(this.mManager.g(position));
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        this.updateListViewInstance(parent);
        View view = this.mManager.f(position) ? this.getAdItemView(position, convertView, parent) : this.mOriginalAdapter.getView(this.mManager.g(position), convertView, parent);
        return view;
    }

    private void updateListViewInstance(ViewGroup parent) {
        if (this.mListViewRef.get() == null && parent instanceof ListView) {
            ListView listView = (ListView)parent;
            this.mListViewRef = new WeakReference<ListView>(listView);
            listView.setOnScrollListener(this.mOnScrollListener);
        }
    }

    private View getAdItemView(int position, View convertView, ViewGroup parent) {
        if (convertView == null || convertView.getTag() == null || !(convertView.getTag() instanceof a.a)) {
            convertView = this.mManager.a(parent);
            convertView.setTag((Object)this.mManager.a(convertView));
        }
        this.mManager.a((a.a)convertView.getTag(), position);
        return convertView;
    }

    public int getAdjustedPosition(int originalPosition) {
        return this.mManager.h(originalPosition);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l2) {
        this.mExternalScrollListener = l2;
    }

    public void destroy() {
        this.mManager.e();
    }

    public BaseAdapter getOriginalAdapter() {
        return this.mOriginalAdapter;
    }
}

