/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.exception;

import com.inlocomedia.android.ads.exception.AdvertisementRequestException;
import com.inlocomedia.android.ads.exception.AdvertisementsUnavailableException;
import com.inlocomedia.android.core.exception.ErrorHandler;
import com.inlocomedia.android.core.exception.InLocoMediaAPIException;
import com.inlocomedia.android.core.exception.InLocoMediaException;

public class AdvertisementException
extends InLocoMediaAPIException {
    private static final long serialVersionUID = 841726579282987656L;
    private static final String ADVERTISEMENT = "advertisement";
    private static final String ADVERTISEMENT_UNAVAILABLE = "advertisement.no_ad_available";
    private static final String ADVERTISEMENT_INVALID_AD_TYPE = "advertisement.invalid_style_type";
    private static final String ADVERTISEMENT_INVALID_APP = "advertisement.invalid_app";
    private static final String ADVERTISEMENT_CLICK_TOKEN = "adv_clk_token";
    private static final String ADVERTISEMENT_IMAGE_TOKEN = "adv_img_view_token";
    public static final ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        public boolean shouldHandler(String errorType) {
            return errorType.equals(AdvertisementException.ADVERTISEMENT) || errorType.equals(AdvertisementException.ADVERTISEMENT_IMAGE_TOKEN) || errorType.equals(AdvertisementException.ADVERTISEMENT_CLICK_TOKEN);
        }

        public void handle(String error) throws InLocoMediaException {
            switch (error) {
                case "advertisement.no_ad_available": {
                    throw new AdvertisementsUnavailableException();
                }
                case "advertisement.invalid_style_type": {
                    throw new AdvertisementRequestException("Invalid AdType requested");
                }
                case "advertisement.invalid_app": {
                    throw new AdvertisementException("Invalid application");
                }
            }
            throw new AdvertisementException("Advertisement request error: " + error);
        }
    };

    public AdvertisementException(String error) {
        super(error);
    }

    public AdvertisementException(String error, Exception e2) {
        super(error, (Throwable)e2);
    }
}

