/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.interstitial;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.MutableContextWrapper;
import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.ads.AdActivity;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.core.c;
import com.inlocomedia.android.ads.core.j;
import com.inlocomedia.android.ads.interstitial.InterstitialAdListener;
import com.inlocomedia.android.ads.interstitial.InterstitialAdView;
import com.inlocomedia.android.ads.interstitial.b;
import com.inlocomedia.android.ads.private.ah;
import com.inlocomedia.android.ads.private.ai;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.util.ScreenHelper;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;

public class InterstitialAd {
    private static final int UNLOADED = 0;
    private static final int LOADING = 1;
    private static final int LOADED = 2;
    private static final int FINISHED = 3;
    private final MutableContextWrapper mContext;
    private ai mAd;
    private int mState;
    private int mRequestTimeout;
    private int mScreenOrientation;
    private InterstitialAdListener mListener;
    private InterstitialAdView mInterstitialAdView;

    public InterstitialAd(Context context) {
        Validator.notNull((Object)context, (String)"Context");
        this.mContext = new MutableContextWrapper(context);
        this.mRequestTimeout = 7;
        this.mScreenOrientation = -1;
        this.mState = j.b.a.isValid() ? 0 : 3;
    }

    public void loadAd() {
        AdRequest adRequest = null;
        if (j.b.a.isValid()) {
            adRequest = new AdRequest();
            adRequest.setUserProfile(UserProfile.getSavedProfile((Context)this.mContext));
        }
        this.loadAd(adRequest);
    }

    public void loadAd(final AdRequest request) {
        ThreadPool.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                DevLogger.i((String)("Loading InterstitialAd" + (request != null ? ". " + request : "")));
                if (!Validator.isValidSDKVersion()) {
                    DevLogger.w((String)"InterstitialAd.loadAd() failed. Invalid SDK Version");
                    InterstitialAd.this.mState = 3;
                    InterstitialAd.this.notifyOnAdError(AdError.INVALID_SDK_VERSION);
                    return;
                }
                if (InterstitialAd.this.mState != 1 && !j.b.a.isValid()) {
                    DevLogger.w((String)"InterstitialAd.loadAd() failed. Invalid sdk state");
                    InterstitialAd.this.mState = 3;
                    InterstitialAd.this.notifyOnAdError(AdError.INTERNAL_ERROR);
                    return;
                }
                if (InterstitialAd.this.mState == 0) {
                    InterstitialAd.this.mState = 1;
                    if (InterstitialAd.this.mScreenOrientation == -1) {
                        InterstitialAd.this.mScreenOrientation = ScreenHelper.getScreenOrientation((Context)InterstitialAd.this.mContext);
                    }
                    String string2 = "interstitial";
                    ah ah2 = new ah(string2, request, InterstitialAd.this.mRequestTimeout);
                    com.inlocomedia.android.ads.core.b<ai, Void> b2 = new com.inlocomedia.android.ads.core.b<ai, Void>((Context)InterstitialAd.this.mContext, ah2){

                        @Override
                        public void a(ai ai2) {
                            InterstitialAd.this.mAd = ai2;
                            InterstitialAd.this.loadInterstitialAdView();
                        }

                        @Override
                        public void a(AdError adError) {
                            InterstitialAd.this.notifyOnAdError(adError);
                        }
                    };
                    c.a(b2);
                } else if (InterstitialAd.this.mState == 1) {
                    DevLogger.w((String)"InterstitialAd load error: The InterstitialAd is already loading");
                } else if (InterstitialAd.this.mState == 2) {
                    DevLogger.w((String)"InterstitialAd load error: The InterstitialAd is loaded. Call the show method if you want to open it");
                    InterstitialAd.this.notifyOnAdReady();
                } else if (InterstitialAd.this.mState == 3) {
                    DevLogger.w((String)"InterstitialAd load error: The InterstitialAd is finished. Create another InterstitialAd object if you wish to show interstitials");
                    InterstitialAd.this.notifyOnAdError(AdError.INVALID_REQUEST);
                }
            }
        });
    }

    private void loadInterstitialAdView() {
        this.mInterstitialAdView = new InterstitialAdView((Context)this.mContext);
        this.mInterstitialAdView.setAdListener(new b(){

            @Override
            public void a(InterstitialAdView interstitialAdView) {
                InterstitialAd.this.mState = 2;
                InterstitialAd.this.notifyOnAdReady();
            }

            @Override
            public void a(InterstitialAdView interstitialAdView, AdError adError) {
                InterstitialAd.this.notifyOnAdError(adError);
            }
        });
        this.mInterstitialAdView.a(this.mAd);
    }

    protected void onActivityAttached(Activity activity) {
        ((MutableContextWrapper)this.getInterstitialAdView().getContext()).setBaseContext((Context)activity);
    }

    @VisibleForTesting(otherwise=3)
    protected InterstitialAdView getInterstitialAdView() {
        return this.mInterstitialAdView;
    }

    public void show() {
        ThreadPool.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                if (InterstitialAd.this.mState == 2) {
                    try {
                        AdActivity.startActivityToShowInterstitialAd((Context)InterstitialAd.this.mContext, InterstitialAd.this);
                        InterstitialAd.this.mState = 3;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        DevLogger.e((String)("InterstitialAd show error: Missing " + AdActivity.class.getName()));
                        InterstitialAd.this.notifyOnAdError(AdError.INVALID_REQUEST);
                    }
                } else if (InterstitialAd.this.mState == 3) {
                    DevLogger.w((String)"InterstitialAd show error: The InterstitialAd is finished. Create another InterstitialAd object if you wish to show interstitials");
                    InterstitialAd.this.notifyOnAdError(AdError.INVALID_REQUEST);
                } else {
                    DevLogger.w((String)"InterstitialAd show error: The InterstitialAd needs to be loaded before trying to show it");
                    InterstitialAd.this.notifyOnAdError(AdError.INVALID_REQUEST);
                }
            }
        });
    }

    public void setInterstitialAdListener(InterstitialAdListener listener) {
        this.mListener = listener;
    }

    public void setRequestTimeout(int timeoutInSeconds) {
        if (timeoutInSeconds < 5) {
            timeoutInSeconds = 5;
        }
        this.mRequestTimeout = timeoutInSeconds;
    }

    public boolean isLoaded() {
        return this.mState == 2;
    }

    public ai getAd() {
        return this.mAd;
    }

    public int getScreenOrientation() {
        return this.mScreenOrientation;
    }

    public void setScreenOrientation(int screenOrientation) {
        this.mScreenOrientation = screenOrientation;
    }

    protected void notifyOnAdOpened() {
        if (this.mListener != null) {
            this.mListener.onAdOpened(this);
        }
    }

    protected void notifyOnAdReady() {
        DevLogger.i((String)"The InterstitialAd is ready to be shown");
        if (this.mListener != null) {
            this.mListener.onAdReady(this);
        }
    }

    protected void notifyOnAdError(AdError adError) {
        DevLogger.w((String)("InterstitialAd error: " + (Object)((Object)adError) + ""));
        if (this.mListener != null) {
            this.mListener.onAdError(this, adError);
        }
    }

    protected void notifyOnAdLeftApplication() {
        DevLogger.i((String)"InterstitialAd has left application");
        if (this.mListener != null) {
            this.mListener.onAdLeftApplication(this);
        }
    }

    protected void notifyOnAdClosed() {
        DevLogger.i((String)"InterstitialAd is closed");
        if (this.mListener != null) {
            this.mListener.onAdClosed(this);
        }
    }
}

