/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import android.content.Context;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdManagerListener;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.core.b;
import com.inlocomedia.android.ads.core.c;
import com.inlocomedia.android.ads.core.f;
import com.inlocomedia.android.ads.core.g;
import com.inlocomedia.android.ads.core.j;
import com.inlocomedia.android.ads.exception.AdvertisementException;
import com.inlocomedia.android.ads.private.ag;
import com.inlocomedia.android.ads.private.ah;
import com.inlocomedia.android.ads.private.be;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.log.CriticalErrorManager;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.InvalidatableRunnable;
import com.inlocomedia.android.core.util.ScreenHelper;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.TimeUtils;
import com.inlocomedia.android.core.util.Validator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class AdManager {
    public static final String TAG = Logger.makeTag(AdManager.class);
    private static final int UNLOADED = 0;
    private static final int LOADING = 1;
    private static final int DEFAULT = 2;
    private static final int ON_AD_ERROR = 3;
    private static final int DESTROYED = 4;
    private static final int REFRESH_INTERVAL_DEFAULT = 30000;
    private static final int REFRESH_DISABLED = 0;
    private int mLoadState;
    private be mViewabilityTracker;
    @VisibleForTesting(otherwise=5)
    private long mRequestStartedTimestamp;
    @VisibleForTesting
    private long mRequestCompletedTimestamp;
    @VisibleForTesting
    private AdRequest mAdRequest;
    private a mAdRefresher;
    private long mRefreshInterval = 30000L;
    private String mAdUnitId;
    private ah mCurrentAd;
    private View mAdView;
    private boolean mIsAdViewable;
    private com.inlocomedia.android.ads.a mAdViewManagerBuilder;
    private AdType mRequestedType;
    private f mAdViewManager;
    private AdManagerListener mAdManagerListener;
    private f.a mAdViewManagerInterface = new f.a(){

        @Override
        public final void a(ah ah2, View view) {
            AdManager.this.mRequestCompletedTimestamp = SystemClock.elapsedRealtime();
            if (AdManager.this.mCurrentAd != null && AdManager.this.mCurrentAd != ah2) {
                AdManager.this.mViewabilityTracker.a(AdManager.this.mCurrentAd);
            }
            AdManager.this.mIsAdViewable = false;
            AdManager.this.mAdView = view;
            AdManager.this.mCurrentAd = ah2;
            AdManager.this.mViewabilityTracker.a(ah2, view, new be.b(){

                @Override
                public void a() {
                    AdManager.this.onVisualizationRegistered();
                }

                @Override
                public void a(boolean bl) {
                    AdManager.this.mIsAdViewable = bl;
                    AdManager.this.onVisibilityChanged(AdManager.this.mAdView, AdManager.this.mIsAdViewable);
                }
            });
            AdManager.this.mLoadState = 2;
            DevLogger.i((String)"Ad view is ready");
            AdManager.this.mAdRefresher.d();
            AdManager.this.mAdRefresher.a();
            if (AdManager.this.mAdManagerListener != null) {
                AdManager.this.mAdManagerListener.onAdViewReady(AdManager.this);
            }
        }

        @Override
        public boolean a(ah ah2) {
            return AdManager.this.mViewabilityTracker.b(ah2);
        }

        @Override
        public void a() {
            if (AdManager.this.mAdManagerListener != null) {
                AdManager.this.mAdManagerListener.onAdLeftApplication(AdManager.this);
            }
        }
    };

    public AdManager(com.inlocomedia.android.ads.a adViewManagerBuilder, AdType adType, be viewabilityTracker, AdManagerListener adManagerListener) {
        this.mViewabilityTracker = viewabilityTracker != null ? viewabilityTracker : new be();
        this.mIsAdViewable = false;
        this.mAdRefresher = new a(this);
        this.mAdManagerListener = adManagerListener;
        this.mRequestedType = adType;
        this.mAdViewManagerBuilder = adViewManagerBuilder;
        this.mLoadState = 0;
    }

    public final void loadAd(@NonNull Context context) {
        AdRequest adRequest = null;
        if (j.b.a.isValid()) {
            adRequest = new AdRequest();
            adRequest.setUserProfile(UserProfile.getSavedProfile(context));
        }
        this.loadAd(context, adRequest);
    }

    public final void loadAd(@NonNull Context context, AdRequest adRequest) {
        this.mRequestStartedTimestamp = SystemClock.elapsedRealtime();
        DevLogger.i((String)("Loading ad view" + (adRequest != null ? ". " + adRequest : "")));
        if (!this.mustRequestNewAd()) {
            return;
        }
        this.mAdRefresher.c();
        this.mAdRequest = adRequest;
        if (this.mAdRequest != null && this.mAdRequest.getAdUnitId() == null) {
            adRequest.setAdUnitId(this.mAdUnitId);
        }
        if (TimeUtils.hasElapsedEnoughTime((long)this.mRequestCompletedTimestamp, (long)SystemClock.elapsedRealtime(), (long)this.mRefreshInterval)) {
            this.requestAd(context, new ag(this.getType(), this.mAdRequest));
        } else {
            long l2 = SystemClock.elapsedRealtime() - this.mRequestCompletedTimestamp;
            this.mAdRefresher.a(this.mRefreshInterval - l2);
        }
    }

    private void requestAd(@NonNull Context context, ag target) {
        this.mLoadState = 1;
        b<ah, g> b2 = new b<ah, g>(context, target){

            @Override
            public void a(g g2) {
                AdManager.this.setRefreshInterval(g2.b());
            }

            @Override
            public void a(ah ah2) {
                AdManager.this.loadFrom(ah2);
            }

            @Override
            public void a(AdError adError) {
                AdManager.this.mRequestCompletedTimestamp = SystemClock.elapsedRealtime();
                AdManager.this.mLoadState = 3;
                AdManager.this.notifyAdError(adError);
                AdManager.this.mAdRefresher.a();
            }
        };
        c.a(b2);
    }

    public void loadFrom(ah advertisement) {
        try {
            f f2;
            if (this.mAdViewManager == null) {
                f2 = this.mAdViewManagerBuilder.a(advertisement).a();
            } else if (this.mAdViewManager.a(advertisement.a())) {
                f2 = this.mAdViewManager;
            } else {
                this.mAdViewManager.d();
                f2 = this.mAdViewManagerBuilder.a(advertisement).a();
            }
            f2.a(advertisement, this.mAdViewManagerInterface);
            this.mAdViewManager = f2;
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError((String)TAG, (Throwable)throwable, (Module)j.b.a, (boolean)true);
            this.mAdManagerListener.onAdError(this, AdError.INTERNAL_ERROR);
        }
    }

    private boolean mustRequestNewAd() {
        if (!Validator.isValidSDKVersion()) {
            this.mLoadState = 3;
            DevLogger.w((String)"loadAd() failed. Invalid SDK version.");
            this.notifyAdError(AdError.INVALID_SDK_VERSION);
            this.mAdRefresher.a();
            return false;
        }
        if (!j.b.a.isValid()) {
            this.mLoadState = 3;
            DevLogger.w((String)"loadAd() failed. The SDK is in a invalid state. Check the log for the error that caused it");
            this.notifyAdError(AdError.INTERNAL_ERROR);
            this.mAdRefresher.a();
            return false;
        }
        if (this.mLoadState == 4) {
            DevLogger.w((String)"loadAd() failed. Ad view already destroyed");
            this.notifyAdError(AdError.INVALID_REQUEST);
            return false;
        }
        if (this.mLoadState == 1) {
            DevLogger.w((String)"loadAd() was ignored. Ad view is already loading.");
            return false;
        }
        try {
            com.inlocomedia.android.ads.private.g.a(this);
        }
        catch (AdvertisementException advertisementException) {
            this.mLoadState = 3;
            DevLogger.w((String)("loadAd() failed. Invalid request with error: " + advertisementException.getFormattedMessage()));
            this.notifyAdError(AdError.INVALID_REQUEST);
            this.mAdRefresher.a();
            return false;
        }
        return true;
    }

    public void onVisualizationRegistered() {
        if (this.mAdViewManager != null) {
            this.mAdViewManager.e();
        }
    }

    private void onVisibilityChanged(View view, boolean visible) {
        if (view.isInEditMode() || !Validator.isValidSDKVersion()) {
            return;
        }
        if (visible) {
            this.mAdRefresher.b();
        } else {
            this.mAdRefresher.c();
        }
    }

    private void notifyAdError(AdError adError) {
        DevLogger.w((String)("AdManager error: (" + (Object)((Object)adError) + ")"));
        if (this.mAdManagerListener != null) {
            this.mAdManagerListener.onAdError(this, adError);
        }
    }

    public void resume() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        this.mAdRefresher.b();
    }

    public void pause() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        this.mAdRefresher.c();
    }

    public void destroy() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        this.mLoadState = 4;
        this.mAdRefresher.c();
        this.mViewabilityTracker.a();
        this.setRefreshInterval(0L);
        if (this.mAdView != null) {
            this.mAdView.setVisibility(8);
        }
    }

    public final boolean isLoaded() {
        return this.mLoadState == 2;
    }

    private void setRefreshInterval(long intervalInSeconds) {
        this.mRefreshInterval = intervalInSeconds;
    }

    private long getRefreshInterval() {
        return this.mRefreshInterval;
    }

    public void setRefreshEnabled(boolean enabled) {
        this.mRefreshInterval = enabled ? 30000L : 0L;
    }

    public final AdType getType() {
        return this.mRequestedType;
    }

    public final void setType(AdType type) {
        this.mRequestedType = type;
    }

    public void setAdUnitId(String adUnitId) {
        this.mAdUnitId = adUnitId;
    }

    public View getAdView() {
        return this.mAdView;
    }

    public void setAdManagerListener(AdManagerListener mAdManagerListener) {
        this.mAdManagerListener = mAdManagerListener;
    }

    public boolean isRefreshEnabled() {
        return this.mRefreshInterval != 0L;
    }

    private static class a {
        private AdManager a;
        private InvalidatableRunnable b;
        private AtomicBoolean c = new AtomicBoolean(false);
        private long d;
        private long e;

        a(AdManager adManager) {
            this.e = adManager.getRefreshInterval();
            this.a = adManager;
        }

        private static boolean b(@Nullable AdManager adManager) {
            return adManager != null && adManager.mAdView != null && adManager.isRefreshEnabled() && adManager.mIsAdViewable && (adManager.isLoaded() || adManager.mLoadState == 3);
        }

        private static boolean c(@Nullable AdManager adManager) {
            return adManager != null && adManager.mAdView != null && ScreenHelper.isScreenOn((Context)adManager.mAdView.getContext()) && (adManager.mIsAdViewable || adManager.mLoadState == 3);
        }

        public boolean a() {
            return this.a != null && this.a(this.a.getRefreshInterval());
        }

        public boolean a(long l2) {
            boolean bl = this.b(l2);
            if (bl) {
                this.e = l2;
                DevLogger.i((String)("Ad view refresh was started. Will refresh in " + l2 + "ms."));
            }
            return bl;
        }

        public boolean b() {
            boolean bl = this.b(this.e);
            if (bl) {
                DevLogger.i((String)("Ad view refresh was resumed. Will refresh in " + this.e + "ms."));
            }
            return bl;
        }

        public boolean c() {
            boolean bl = this.e();
            if (bl) {
                long l2 = SystemClock.elapsedRealtime() - this.d;
                this.e = Math.max(0L, this.e - l2);
                DevLogger.i((String)("Ad view refresh was paused " + this.e + "ms before refreshing."));
            }
            return bl;
        }

        public void d() {
            this.e = this.a.getRefreshInterval();
        }

        private boolean b(long l2) {
            if (com.inlocomedia.android.ads.AdManager$a.b(this.a) && this.c.compareAndSet(false, true)) {
                this.b = new InvalidatableRunnable(){

                    public void invalidatableRun() {
                        a.this.c.set(false);
                        try {
                            if (com.inlocomedia.android.ads.AdManager$a.c(a.this.a)) {
                                a.this.a.loadAd(a.this.a.getAdView().getContext(), a.this.a.mAdRequest);
                            } else {
                                DevLogger.i((String)"Ad view refresh was canceled. Ad view is not visible.");
                            }
                        }
                        catch (Throwable throwable) {
                            CriticalErrorManager.notifyError((String)TAG, (Throwable)throwable, (Module)j.b.a, (boolean)true);
                        }
                        a.this.b = null;
                    }
                };
                ThreadPool.executeInMainAt((Runnable)this.b, (long)l2, (TimeUnit)TimeUnit.MILLISECONDS);
                this.d = SystemClock.elapsedRealtime();
                return true;
            }
            return false;
        }

        private boolean e() {
            if (this.c.compareAndSet(true, false)) {
                if (this.b != null) {
                    this.b.invalidate();
                    this.b = null;
                }
                return true;
            }
            return false;
        }
    }
}

