/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.custom;

import android.content.Context;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.core.c;
import com.inlocomedia.android.ads.core.d;
import com.inlocomedia.android.ads.core.i;
import com.inlocomedia.android.ads.custom.CustomAdResponse;
import com.inlocomedia.android.ads.private.ag;
import com.inlocomedia.android.ads.private.ai;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;

public class CustomAdManager {
    private CustomAdManager() {
    }

    public static void requestAd(Context context, AdRequest adRequest, final RequestListener listener) {
        if (CustomAdManager.checkForErrorsBeforeRequesting(listener)) {
            DevLogger.i((String)("Requesting CustomAd" + (adRequest != null ? ". " + adRequest : "")));
            ag ag2 = new ag(AdType.CUSTOM, adRequest, 7);
            d.a(new c<ai, Void>(context, ag2){

                @Override
                public void a(ai ai2) {
                    DevLogger.i((String)"CustomAd received");
                    final CustomAdResponse customAdResponse = new CustomAdResponse(ai2);
                    ThreadPool.executeInMain((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            listener.onAdReceived(customAdResponse);
                        }
                    });
                }

                @Override
                public void a(AdError adError) {
                    DevLogger.w((String)("CustomAd request has failed with error: " + (Object)((Object)adError)));
                    CustomAdManager.notifyAdError(listener, adError);
                }
            });
        }
    }

    public static void requestAd(Context context, RequestListener listener) {
        AdRequest adRequest = null;
        if (i.b.d.isValid()) {
            adRequest = new AdRequest();
            adRequest.setUserProfile(UserProfile.getSavedProfile(context));
        }
        CustomAdManager.requestAd(context, adRequest, listener);
    }

    private static boolean checkForErrorsBeforeRequesting(RequestListener listener) {
        if (!Validator.isValidSDKVersion()) {
            DevLogger.w((String)"Request ad failed. Unsupported Android SDK version.");
            CustomAdManager.notifyAdError(listener, AdError.INVALID_SDK_VERSION);
            return false;
        }
        return true;
    }

    private static void notifyAdError(final RequestListener listener, final AdError adError) {
        ThreadPool.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                listener.onAdError(adError);
            }
        });
    }

    public static interface RequestListener {
        public void onAdReceived(CustomAdResponse var1);

        public void onAdError(AdError var1);
    }
}

