/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.core.g;
import com.inlocomedia.android.ads.core.i;
import com.inlocomedia.android.ads.private.ac;
import com.inlocomedia.android.ads.private.ae;
import com.inlocomedia.android.ads.private.ag;
import com.inlocomedia.android.ads.private.az;
import com.inlocomedia.android.ads.private.e;
import com.inlocomedia.android.ads.private.u;
import com.inlocomedia.android.ads.views.InLocoMediaWebView;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.annotations.VisibleForTesting;
import com.inlocomedia.android.core.communication.exception.NetworkUnavailableException;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.CriticalErrorManager;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.OperationTimer;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import java.util.Map;

public class AdWebView
extends InLocoMediaWebView {
    public static final String b = Logger.makeTag(AdWebView.class);
    @VisibleForTesting
    protected g c;
    private ae a;
    private OperationTimer i;
    private boolean j;
    private u k;

    @SuppressLint(value={"NewApi"})
    public AdWebView(Context context) {
        super(context);
        this.setBackgroundColor(0);
        this.getSettings().setAppCachePath(context.getCacheDir().getAbsolutePath());
        this.getSettings().setCacheMode(-1);
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setAllowFileAccess(false);
        this.getSettings().setUseWideViewPort(true);
        this.getSettings().setSupportZoom(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.j = true;
        this.k = new u((View)this);
        super.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (AdWebView.this.c != null) {
                    return AdWebView.this.c.a(AdWebView.this, url, AdWebView.this.k.a());
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                AdWebView.this.i = new OperationTimer();
            }

            public void onPageFinished(WebView view, String url) {
                if (AdWebView.this.c != null) {
                    AdWebView.this.c.a(AdWebView.this);
                }
                AdWebView.this.a();
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                AdWebView.this.a(AdWebView.a(errorCode), description, failingUrl);
            }
        });
    }

    public static AdError a(int n2) {
        switch (n2) {
            case -8: {
                return AdError.TIMEOUT;
            }
            case -4: {
                return AdError.UNAUTHORIZED;
            }
            case -11: 
            case -6: {
                return AdError.NETWORK_NOT_AVAILABLE;
            }
        }
        return AdError.INTERNAL_ERROR;
    }

    private static int a(ae ae2) {
        if (ae2 != null && ae2.a() != null) {
            AdType adType = ae2.a();
            if (adType.isFullScreen()) {
                return 15;
            }
            if (adType.isNotification()) {
                return 25;
            }
        }
        return 10;
    }

    @UiThread
    public boolean a(ag ag2) {
        this.a = ag2;
        boolean bl = this.b(ag2);
        if (bl) {
            this.a(ag2.m(), ag2.l());
        }
        return bl;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void a(@NonNull String string2, boolean bl) {
        this.a(null, string2, bl);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void a(final @Nullable String string2, final @NonNull String string3, boolean bl) {
        this.getSettings().setJavaScriptEnabled(bl);
        this.setLoadTimeout(AdWebView.a(this.getAd()));
        ThreadPool.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String string22 = az.b(string3);
                    AdWebView.this.i = new OperationTimer();
                    AdWebView.super.loadDataWithBaseURL(string2, string22, "text/html", "UTF-8", null);
                }
                catch (Throwable throwable) {
                    AdWebView.this.a(throwable, string3);
                }
            }
        });
    }

    private boolean b(ae ae2) {
        if (!Validator.isMainThread()) {
            this.a(AdError.INTERNAL_ERROR, "LoadAd must be called on the MainThread", null);
            return false;
        }
        if (ae2 == null) {
            this.a(AdError.INTERNAL_ERROR, "Missing Ad on AdWebView", null);
            return false;
        }
        if (ae2.a() == null) {
            this.a(AdError.INTERNAL_ERROR, "Missing AdType on AdWebView", null);
            return false;
        }
        return true;
    }

    private void a(Throwable throwable, String string2) {
        if (!InLocoMediaException.isUnhandledError((Throwable)throwable)) {
            AdError adError = throwable instanceof NetworkUnavailableException ? AdError.NETWORK_NOT_AVAILABLE : AdError.INTERNAL_ERROR;
            this.a(adError, InLocoMediaException.getFormattedMessage((Throwable)throwable), string2);
        } else {
            CriticalErrorManager.notifyError((String)b, (Throwable)throwable, (Module)i.b.a, (boolean)true);
            this.a(AdError.INTERNAL_ERROR, InLocoMediaException.getFormattedMessage((Throwable)throwable), string2);
        }
    }

    private void a(final AdError adError, final String string2, final @Nullable String string3) {
        this.a(adError, string2);
        if (this.c != null) {
            ThreadPool.postOnMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    AdWebView.this.c.a(AdWebView.this, adError, string2, string3);
                }
            });
        }
    }

    public void setAdWebViewClient(g l2) {
        this.c = l2;
    }

    public ae getAd() {
        return this.a;
    }

    private void a() {
        if (this.a != null && this.j) {
            ac.a(this.getContext()).b(this.a.k(), this.getLoadingDuration());
        }
    }

    private void a(AdError adError, String string2) {
        if (this.a != null && this.j) {
            ac.a(this.getContext()).b(this.a.k(), adError, string2, this.getLoadingDuration());
        }
    }

    private long getLoadingDuration() {
        return this.i != null ? this.i.getDuration() : 0L;
    }

    public void setRegisterAnalyticsEnabled(boolean enabled) {
        this.j = enabled;
    }

    @Override
    public void destroy() {
        com.inlocomedia.android.ads.private.e.a((View)this);
        this.removeAllViews();
        super.destroy();
    }

    @Override
    public void setWebViewClient(WebViewClient client) {
        this.a("setWebViewClient", "setAdWebViewClient");
    }

    @Override
    public final void loadData(String data, String mimeType, String encoding) {
        this.a("loadData", "loadHtmlContent");
    }

    @Override
    public final void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        this.a("loadDataWithBaseURL", "loadHtmlContent");
    }

    @Override
    public final void loadUrl(String url) {
        this.b(url);
    }

    @Override
    public final void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        this.b(url);
    }

    private void b(String string2) {
        try {
            if (Build.VERSION.SDK_INT < 19 && string2.startsWith("javascript:")) {
                super.a(string2);
            } else {
                this.a("loadUrl", "loadHtmlContent");
            }
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError((String)b, (Throwable)throwable, (Module)i.b.a);
        }
    }

    private void a(String string2, String string3) {
        String string4 = string2 + "() method is not available in AdWebView. Use " + string3 + "() instead.";
        IllegalAccessError illegalAccessError = new IllegalAccessError(string4);
        throw illegalAccessError;
    }
}

