/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.nativeads;

import android.content.Context;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.core.c;
import com.inlocomedia.android.ads.core.d;
import com.inlocomedia.android.ads.core.i;
import com.inlocomedia.android.ads.nativeads.NativeAdResponse;
import com.inlocomedia.android.ads.private.ad;
import com.inlocomedia.android.ads.private.ah;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;

public final class NativeAdManager {
    private NativeAdManager() {
    }

    public static void requestAd(Context context, AdRequest adRequest, final RequestListener listener) {
        if (NativeAdManager.checkForErrorsBeforeRequesting(listener)) {
            DevLogger.i((String)("Requesting NativeAd" + (adRequest != null ? ". " + adRequest : "")));
            ad ad2 = new ad(AdType.NATIVE_LARGE, adRequest, 7);
            d.a(new c<ah, Void>(context, ad2){

                @Override
                public void a(ah ah2) {
                    DevLogger.i((String)"NativeAd received");
                    final NativeAdResponse nativeAdResponse = new NativeAdResponse(ah2);
                    ThreadPool.executeInMain((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            listener.onAdReceived(nativeAdResponse);
                        }
                    });
                }

                @Override
                public void a(AdError adError) {
                    DevLogger.w((String)("NativeAd request has failed with error: " + (Object)((Object)adError)));
                    NativeAdManager.notifyAdError(listener, adError);
                }
            });
        }
    }

    public static void requestAd(Context context, RequestListener listener) {
        AdRequest adRequest = null;
        if (i.b.a.isValid()) {
            adRequest = new AdRequest();
            adRequest.setUserProfile(UserProfile.newToOld(UserProfile.getSavedProfile(context)));
        }
        NativeAdManager.requestAd(context, adRequest, listener);
    }

    private static boolean checkForErrorsBeforeRequesting(RequestListener listener) {
        if (!Validator.isValidSDKVersion()) {
            DevLogger.w((String)"Request ad failed. Unsupported Android SDK version.");
            NativeAdManager.notifyAdError(listener, AdError.INVALID_SDK_VERSION);
            return false;
        }
        return true;
    }

    private static void notifyAdError(final RequestListener listener, final AdError adError) {
        ThreadPool.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                listener.onAdError(adError);
            }
        });
    }

    public static interface RequestListener {
        public void onAdReceived(NativeAdResponse var1);

        public void onAdError(AdError var1);
    }
}

