/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.mediation.google;

import android.content.Context;
import android.util.Log;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.InLocoMedia;
import com.inlocomedia.android.ads.InLocoMediaOptions;
import com.inlocomedia.android.ads.profile.UserProfile;
import java.util.Date;
import org.json.JSONObject;

public final class Utils {
    public static final String KEY_AD_UNIT_ID = "ad_unit_id";
    private static final String KEY_APP_ID = "app_id";
    public static final String TAG = "InLocoMedia";

    public static int adErrorToAdMobError(AdError error) {
        switch (error) {
            case NO_FILL: {
                return 3;
            }
            case INVALID_REQUEST: {
                return 1;
            }
            case NETWORK_NOT_AVAILABLE: {
                return 2;
            }
            case UNAUTHORIZED: {
                return 1;
            }
            case INTERNAL_ERROR: {
                return 0;
            }
            case TIMEOUT: {
                return 2;
            }
            case GOOGLE_PLAY_SERVICES_NOT_FOUND: {
                return 1;
            }
            case INVALID_SDK_VERSION: {
                return 3;
            }
        }
        return 0;
    }

    public static AdRequest createAdRequest(MediationAdRequest mediationAdRequest, String adUnitId, String requestAgent) {
        AdRequest adRequest = new AdRequest();
        adRequest.setUserProfile(new UserProfile(Utils.getGender(mediationAdRequest), Utils.getBirthdate(mediationAdRequest)));
        adRequest.setKeywords(mediationAdRequest.getKeywords());
        adRequest.setRequestAgent(requestAgent);
        adRequest.setAdUnitId(adUnitId);
        int taggedForChildDirectedTreatment = mediationAdRequest.taggedForChildDirectedTreatment();
        if (taggedForChildDirectedTreatment == 1) {
            adRequest.setTaggedForChildren(true);
        } else if (taggedForChildDirectedTreatment == 0) {
            adRequest.setTaggedForChildren(false);
        }
        return adRequest;
    }

    private static Date getBirthdate(MediationAdRequest mediationAdRequest) {
        Date birthdate = mediationAdRequest.getBirthday();
        if (birthdate != null && birthdate.getTime() == -1L) {
            birthdate = null;
        }
        return birthdate;
    }

    private static UserProfile.Gender getGender(MediationAdRequest mediationAdRequest) {
        int gender = mediationAdRequest.getGender();
        switch (gender) {
            case 1: {
                return UserProfile.Gender.MALE;
            }
            case 2: {
                return UserProfile.Gender.FEMALE;
            }
        }
        return UserProfile.Gender.UNDEFINED;
    }

    protected static AdType convertAdSizeToAdType(AdSize adSize) {
        if (adSize.equals((Object)AdSize.SMART_BANNER)) {
            return AdType.SMART_BANNER;
        }
        return AdType.getBySize((int)adSize.getWidth(), (int)adSize.getHeight());
    }

    protected static String getAdUnitId(String serverParameter) {
        if (serverParameter == null || serverParameter.isEmpty()) {
            return null;
        }
        try {
            JSONObject serverJson = new JSONObject(serverParameter);
            if (serverJson.has(KEY_AD_UNIT_ID)) {
                return serverJson.getString(KEY_AD_UNIT_ID);
            }
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)("Extraction of server parameters has failed with exception " + t.getMessage()));
        }
        return null;
    }

    protected static void setupInLocoMedia(Context context, String serverParameter) {
        if (serverParameter == null || serverParameter.isEmpty()) {
            return;
        }
        try {
            JSONObject serverJson = new JSONObject(serverParameter);
            String appId = null;
            if (serverJson.has(KEY_APP_ID)) {
                appId = serverJson.getString(KEY_APP_ID);
            }
            if (appId != null) {
                Utils.setupInLocoMediaOptions(context, appId);
            }
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)("Extraction of server parameters has failed with exception " + t.getMessage()));
        }
    }

    private static void setupInLocoMediaOptions(Context context, String appId) {
        InLocoMediaOptions options = InLocoMediaOptions.getInstance((Context)context);
        options.setAdsKey(appId);
        options.setLogEnabled(true);
        InLocoMedia.init((Context)context, (InLocoMediaOptions)options);
    }
}

