/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.mediation.google;

import android.content.Context;
import android.os.Bundle;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.rewarded.Reward;
import com.inlocomedia.android.ads.rewarded.RewardedAd;
import com.inlocomedia.android.ads.rewarded.RewardedAdListener;
import com.inlocomedia.android.mediation.google.Utils;

public class InLocoMediaRewardedVideoAdapter
implements MediationRewardedVideoAdAdapter {
    private String mediationAgent;
    private RewardedAd rewardedAd;
    private MediationRewardedVideoAdListener mediationRewardedVideoAdListener;
    private boolean isInitialized;
    private Context context;

    public InLocoMediaRewardedVideoAdapter(String mediationAgent) {
        this.mediationAgent = mediationAgent;
    }

    public void initialize(Context context, MediationAdRequest mediationAdRequest, String unused, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle serverParameters, Bundle mediationExtras) {
        this.context = context;
        this.mediationRewardedVideoAdListener = mediationRewardedVideoAdListener;
        Utils.setupInLocoMedia(context, serverParameters.getString("parameter"));
        this.isInitialized = true;
        this.mediationRewardedVideoAdListener.onInitializationSucceeded((MediationRewardedVideoAdAdapter)this);
    }

    public void loadAd(MediationAdRequest mediationAdRequest, Bundle serverParameters, Bundle mediationExtras) {
        this.rewardedAd = new RewardedAd(this.context);
        String adUnitId = Utils.getAdUnitId(serverParameters.getString("parameter"));
        RewardedAdListener rewardedAdListener = new RewardedAdListener(){

            public void onAdReady(RewardedAd ad) {
                InLocoMediaRewardedVideoAdapter.this.mediationRewardedVideoAdListener.onAdLoaded((MediationRewardedVideoAdAdapter)InLocoMediaRewardedVideoAdapter.this);
            }

            public void onAdOpened(RewardedAd ad) {
                InLocoMediaRewardedVideoAdapter.this.mediationRewardedVideoAdListener.onAdOpened((MediationRewardedVideoAdAdapter)InLocoMediaRewardedVideoAdapter.this);
                InLocoMediaRewardedVideoAdapter.this.mediationRewardedVideoAdListener.onVideoStarted((MediationRewardedVideoAdAdapter)InLocoMediaRewardedVideoAdapter.this);
            }

            public void onRewarded(RewardedAd ad, final Reward reward) {
                InLocoMediaRewardedVideoAdapter.this.mediationRewardedVideoAdListener.onRewarded((MediationRewardedVideoAdAdapter)InLocoMediaRewardedVideoAdapter.this, new RewardItem(){

                    public String getType() {
                        return reward.getItem();
                    }

                    public int getAmount() {
                        return reward.getAmount();
                    }
                });
            }

            public void onAdLeftApplication(RewardedAd ad) {
                InLocoMediaRewardedVideoAdapter.this.mediationRewardedVideoAdListener.onAdClicked((MediationRewardedVideoAdAdapter)InLocoMediaRewardedVideoAdapter.this);
                InLocoMediaRewardedVideoAdapter.this.mediationRewardedVideoAdListener.onAdLeftApplication((MediationRewardedVideoAdAdapter)InLocoMediaRewardedVideoAdapter.this);
            }

            public void onAdClosed(RewardedAd ad) {
                InLocoMediaRewardedVideoAdapter.this.mediationRewardedVideoAdListener.onAdClosed((MediationRewardedVideoAdAdapter)InLocoMediaRewardedVideoAdapter.this);
            }

            public void onAdError(RewardedAd ad, AdError error) {
                InLocoMediaRewardedVideoAdapter.this.mediationRewardedVideoAdListener.onAdFailedToLoad((MediationRewardedVideoAdAdapter)InLocoMediaRewardedVideoAdapter.this, Utils.adErrorToAdMobError(error));
            }
        };
        this.rewardedAd.setRewardedAdListener(rewardedAdListener);
        this.rewardedAd.loadAd(adUnitId, Utils.createAdRequest(mediationAdRequest, adUnitId, this.mediationAgent));
    }

    public void showVideo() {
        if (this.rewardedAd != null && this.rewardedAd.isLoaded()) {
            this.rewardedAd.show();
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void onDestroy() {
    }

    public void onPause() {
    }

    public void onResume() {
    }
}

