/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.utils;

import com.ing.data.cassandra.jdbc.metadata.VersionedMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.sql.DriverPropertyInfo;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.semver4j.RangesExpression;
import org.semver4j.Semver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DriverUtil {
    public static final String JDBC_DRIVER_PROPERTIES_FILE = "jdbc-driver.properties";
    public static final String JSSE_TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    public static final String JSSE_TRUSTSTORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    public static final String JSSE_KEYSTORE_PROPERTY = "javax.net.ssl.keyStore";
    public static final String JSSE_KEYSTORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    public static final String NULL_KEYWORD = "NULL";
    public static final String CASSANDRA_5 = "5.0";
    public static final String CASSANDRA_4 = "4.0";
    static final Logger LOG = LoggerFactory.getLogger(DriverUtil.class);

    private DriverUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDriverProperty(String name) {
        try (InputStream propertiesFile = DriverUtil.class.getClassLoader().getResourceAsStream(JDBC_DRIVER_PROPERTIES_FILE);){
            Properties driverProperties = new Properties();
            driverProperties.load(propertiesFile);
            String string = driverProperties.getProperty(name, "");
            return string;
        }
        catch (IOException ex) {
            LOG.error("Unable to get JDBC driver property: {}.", (Object)name, (Object)ex);
            return "";
        }
    }

    public static Semver safeParseVersion(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            return Semver.ZERO;
        }
        Semver parsedVersion = Semver.coerce((String)version);
        if (parsedVersion == null) {
            return Semver.ZERO;
        }
        return parsedVersion;
    }

    public static boolean existsInDatabaseVersion(String dbVersion, VersionedMetadata versionedMetadata) {
        Semver parseDatabaseVersion = Semver.coerce((String)dbVersion);
        if (parseDatabaseVersion == null) {
            return false;
        }
        Semver minVersion = Semver.ZERO;
        if (versionedMetadata.isValidFrom() != null) {
            minVersion = versionedMetadata.isValidFrom();
        }
        RangesExpression validRange = RangesExpression.greaterOrEqual((Semver)minVersion);
        if (versionedMetadata.isInvalidFrom() != null) {
            validRange.and(RangesExpression.less((Semver)versionedMetadata.isInvalidFrom()));
        }
        return parseDatabaseVersion.satisfies(validRange);
    }

    public static String buildMetadataList(List<VersionedMetadata> metadataList, String dbVersion) {
        return metadataList.stream().filter(metadata -> DriverUtil.existsInDatabaseVersion(dbVersion, metadata)).map(VersionedMetadata::getName).sorted().collect(Collectors.joining(","));
    }

    public static DriverPropertyInfo buildPropertyInfo(String propertyName, Object value) {
        DriverPropertyInfo propertyInfo = new DriverPropertyInfo(propertyName, Objects.toString(value, ""));
        String driverPropertyDefinition = "driver.properties." + propertyName;
        String propertyChoices = DriverUtil.getDriverProperty(driverPropertyDefinition + ".choices");
        if (StringUtils.isNotBlank((CharSequence)propertyChoices)) {
            propertyInfo.choices = propertyChoices.split(",");
        }
        propertyInfo.required = Boolean.getBoolean(DriverUtil.getDriverProperty(driverPropertyDefinition + ".required"));
        propertyInfo.description = DriverUtil.getDriverProperty(driverPropertyDefinition);
        return propertyInfo;
    }
}

