/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.ColumnDefinitions;
import com.ing.data.cassandra.jdbc.utils.ByteBufferUtil;
import com.ing.data.cassandra.jdbc.utils.SpecialCommandsUtil;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nullable;

public final class SpecialCommands {

    public static class ConsistencyLevelExecutor
    implements SpecialCommandExecutor {
        private String levelParameter = null;

        public ConsistencyLevelExecutor(@Nullable String levelParameter) {
            if (levelParameter != null) {
                this.levelParameter = levelParameter.toUpperCase(Locale.ENGLISH);
            }
        }

        @Override
        public ResultSet execute(CassandraStatement statement, String cql) throws SQLException {
            CassandraConnection connection = (CassandraConnection)statement.getConnection();
            if (this.levelParameter != null) {
                connection.setConsistencyLevel((ConsistencyLevel)DefaultConsistencyLevel.valueOf((String)this.levelParameter));
                return SpecialCommandsUtil.buildEmptyResultSet();
            }
            String currentLevel = connection.getConsistencyLevel().name();
            ByteBuffer currentLevelAsBytes = ByteBufferUtil.bytes(currentLevel);
            return SpecialCommandsUtil.buildSpecialCommandResultSet(new ColumnDefinitions.Definition[]{ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("consistency_level", DataTypes.TEXT)}, Collections.singletonList(Collections.singletonList(currentLevelAsBytes)));
        }
    }

    public static interface SpecialCommandExecutor {
        public ResultSet execute(CassandraStatement var1, String var2) throws SQLException;
    }
}

