/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.models;

import android.text.TextUtils;
import com.sina.weibo.sdk.net.ListRequestListener;
import com.sina.weibo.sdk.openapi.models.Status;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StatusList {
    public List<Status> statusList;
    public boolean hasvisible;
    public String previous_cursor;
    public String next_cursor;
    public int total_number;
    public Object[] advertises;

    public static StatusList parse(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        StatusList statuses = new StatusList();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            statuses.hasvisible = jsonObject.optBoolean("hasvisible", false);
            statuses.previous_cursor = jsonObject.optString("previous_cursor", "0");
            statuses.next_cursor = jsonObject.optString("next_cursor", "0");
            statuses.total_number = jsonObject.optInt("total_number", 0);
            JSONArray jsonArray = jsonObject.optJSONArray("statuses");
            if (jsonArray != null && jsonArray.length() > 0) {
                int length = jsonArray.length();
                statuses.statusList = new ArrayList<Status>(length);
                for (int ix = 0; ix < length; ++ix) {
                    statuses.statusList.add(Status.parse(jsonArray.getJSONObject(ix)));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return statuses;
    }

    public static abstract class RequestListener
    implements com.sina.weibo.sdk.net.RequestListener,
    ListRequestListener<Status> {
        public void onComplete(String json) {
            StatusList statusList = StatusList.parse(json);
            this.onComplete(statusList.statusList);
        }
    }
}

