/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import android.content.Context;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class PlaceAPI
extends AbsOpenAPI {
    public static final int SORT_BY_TIME = 0;
    public static final int SORT_BY_DISTENCE = 1;
    public static final int NEARBY_POIS_SORT_BY_WEIGHT = 0;
    public static final int NEARBY_POIS_SORT_BY_DISTENCE = 1;
    public static final int NEARBY_POIS_SORT_BY_CHECKIN_NUMBER = 2;
    public static final int POIS_SORT_BY_TIME = 0;
    public static final int POIS_SORT_BY_HOT = 1;
    public static final int RELATIONSHIP_FILTER_ALL = 0;
    public static final int RELATIONSHIP_FILTER_STRANGER = 1;
    public static final int RELATIONSHIP_FILTER_FOLLOW = 2;
    public static final int GENDER_ALL = 0;
    public static final int GENDER_MAN = 1;
    public static final int GENDER_WOMAM = 2;
    public static final int USER_LEVEL_ALL = 0;
    public static final int USER_LEVEL_NORMAL = 1;
    public static final int USER_LEVEL_VIP = 2;
    public static final int USER_LEVEL_STAR = 7;
    public static final int NEARBY_USER_SORT_BY_TIME = 0;
    public static final int NEARBY_USER_SORT_BY_DISTANCE = 1;
    public static final int NEARBY_USER_SORT_BY_SOCIAL_SHIP = 2;
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/place";

    public PlaceAPI(Context context, String appKey, Oauth2AccessToken accessToken) {
        super(context, appKey, accessToken);
    }

    public void pulicTimeline(long count, boolean base_app, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("count", count);
        params.put("base_app", base_app ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/place/public_timelin.json", params, "GET", listener);
    }

    public void friendsTimeline(long since_id, long max_id, int count, int page, boolean only_attentions, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("type", only_attentions ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/place/friends_timeline.json", params, "GET", listener);
    }

    public void userTimeline(long uid, long since_id, long max_id, int count, int page, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("uid", uid);
        params.put("base_app", base_app ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/place/user_timeline.json", params, "GET", listener);
    }

    public void poiTimeline(String poiid, long since_id, long max_id, int count, int page, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("poiid", poiid);
        params.put("base_app", base_app ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/place/poi_timeline.json", params, "GET", listener);
    }

    public void nearbyTimeline(String lat, String lon, int range, long starttime, long endtime, int sortType, int count, int page, boolean base_app, boolean offset, RequestListener listener) {
        WeiboParameters params = this.buildNearbyParams(lat, lon, range, count, page, sortType, offset);
        params.put("starttime", starttime);
        params.put("endtime", endtime);
        params.put("base_app", base_app ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/place/nearby_timeline.json", params, "GET", listener);
    }

    public void statusesShow(long id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("id", id);
        this.requestAsync("https://api.weibo.com/2/place/statuses/show.json", params, "GET", listener);
    }

    public void usersShow(long uid, boolean base_app, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("uid", uid);
        params.put("base_app", base_app ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/place/users/show.json", params, "GET", listener);
    }

    public void usersCheckins(long uid, int count, int page, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildUserParams(uid, count, page, base_app);
        this.requestAsync("https://api.weibo.com/2/place/users/checkins.json", params, "GET", listener);
    }

    public void usersPhotos(long uid, int count, int page, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildUserParams(uid, count, page, base_app);
        this.requestAsync("https://api.weibo.com/2/place/users/photos.json", params, "GET", listener);
    }

    public void usersTips(long uid, int count, int page, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildUserParams(uid, count, page, base_app);
        this.requestAsync("https://api.weibo.com/2/place/users/tips.json", params, "GET", listener);
    }

    public void usersTodo(long uid, int count, int page, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildUserParams(uid, count, page, base_app);
        this.requestAsync("https://api.weibo.com/2/place/users/todos.json", params, "GET", listener);
    }

    public void poisShow(String poiid, boolean base_app, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("poiid", poiid);
        params.put("base_app", base_app ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/place/pois/show.json", params, "GET", listener);
    }

    public void poisUsers(String poiid, int count, int page, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildPoisParams(poiid, count, page, base_app);
        this.requestAsync("https://api.weibo.com/2/place/pois/users.json", params, "GET", listener);
    }

    public void poisPhotos(String poiid, int count, int page, int sortType, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildPoisParams(poiid, count, page, base_app);
        params.put("sort", sortType);
        this.requestAsync("https://api.weibo.com/2/place/pois/photos.json", params, "GET", listener);
    }

    public void poisTips(String poiid, int count, int page, int sortType, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildPoisParams(poiid, count, page, base_app);
        params.put("sort", sortType);
        this.requestAsync("https://api.weibo.com/2/place/pois/tips.json", params, "GET", listener);
    }

    public void poisSearch(String keyword, String city, String category, int count, int page, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("keyword", keyword);
        params.put("city", city);
        params.put("category", category);
        params.put("count", count);
        params.put("page", page);
        this.requestAsync("https://api.weibo.com/2/place/pois/search.json", params, "GET", listener);
    }

    public void poisCategory(int pid, boolean returnALL, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("pid", pid);
        params.put("flag", returnALL ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/place/pois/category.json", params, "GET", listener);
    }

    public void nearbyPois(String lat, String lon, int range, String q, String category, int count, int page, int sortType, boolean offset, RequestListener listener) {
        WeiboParameters params = this.buildNearbyParams(lat, lon, range, count, page, sortType, offset);
        params.put("q", q);
        params.put("category", category);
        this.requestAsync("https://api.weibo.com/2/place/nearby/pois.json", params, "GET", listener);
    }

    public void nearbyUsers(String lat, String lon, int range, long starttime, long endtime, int sortType, int count, int page, boolean offset, RequestListener listener) {
        WeiboParameters params = this.buildNearbyParams(lat, lon, range, count, page, sortType, offset);
        params.put("starttime", starttime);
        params.put("endtime", endtime);
        this.requestAsync("https://api.weibo.com/2/place/nearby/users.json", params, "GET", listener);
    }

    public void nearbyPhotos(String lat, String lon, int range, long starttime, long endtime, int sortType, int count, int page, boolean offset, RequestListener listener) {
        WeiboParameters params = this.buildNearbyParams(lat, lon, range, count, page, sortType, offset);
        params.put("starttime", starttime);
        params.put("endtime", endtime);
        this.requestAsync("https://api.weibo.com/2/place/nearby/photos.json", params, "GET", listener);
    }

    public void nearbyUserList(String lat, String lon, int count, int page, int range, int sortType, int filterType, int genderType, int levelType, int start_birth, int end_birth, boolean offset, RequestListener listener) {
        WeiboParameters params = this.buildNearbyParams(lat, lon, range, count, page, sortType, offset);
        params.put("filter", filterType);
        params.put("gender", genderType);
        params.put("level", levelType);
        params.put("startbirth", start_birth);
        params.put("endbirth", end_birth);
        this.requestAsync("https://api.weibo.com/2/place/nearby_users/list.json", params, "GET", listener);
    }

    public void poisCreate(String title, String address, String category, String lat, String lon, String city, String province, String country, String phone, String postCode, String extra, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("title", title);
        params.put("address", address);
        params.put("category", category);
        params.put("lat", lat);
        params.put("long", lon);
        params.put("city", city);
        params.put("province", province);
        params.put("country", country);
        params.put("phone", phone);
        params.put("postcode", postCode);
        params.put("extra", extra);
        this.requestAsync("https://api.weibo.com/2/place/pois/create.json", params, "POST", listener);
    }

    public void poisAddCheckin(String poiid, String status, String pic, boolean isPublic, RequestListener listener) {
        WeiboParameters params = this.buildPoiis(poiid, status, isPublic);
        params.put("pic", pic);
        this.requestAsync("https://api.weibo.com/2/place/pois/add_checkin.json", params, "POST", listener);
    }

    public void poisAddPhoto(String poiid, String status, String pic, boolean isPublic, RequestListener listener) {
        WeiboParameters params = this.buildPoiis(poiid, status, isPublic);
        params.put("pic", pic);
        this.requestAsync("https://api.weibo.com/2/place/pois/add_photo.json", params, "POST", listener);
    }

    public void poisAddTip(String poiid, String status, boolean isPublic, RequestListener listener) {
        WeiboParameters params = this.buildPoiis(poiid, status, isPublic);
        this.requestAsync("https://api.weibo.com/2/place/pois/add_tip.json", params, "POST", listener);
    }

    public void poisAddTodo(String poiid, String status, boolean isPublic, RequestListener listener) {
        WeiboParameters params = this.buildPoiis(poiid, status, isPublic);
        this.requestAsync("https://api.weibo.com/2/place/pois/add_todo.json", params, "POST", listener);
    }

    public void nearbyUsersCreate(String lat, String lon, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("lat", lat);
        params.put("long", lon);
        this.requestAsync("https://api.weibo.com/2/place/nearby_users/create.json", params, "POST", listener);
    }

    public void nearbyUsersDestroy(RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        this.requestAsync("https://api.weibo.com/2/place/nearby_users/destory.json", params, "POST", listener);
    }

    private WeiboParameters buildTimeLineParamsBase(long since_id, long max_id, int count, int page) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("since_id", since_id);
        params.put("max_id", max_id);
        params.put("count", count);
        params.put("page", page);
        return params;
    }

    private WeiboParameters buildUserParams(long uid, int count, int page, boolean base_app) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("uid", uid);
        params.put("count", count);
        params.put("page", page);
        params.put("base_app", base_app ? 1 : 0);
        return params;
    }

    private WeiboParameters buildNearbyParams(String lat, String lon, int range, int count, int page, int sortType, boolean offset) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("lat", lat);
        params.put("long", lon);
        params.put("range", range);
        params.put("count", count);
        params.put("page", page);
        params.put("sort", sortType);
        params.put("offset", offset ? 1 : 0);
        return params;
    }

    private WeiboParameters buildPoiis(String poiid, String status, boolean isPublic) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("poiid", poiid);
        params.put("status", status);
        params.put("public", isPublic ? 1 : 0);
        return params;
    }

    private WeiboParameters buildPoisParams(String poiid, int count, int page, boolean base_app) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("poiid", poiid);
        params.put("base_app", base_app ? 1 : 0);
        params.put("count", count);
        params.put("page", page);
        return params;
    }
}

