/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import android.content.Context;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class FriendshipsAPI
extends AbsOpenAPI {
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/friendships";

    public FriendshipsAPI(Context context, String appKey, Oauth2AccessToken accessToken) {
        super(context, appKey, accessToken);
    }

    public void friends(long uid, int count, int cursor, boolean trim_status, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params = this.buildFriendsParam(count, cursor, trim_status);
        params.put("uid", uid);
        this.requestAsync("https://api.weibo.com/2/friendships/friends.json", params, "GET", listener);
    }

    public void friends(String screen_name, int count, int cursor, boolean trim_status, RequestListener listener) {
        WeiboParameters params = this.buildFriendsParam(count, cursor, trim_status);
        params.put("screen_name", screen_name);
        this.requestAsync("https://api.weibo.com/2/friendships/friends.json", params, "GET", listener);
    }

    public void inCommon(long uid, long suid, int count, int page, boolean trim_status, RequestListener listener) {
        WeiboParameters params = this.buildFriendIDParam(uid, count);
        params.put("suid", suid);
        params.put("page", page);
        params.put("trim_status", trim_status ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/friendships/friends/in_common.json", params, "GET", listener);
    }

    public void bilateral(long uid, int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildFriendIDParam(uid, count);
        params.put("page", page);
        this.requestAsync("https://api.weibo.com/2/friendships/friends/bilateral.json", params, "GET", listener);
    }

    public void bilateralIds(long uid, int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildFriendIDParam(uid, count);
        params.put("page", page);
        this.requestAsync("https://api.weibo.com/2/friendships/friends/bilateral/ids.json", params, "GET", listener);
    }

    public void friendsIds(long uid, int count, int cursor, RequestListener listener) {
        WeiboParameters params = this.buildFriendIDParam(uid, count);
        params.put("cursor", cursor);
        this.requestAsync("https://api.weibo.com/2/friendships/friends/ids.json", params, "GET", listener);
    }

    public void friendsIds(String screen_name, int count, int cursor, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("screen_name", screen_name);
        params.put("count", count);
        params.put("cursor", cursor);
        this.requestAsync("https://api.weibo.com/2/friendships/friends/ids.json", params, "GET", listener);
    }

    public void followers(long uid, int count, int cursor, boolean trim_status, RequestListener listener) {
        WeiboParameters params = this.buildFriendIDParam(uid, count);
        params.put("cursor", cursor);
        params.put("trim_status", trim_status ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/friendships/followers.json", params, "GET", listener);
    }

    public void followers(String screen_name, int count, int cursor, boolean trim_status, RequestListener listener) {
        WeiboParameters params = this.buildFriendsParam(count, cursor, trim_status);
        params.put("screen_name", screen_name);
        this.requestAsync("https://api.weibo.com/2/friendships/followers.json", params, "GET", listener);
    }

    public void followersIds(long uid, int count, int cursor, RequestListener listener) {
        WeiboParameters params = this.buildFriendIDParam(uid, count);
        params.put("cursor", cursor);
        this.requestAsync("https://api.weibo.com/2/friendships/followers/ids.json", params, "GET", listener);
    }

    public void followersIds(String screen_name, int count, int cursor, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("screen_name", screen_name);
        params.put("count", count);
        params.put("cursor", cursor);
        this.requestAsync("https://api.weibo.com/2/friendships/followers/ids.json", params, "GET", listener);
    }

    public void followersActive(long uid, int count, RequestListener listener) {
        WeiboParameters params = this.buildFriendIDParam(uid, count);
        this.requestAsync("https://api.weibo.com/2/friendships/followers/active.json", params, "GET", listener);
    }

    public void chainFollowers(long uid, int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildFriendIDParam(uid, count);
        params.put("page", page);
        this.requestAsync("https://api.weibo.com/2/friendships/friends_chain/followers.json", params, "GET", listener);
    }

    public void show(long source_id, long target_id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("source_id", source_id);
        params.put("target_id", target_id);
        this.requestAsync("https://api.weibo.com/2/friendships/show.json", params, "GET", listener);
    }

    public void show(long source_id, String target_screen_name, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("source_id", source_id);
        params.put("target_screen_name", target_screen_name);
        this.requestAsync("https://api.weibo.com/2/friendships/show.json", params, "GET", listener);
    }

    public void show(String source_screen_name, long target_id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("source_screen_name", source_screen_name);
        params.put("target_id", target_id);
        this.requestAsync("https://api.weibo.com/2/friendships/show.json", params, "GET", listener);
    }

    public void show(String source_screen_name, String target_screen_name, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("target_screen_name", target_screen_name);
        params.put("source_screen_name", source_screen_name);
        this.requestAsync("https://api.weibo.com/2/friendships/show.json", params, "GET", listener);
    }

    public void create(long uid, String screen_name, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("uid", uid);
        params.put("screen_name", screen_name);
        this.requestAsync("https://api.weibo.com/2/friendships/create.json", params, "POST", listener);
    }

    @Deprecated
    public void create(String screen_name, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("screen_name", screen_name);
        this.requestAsync("https://api.weibo.com/2/friendships/create.json", params, "POST", listener);
    }

    public void destroy(long uid, String screen_name, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("uid", uid);
        params.put("screen_name", screen_name);
        this.requestAsync("https://api.weibo.com/2/friendships/destroy.json", params, "POST", listener);
    }

    @Deprecated
    public void destroy(String screen_name, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("screen_name", screen_name);
        this.requestAsync("https://api.weibo.com/2/friendships/destroy.json", params, "POST", listener);
    }

    private WeiboParameters buildFriendsParam(int count, int cursor, boolean trim_status) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("count", count);
        params.put("cursor", cursor);
        params.put("trim_status", trim_status ? 1 : 0);
        return params;
    }

    private WeiboParameters buildFriendIDParam(long uid, int count) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("uid", uid);
        params.put("count", count);
        return params;
    }
}

