/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import android.content.Context;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class FavoritesAPI
extends AbsOpenAPI {
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/favorites";

    public FavoritesAPI(Context context, String appKey, Oauth2AccessToken accessToken) {
        super(context, appKey, accessToken);
    }

    public void favorites(int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildCountPage(count, page);
        this.requestAsync("https://api.weibo.com/2/favorites.json", params, "GET", listener);
    }

    public void ids(int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildCountPage(count, page);
        this.requestAsync("https://api.weibo.com/2/favorites/ids.json", params, "GET", listener);
    }

    public void show(long id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("id", id);
        this.requestAsync("https://api.weibo.com/2/favorites/show.json", params, "GET", listener);
    }

    public void byTags(long tid, int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildCountPage(count, page);
        params.put("tid", tid);
        this.requestAsync("https://api.weibo.com/2/favorites/by_tags.json", params, "GET", listener);
    }

    public void tags(int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildCountPage(count, page);
        this.requestAsync("https://api.weibo.com/2/favorites/tags.json", params, "GET", listener);
    }

    public void byTagsIds(long tid, int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildCountPage(count, page);
        params.put("tid", tid);
        this.requestAsync("https://api.weibo.com/2/favorites/by_tags/ids.json", params, "GET", listener);
    }

    public void create(long id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("id", id);
        this.requestAsync("https://api.weibo.com/2/favorites/create.json", params, "POST", listener);
    }

    public void destroy(long id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("id", id);
        this.requestAsync("https://api.weibo.com/2/favorites/destroy.json", params, "POST", listener);
    }

    public void destroyBatch(long[] ids, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        StringBuilder strb = new StringBuilder();
        for (long id : ids) {
            strb.append(id).append(",");
        }
        strb.deleteCharAt(strb.length() - 1);
        params.put("ids", strb.toString());
        this.requestAsync("https://api.weibo.com/2/favorites/destroy_batch.json", params, "POST", listener);
    }

    public void tagsUpdate(long id, String[] tags, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("id", id);
        StringBuilder strb = new StringBuilder();
        for (String tag : tags) {
            strb.append(tag).append(",");
        }
        strb.deleteCharAt(strb.length() - 1);
        params.put("tags", strb.toString());
        this.requestAsync("https://api.weibo.com/2/favorites/tags/update.json", params, "POST", listener);
    }

    public void tagsUpdateBatch(long id, String tag, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("tid", id);
        params.put("tag", tag);
        this.requestAsync("https://api.weibo.com/2/favorites/tags/update_batch.json", params, "POST", listener);
    }

    public void tagsDestroyBatch(long tid, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("tid", tid);
        this.requestAsync("https://api.weibo.com/2/favorites/tags/destroy_batch.json", params, "POST", listener);
    }

    private WeiboParameters buildCountPage(int count, int page) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("count", count);
        params.put("page", page);
        return params;
    }
}

