/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import android.content.Context;
import android.text.TextUtils;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class AccountAPI
extends AbsOpenAPI {
    public static final int SCHOOL_TYPE_COLLEGE = 1;
    public static final int SCHOOL_TYPE_SENIOR = 2;
    public static final int SCHOOL_TYPE_TECHNICAL = 3;
    public static final int SCHOOL_TYPE_JUNIOR = 4;
    public static final int SCHOOL_TYPE_PRIMARY = 5;
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/account";

    public AccountAPI(Context context, String appKey, Oauth2AccessToken accessToken) {
        super(context, appKey, accessToken);
    }

    public void getPrivacy(RequestListener listener) {
        this.requestAsync("https://api.weibo.com/2/account/get_privacy.json", new WeiboParameters(this.mAppKey), "GET", listener);
    }

    public void schoolList(int province, int city, int area, int schoolType, CAPITAL capital, String keyword, int count, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("province", province);
        params.put("city", city);
        params.put("area", area);
        params.put("type", schoolType);
        if (!TextUtils.isEmpty((CharSequence)capital.name())) {
            params.put("capital", capital.name());
        } else if (!TextUtils.isEmpty((CharSequence)keyword)) {
            params.put("keyword", keyword);
        }
        params.put("count", count);
        this.requestAsync("https://api.weibo.com/2/account/profile/school_list.json", params, "GET", listener);
    }

    public void rateLimitStatus(RequestListener listener) {
        this.requestAsync("https://api.weibo.com/2/account/rate_limit_status.json", new WeiboParameters(this.mAppKey), "GET", listener);
    }

    public void getUid(RequestListener listener) {
        this.requestAsync("https://api.weibo.com/2/account/get_uid.json", new WeiboParameters(this.mAppKey), "GET", listener);
    }

    public void endSession(RequestListener listener) {
        this.requestAsync("https://api.weibo.com/2/account/end_session.json", new WeiboParameters(this.mAppKey), "POST", listener);
    }

    public static enum CAPITAL {
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        I,
        J,
        K,
        L,
        M,
        N,
        O,
        P,
        Q,
        R,
        S,
        T,
        U,
        V,
        W,
        X,
        Y,
        Z;

    }
}

