/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi;

import android.content.Context;
import android.text.TextUtils;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.AsyncWeiboRunner;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;

public abstract class AbsOpenAPI {
    private static final String TAG = AbsOpenAPI.class.getName();
    protected static final String API_SERVER = "https://api.weibo.com/2";
    protected static final String HTTPMETHOD_POST = "POST";
    protected static final String HTTPMETHOD_GET = "GET";
    protected static final String KEY_ACCESS_TOKEN = "access_token";
    protected Oauth2AccessToken mAccessToken;
    protected Context mContext;
    protected String mAppKey;

    public AbsOpenAPI(Context context, String appKey, Oauth2AccessToken accessToken) {
        this.mContext = context;
        this.mAppKey = appKey;
        this.mAccessToken = accessToken;
    }

    protected void requestAsync(String url, WeiboParameters params, String httpMethod, RequestListener listener) {
        if (null == this.mAccessToken || TextUtils.isEmpty((CharSequence)url) || null == params || TextUtils.isEmpty((CharSequence)httpMethod) || null == listener) {
            LogUtil.e((String)TAG, (String)"Argument error!");
            return;
        }
        params.put(KEY_ACCESS_TOKEN, this.mAccessToken.getToken());
        new AsyncWeiboRunner(this.mContext).requestAsync(url, params, httpMethod, listener);
    }

    protected String requestSync(String url, WeiboParameters params, String httpMethod) {
        if (null == this.mAccessToken || TextUtils.isEmpty((CharSequence)url) || null == params || TextUtils.isEmpty((CharSequence)httpMethod)) {
            LogUtil.e((String)TAG, (String)"Argument error!");
            return "";
        }
        params.put(KEY_ACCESS_TOKEN, this.mAccessToken.getToken());
        return new AsyncWeiboRunner(this.mContext).request(url, params, httpMethod);
    }
}

