/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.auth.WeiboParameters;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.openapi.legacy.WeiboAPI;

public class SuggestionsAPI
extends WeiboAPI {
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/suggestions";

    public SuggestionsAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void usersHot(WeiboAPI.USER_CATEGORY category, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.add("category", category.name());
        this.request("https://api.weibo.com/2/suggestions/users/hot.json", params, "GET", listener);
    }

    public void mayInterested(int count, int page, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.add("count", count);
        params.add("page", page);
        this.request("https://api.weibo.com/2/suggestions/users/may_interested.json", params, "GET", listener);
    }

    public void byStatus(String content, int num, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.add("content", content);
        params.add("num", num);
        this.request("https://api.weibo.com/2/suggestions/users/may_interested.json", params, "GET", listener);
    }

    public void statusesHot(WeiboAPI.STATUSES_TYPE type, boolean is_pic, int count, int page, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.add("type", type.ordinal() + 1);
        if (is_pic) {
            params.add("is_pic", 1);
        } else {
            params.add("is_pic", 0);
        }
        params.add("count", count);
        params.add("page", page);
        this.request("https://api.weibo.com/2/suggestions/statuses/hot.json", params, "GET", listener);
    }

    public void favoritesHot(int count, int page, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.add("count", count);
        params.add("page", page);
        this.request("https://api.weibo.com/2/suggestions/favorites/hot.json", params, "GET", listener);
    }

    public void notInterested(long uid, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.add("uid", uid);
        this.request("https://api.weibo.com/2/suggestions/users/not_interested.json", params, "POST", listener);
    }
}

