/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi;

import android.os.Handler;
import android.os.Message;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.auth.WeiboParameters;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.AsyncWeiboRunner;
import com.sina.weibo.sdk.net.RequestListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class AbsOpenAPI {
    private static final int MSG_ON_COMPLETE = 1;
    private static final int MSG_ON_COMPLETE_FOR_BINARY = 2;
    private static final int MSG_ON_IOEXCEPTION = 3;
    private static final int MSG_ON_ERROR = 4;
    protected static final String API_SERVER = "https://api.weibo.com/2";
    protected static final String HTTPMETHOD_POST = "POST";
    protected static final String HTTPMETHOD_GET = "GET";
    protected static final String KEY_ACCESS_TOKEN = "access_token";
    protected Oauth2AccessToken mAccessToken;
    private RequestListener mRequestListener;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (null == AbsOpenAPI.this.mRequestListener) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    AbsOpenAPI.this.mRequestListener.onComplete((String)msg.obj);
                    break;
                }
                case 2: {
                    AbsOpenAPI.this.mRequestListener.onComplete4binary((ByteArrayOutputStream)msg.obj);
                    break;
                }
                case 3: {
                    AbsOpenAPI.this.mRequestListener.onIOException((IOException)msg.obj);
                    break;
                }
                case 4: {
                    AbsOpenAPI.this.mRequestListener.onError((WeiboException)((Object)msg.obj));
                    break;
                }
            }
        }
    };
    private RequestListener mInternalListener = new RequestListener(){

        @Override
        public void onComplete(String response) {
            AbsOpenAPI.this.mHandler.obtainMessage(1, (Object)response).sendToTarget();
        }

        @Override
        public void onComplete4binary(ByteArrayOutputStream responseOS) {
            AbsOpenAPI.this.mHandler.obtainMessage(2, (Object)responseOS).sendToTarget();
        }

        @Override
        public void onIOException(IOException e) {
            AbsOpenAPI.this.mHandler.obtainMessage(3, (Object)e).sendToTarget();
        }

        @Override
        public void onError(WeiboException e) {
            AbsOpenAPI.this.mHandler.obtainMessage(4, (Object)e).sendToTarget();
        }
    };

    public AbsOpenAPI(Oauth2AccessToken accessToken) {
        this.mAccessToken = accessToken;
    }

    protected void request(String url, WeiboParameters params, String httpMethod, RequestListener listener) {
        this.mRequestListener = listener;
        params.add(KEY_ACCESS_TOKEN, this.mAccessToken.getToken());
        AsyncWeiboRunner.request(url, params, httpMethod, this.mInternalListener);
    }
}

