/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.sdk.view;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import com.weibo.sdk.android.Oauth2AccessToken;
import com.weibo.sdk.android.WeiboParameters;
import com.weibo.sdk.android.net.AsyncWeiboRunner;
import com.weibo.sdk.android.net.RequestListener;
import com.weibo.sdk.android.util.AccessTokenKeeper;

public class LogoutButton
extends Button
implements View.OnClickListener {
    public static final String TAG = "WEIBO_SDK_LOGIN";
    private final String REVOKE_OAUTH_URL = "https://api.weibo.com/oauth2/revokeoauth2";
    private Context mContext;
    RequestListener mRequestListener = null;

    public LogoutButton(Context context) {
        super(context);
        this.mContext = context;
        this.setOnClickListener(this);
    }

    public LogoutButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.setOnClickListener(this);
    }

    public LogoutButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.setOnClickListener(this);
    }

    public void onClick(View v) {
        Oauth2AccessToken accessToken = AccessTokenKeeper.readAccessToken(this.mContext);
        if (TextUtils.isEmpty((CharSequence)accessToken.getToken())) {
            Toast.makeText((Context)this.mContext, (CharSequence)this.mContext.getResources().getString(2131165229), (int)1).show();
            return;
        }
        WeiboParameters params = new WeiboParameters();
        params.add("access_token", accessToken.getToken());
        Log.d((String)TAG, (String)"click logout : url==https://api.weibo.com/oauth2/revokeoauth2");
        AsyncWeiboRunner.request("https://api.weibo.com/oauth2/revokeoauth2", params, "POST", this.mRequestListener);
    }

    public void setRequestListener(RequestListener requestListener) {
        this.mRequestListener = requestListener;
    }
}

