/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.sdk.android;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Xml;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.weibo.sdk.android.Weibo;
import com.weibo.sdk.android.WeiboAuthListener;
import com.weibo.sdk.android.WeiboDialogError;
import com.weibo.sdk.android.WeiboException;
import com.weibo.sdk.android.util.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class WeiboDialog
extends Dialog
implements View.OnClickListener {
    private static final String TAG = "WEIBO_SDK_LOGIN";
    private Context mContext;
    private RelativeLayout mContent;
    private RelativeLayout mWebViewContainer;
    private ProgressDialog mSpinner;
    private WebView mWebView;
    private String mAuthUrl;
    private WeiboAuthListener mListener;
    private static int theme = 0x1030010;
    private static int left_margin = 0;
    private static int top_margin = 0;
    private static int right_margin = 0;
    private static int bottom_margin = 0;

    public WeiboDialog(Context context, String url, WeiboAuthListener listener) {
        super(context, theme);
        this.mAuthUrl = url;
        this.mListener = listener;
        this.mContext = context;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mListener.onCancel();
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initWindow();
        this.initLoadingDlg();
        this.initWebview();
        this.initCloseButton();
        Utility.isNetworkAvailable(this.mContext);
    }

    private void initWindow() {
        this.requestWindowFeature(1);
        this.getWindow().setFeatureDrawableAlpha(0, 0);
        this.getWindow().setSoftInputMode(16);
        this.mContent = new RelativeLayout(this.getContext());
        this.addContentView((View)this.mContent, new ViewGroup.LayoutParams(-1, -1));
    }

    private void initLoadingDlg() {
        this.mSpinner = new ProgressDialog(this.getContext());
        this.mSpinner.requestWindowFeature(1);
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String loading = "loading\u2026\u2026";
        if ("zh".equalsIgnoreCase(language) || "zh_CN".equalsIgnoreCase(language)) {
            loading = "\u52a0\u8f7d\u4e2d\u2026\u2026";
            if ("TW".equalsIgnoreCase(locale.getCountry())) {
                loading = "\u52a0\u8f09\u4e2d\u2026\u2026";
            }
        }
        this.mSpinner.setMessage((CharSequence)loading);
    }

    private void initWebview() {
        float density;
        DisplayMetrics dm;
        RelativeLayout.LayoutParams webviewLayout;
        RelativeLayout.LayoutParams webViewContainerLayout;
        block20: {
            this.mWebViewContainer = new RelativeLayout(this.getContext());
            this.mWebView = new WebView(this.getContext());
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.getSettings().setSavePassword(false);
            this.mWebView.setWebViewClient((WebViewClient)new WeiboWebViewClient());
            WeiboDialog.synCookies(this.mContext, this.mAuthUrl);
            this.mWebView.loadUrl(this.mAuthUrl);
            this.mWebView.requestFocus();
            this.mWebView.setScrollBarStyle(0);
            this.mWebView.setVisibility(4);
            webViewContainerLayout = new RelativeLayout.LayoutParams(-1, -1);
            webviewLayout = new RelativeLayout.LayoutParams(-1, -1);
            AssetManager asseets = this.getContext().getAssets();
            InputStream is = null;
            dm = this.getContext().getResources().getDisplayMetrics();
            density = dm.density;
            try {
                try {
                    try {
                        is = asseets.open("weibosdk_dialog_bg.9.png");
                        webviewLayout.leftMargin = (int)(10.0f * density);
                        webviewLayout.topMargin = (int)(10.0f * density);
                        webviewLayout.rightMargin = (int)(10.0f * density);
                        webviewLayout.bottomMargin = (int)(10.0f * density);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (is == null) {
                        this.mWebViewContainer.setBackgroundResource(2130837540);
                    } else {
                        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
                        NinePatchDrawable npd = new NinePatchDrawable(bitmap, bitmap.getNinePatchChunk(), new Rect(0, 0, 0, 0), null);
                        this.mWebViewContainer.setBackgroundDrawable((Drawable)npd);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.mWebViewContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)webviewLayout);
        this.mWebViewContainer.setGravity(17);
        if (this.parseDimens()) {
            webViewContainerLayout.leftMargin = left_margin;
            webViewContainerLayout.topMargin = (double)density == 1.0 ? 15 : ((double)density == 1.5 ? 25 : dm.heightPixels / 15);
            webViewContainerLayout.rightMargin = right_margin;
            int space = (int)(1.5 * (double)(dm.widthPixels - 2 * left_margin));
            webViewContainerLayout.bottomMargin = dm.heightPixels - webViewContainerLayout.topMargin - space;
            webViewContainerLayout.bottomMargin = webViewContainerLayout.bottomMargin <= 0 ? bottom_margin : webViewContainerLayout.bottomMargin;
        } else {
            Resources resources = this.getContext().getResources();
            webViewContainerLayout.leftMargin = resources.getDimensionPixelSize(2131099651);
            webViewContainerLayout.rightMargin = resources.getDimensionPixelSize(2131099653);
            webViewContainerLayout.topMargin = resources.getDimensionPixelSize(2131099652);
            webViewContainerLayout.bottomMargin = resources.getDimensionPixelSize(2131099654);
        }
        this.mContent.setBackgroundColor(0);
        this.mContent.addView((View)this.mWebViewContainer, (ViewGroup.LayoutParams)webViewContainerLayout);
    }

    private void initCloseButton() {
        DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
        String imageName = dm.densityDpi >= 240 ? "weibosdk_close_hdpi.png" : "weibosdk_close_mdpi.png";
        Drawable drawable = this.getDrawableFromAssert(imageName);
        ImageView closeImage = new ImageView(this.mContext);
        closeImage.setImageDrawable(drawable);
        closeImage.setOnClickListener((View.OnClickListener)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mWebViewContainer.getLayoutParams();
        layoutParams.leftMargin = params.leftMargin - drawable.getIntrinsicWidth() / 2 + 5;
        layoutParams.topMargin = params.topMargin - drawable.getIntrinsicHeight() / 2 + 5;
        this.mContent.addView((View)closeImage, (ViewGroup.LayoutParams)layoutParams);
    }

    protected void onBack() {
        try {
            this.mSpinner.dismiss();
            if (this.mWebView != null) {
                this.mWebView.stopLoading();
                this.mWebView.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dismiss();
    }

    public static void synCookies(Context context, String url) {
        CookieSyncManager.createInstance((Context)context);
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        cookieManager.removeSessionCookie();
        cookieManager.removeAllCookie();
        CookieSyncManager.getInstance().sync();
    }

    private void handleRedirectUrl(WebView view, String url) {
        Bundle values = Utility.parseUrl(url);
        String error = values.getString("error");
        String error_code = values.getString("error_code");
        if (error == null && error_code == null) {
            this.mListener.onComplete(values);
        } else if (error_code == null) {
            this.mListener.onWeiboException(new WeiboException(error, 0));
        } else {
            this.mListener.onWeiboException(new WeiboException(error, Integer.parseInt(error_code)));
        }
    }

    private boolean parseDimens() {
        boolean ret;
        block21: {
            ret = false;
            AssetManager asseets = this.getContext().getAssets();
            DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
            float density = dm.density;
            InputStream is = null;
            try {
                try {
                    is = asseets.open("values/dimens.xml");
                    XmlPullParser xmlpull = Xml.newPullParser();
                    try {
                        xmlpull.setInput(is, "utf-8");
                        int eventCode = xmlpull.getEventType();
                        ret = true;
                        while (eventCode != 1) {
                            switch (eventCode) {
                                case 2: {
                                    String value;
                                    if (!xmlpull.getName().equals("dimen")) break;
                                    String name = xmlpull.getAttributeValue(null, "name");
                                    if ("weibosdk_dialog_left_margin".equals(name)) {
                                        value = xmlpull.nextText();
                                        left_margin = (int)((float)Integer.parseInt(value) * density);
                                        break;
                                    }
                                    if ("weibosdk_dialog_top_margin".equals(name)) {
                                        value = xmlpull.nextText();
                                        top_margin = (int)((float)Integer.parseInt(value) * density);
                                        break;
                                    }
                                    if ("weibosdk_dialog_right_margin".equals(name)) {
                                        value = xmlpull.nextText();
                                        right_margin = (int)((float)Integer.parseInt(value) * density);
                                        break;
                                    }
                                    if (!"weibosdk_dialog_bottom_margin".equals(name)) break;
                                    value = xmlpull.nextText();
                                    bottom_margin = (int)((float)Integer.parseInt(value) * density);
                                }
                            }
                            eventCode = xmlpull.next();
                        }
                    }
                    catch (XmlPullParserException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (is == null) break block21;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ret;
    }

    private Drawable getDrawableFromAssert(String resourceRelativePath) {
        BitmapDrawable rtDrawable;
        block13: {
            rtDrawable = null;
            AssetManager asseets = this.getContext().getAssets();
            InputStream is = null;
            try {
                try {
                    is = asseets.open(resourceRelativePath);
                    if (is != null) {
                        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
                        DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
                        bitmap.setDensity(dm.densityDpi);
                        rtDrawable = new BitmapDrawable(this.getContext().getResources(), bitmap);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (is == null) break block13;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    is = null;
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    is = null;
                }
            }
        }
        return rtDrawable;
    }

    public void onClick(View view) {
        if (view instanceof ImageView) {
            this.onBack();
            this.mListener.onCancel();
        }
    }

    private class WeiboWebViewClient
    extends WebViewClient {
        private boolean isCallBacked = false;

        private WeiboWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.startsWith("sms:")) {
                Intent sendIntent = new Intent("android.intent.action.VIEW");
                sendIntent.putExtra("address", url.replace("sms:", ""));
                sendIntent.setType("vnd.android-dir/mms-sms");
                WeiboDialog.this.getContext().startActivity(sendIntent);
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            WeiboDialog.this.dismiss();
            WeiboDialog.this.mListener.onError(new WeiboDialogError(description, errorCode, failingUrl));
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Log.d((String)WeiboDialog.TAG, (String)("onPageStarted URL: " + url));
            if (url.startsWith(Weibo.getRedirecturl()) && !this.isCallBacked) {
                this.isCallBacked = true;
                WeiboDialog.this.dismiss();
                WeiboDialog.this.handleRedirectUrl(view, url);
                view.stopLoading();
                return;
            }
            super.onPageStarted(view, url, favicon);
            WeiboDialog.this.mSpinner.show();
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            Log.d((String)WeiboDialog.TAG, (String)("onPageFinished URL: " + url));
            if (WeiboDialog.this.mSpinner.isShowing()) {
                WeiboDialog.this.mSpinner.dismiss();
            }
            WeiboDialog.this.mWebView.setVisibility(0);
        }
    }
}

