/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.sdk.android;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.webkit.CookieSyncManager;
import com.sina.weibo.sdk.log.Log;
import com.weibo.sdk.android.Oauth2AccessToken;
import com.weibo.sdk.android.WeiboAuthListener;
import com.weibo.sdk.android.WeiboDialog;
import com.weibo.sdk.android.WeiboDialogError;
import com.weibo.sdk.android.WeiboException;
import com.weibo.sdk.android.WeiboParameters;
import com.weibo.sdk.android.net.AsyncWeiboRunner;
import com.weibo.sdk.android.net.RequestListener;
import com.weibo.sdk.android.util.AccessTokenKeeper;
import com.weibo.sdk.android.util.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Weibo {
    public static final String TAG = "WEIBO_SDK_LOGIN";
    private static String URL_OAUTH2_ACCESS_AUTHORIZE = "https://open.weibo.cn/oauth2";
    private static Weibo mWeiboInstance = null;
    private static String app_key = "";
    private static String redirecturl = "";
    private static String scope = "";
    private static String app_secret = "";
    private static final String SCOPE_EMAIL = "email";
    private static final String SCOPE_DIRECT_MESSAGES_WRITE = "direct_messages_write";
    private static final String SCOPE_DIRECT_MESSAGES_READ = "direct_messages_read";
    private static final String SCOPE_FRIENDSHIPS_GROUPS_READ = "friendships_groups_read";
    private static final String SCOPE_FRIENDSHIPS_GROUPS_WRITE = "friendships_groups_write";
    private static final String SCOPE_STATUSES_TO_ME_READ = "statuses_to_me_read";
    private static final String SCOPE_FOLLOW_APP_OFFICIAL_MICROBLOG = "follow_app_official_microblog";
    private static final int AUTH_CODE = 0;
    private static final int AUTH_TOKEN = 1;
    private Oauth2AccessToken accessToken = null;
    private static final String KEY_TOKEN = "access_token";
    private static final String KEY_EXPIRES = "expires_in";
    private static final String KEY_REFRESHTOKEN = "refresh_token";
    private static boolean isWifi = false;
    private static final int AUTH_ONCMPLT = 1000;
    private static final int AUTH_ONRR = 1001;
    private WeiboAuthListener mlistener;
    private static String mPackagename;
    private static String mkeyHash;
    private Context ct;
    private Handler mWeiboHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    if (msg.getData() != null) {
                        Weibo.this.mlistener.onComplete(msg.getData());
                        break;
                    }
                    Weibo.this.mlistener.onWeiboException(new WeiboException("Failed to receive access token."));
                    break;
                }
                case 1001: {
                    if (msg.obj != null) {
                        Weibo.this.mlistener.onWeiboException((WeiboException)msg.obj);
                    }
                    if (msg.getData() == null) break;
                    String error = msg.getData().getString("error");
                    String error_code = msg.getData().getString("error_code");
                    String error_description = msg.getData().getString("error_description");
                    Weibo.this.mlistener.onWeiboException(new WeiboException(String.valueOf(error) + "-" + error_description, Integer.parseInt(error_code)));
                }
            }
        }
    };

    public static synchronized Weibo getInstance(String appKey, String redirectUrl, String aScope) {
        if (TextUtils.isEmpty((CharSequence)appKey) | TextUtils.isEmpty((CharSequence)redirectUrl)) {
            throw new RuntimeException("Parameter is not complete, please fill complete appkey and redirectUrl.");
        }
        if (mWeiboInstance == null) {
            mWeiboInstance = new Weibo();
        }
        app_key = appKey;
        redirecturl = redirectUrl;
        scope = aScope;
        return mWeiboInstance;
    }

    public void setupConsumerConfig(String appKey, String redirectUrl) {
        app_key = appKey;
        redirecturl = redirectUrl;
    }

    public void anthorize(Context context, WeiboAuthListener listener) {
        this.mlistener = listener;
        this.ct = context;
        mPackagename = this.ct.getApplicationContext().getPackageName();
        isWifi = Utility.isWifi(this.ct);
        this.startAuthDialog(context, listener, 0);
    }

    public void startAuthDialog(Context context, final WeiboAuthListener listener, final int type) {
        WeiboParameters params = new WeiboParameters();
        CookieSyncManager.createInstance((Context)context);
        this.startDialog(context, params, new WeiboAuthListener(){

            @Override
            public void onComplete(Bundle values) {
                CookieSyncManager.getInstance().sync();
                String code = values.getString("code");
                if (1 == type) {
                    Weibo.this.FtchAccessToken(code);
                } else if (type == 0) {
                    listener.onComplete(values);
                }
            }

            @Override
            public void onWeiboException(WeiboException error) {
                listener.onWeiboException(error);
            }

            @Override
            public void onCancel() {
                listener.onCancel();
            }

            @Override
            public void onError(WeiboDialogError e) {
                listener.onError(e);
            }
        });
    }

    private void KeepAccessToken(Bundle values, WeiboAuthListener listener) {
        String code = values.getString("code");
        if (code != null) {
            listener.onComplete(values);
        } else {
            String token = values.getString(KEY_TOKEN);
            String expires_in = values.getString(KEY_EXPIRES);
            if (TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires_in)) {
                WeiboException e = new WeiboException("\u6388\u6743\u5931\u8d25\uff01");
                listener.onWeiboException(e);
                return;
            }
            Oauth2AccessToken accessToken = new Oauth2AccessToken(token, expires_in);
            if (accessToken.isSessionValid()) {
                AccessTokenKeeper.keepAccessToken(this.ct, accessToken);
                listener.onComplete(values);
            }
        }
    }

    private void startDialog(Context context, WeiboParameters parameters, WeiboAuthListener listener) {
        parameters.add("client_id", app_key);
        parameters.add("response_type", "code");
        parameters.add("redirect_uri", redirecturl);
        parameters.add("display", "mobile");
        parameters.add("scope", scope);
        parameters.add("packagename", mPackagename);
        parameters.add("key_hash", Utility.getSign(context, mPackagename));
        String url = String.valueOf(URL_OAUTH2_ACCESS_AUTHORIZE) + "/authorize?" + Utility.encodeUrl(parameters);
        if (context.checkCallingOrSelfPermission("android.permission.INTERNET") != 0) {
            Utility.showAlert(context, "Error", "Application requires permission to access the Internet");
        } else {
            new WeiboDialog(context, url, listener).show();
        }
    }

    private void FtchAccessToken(String authorization_code) {
        WeiboParameters params = new WeiboParameters();
        params.add("client_id", app_key);
        params.add("client_secret", app_secret);
        params.add("grant_type", "authorization_code");
        params.add("code", authorization_code);
        params.add("redirect_uri", redirecturl);
        AsyncWeiboRunner.request(String.valueOf(URL_OAUTH2_ACCESS_AUTHORIZE) + "/access_token", params, "POST", new RequestListener(){

            @Override
            public void onComplete(String response) {
                if (Weibo.this.accessToken == null) {
                    Weibo.this.accessToken = new Oauth2AccessToken(response);
                }
                if (Weibo.this.accessToken.isSessionValid()) {
                    Log.d("Weibo-authorize", "Login Success! access_token=" + Weibo.this.accessToken.getToken() + " expires=" + Weibo.this.accessToken.getExpiresTime() + " refresh_token=" + Weibo.this.accessToken.getRefreshToken());
                    Bundle b = Utility.formBundle(Weibo.this.accessToken);
                    Weibo.this.handleListItemEvent(1000, b, null);
                    return;
                }
                Log.d("Weibo-authorize", "Failed to receive access token");
                Weibo.this.handleListItemEvent(1001, null, null);
            }

            @Override
            public void onComplete4binary(ByteArrayOutputStream responseOS) {
            }

            @Override
            public void onIOException(IOException e) {
                Weibo.this.handleListItemEvent(1001, null, e);
            }

            @Override
            public void onError(WeiboException e) {
                Bundle b = Utility.errorSAX(e.getMessage());
                Weibo.this.handleListItemEvent(1001, b, null);
            }
        });
    }

    private void handleListItemEvent(int eventId, Bundle b, Exception e) {
        Message msg = Message.obtain();
        msg.what = eventId;
        switch (eventId) {
            case 1000: {
                if (b == null) break;
                msg.setData(b);
                break;
            }
            case 1001: {
                if (e != null) {
                    msg.obj = e;
                }
                if (b == null) break;
                msg.setData(b);
            }
        }
        this.mWeiboHandler.sendMessage(msg);
    }

    public static boolean isWifi() {
        return isWifi;
    }

    public static String getApp_key() {
        return app_key;
    }

    public static String getRedirecturl() {
        return redirecturl;
    }

    public static String getScope() {
        return scope;
    }

    public static void setWifi(boolean isWifi) {
        Weibo.isWifi = isWifi;
    }
}

