/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.sina.weibo.sdk.api.IWeiboDownloadListener;
import java.util.Locale;
import java.util.UUID;

public class Util {
    private static final String TITLE_CHINESS = "\u63d0\u793a";
    private static final String PROMPT_CHINESS = "\u672a\u5b89\u88c5\u5fae\u535a\u5ba2\u6237\u7aef\uff0c\u662f\u5426\u73b0\u5728\u53bb\u4e0b\u8f7d\uff1f";
    private static final String OK_CHINESS = "\u73b0\u5728\u4e0b\u8f7d";
    private static final String CANCEL_CHINESS = "\u4ee5\u540e\u518d\u8bf4";
    private static final String TITLE_ENGLISH = "Notice";
    private static final String PROMPT_ENGLISH = "Sina Weibo client is not installed, download now?";
    private static final String OK_ENGLISH = "Download Now";
    private static final String CANCEL_ENGLISH = "Download Later";

    public static String generateId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static byte[] getSign(Context context, String pkgName) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(pkgName, 64);
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            return null;
        }
        int j = 0;
        while (j < packageInfo.signatures.length) {
            byte[] str = packageInfo.signatures[j].toByteArray();
            if (str != null) {
                return str;
            }
            ++j;
        }
        return null;
    }

    public static void createConfirmDialog(final Activity activity, final IWeiboDownloadListener listener) {
        String title = TITLE_CHINESS;
        String prompt = PROMPT_CHINESS;
        String ok = OK_CHINESS;
        String cancel = CANCEL_CHINESS;
        if (!Util.isChineseLocale(activity.getApplicationContext())) {
            title = TITLE_ENGLISH;
            prompt = PROMPT_ENGLISH;
            ok = OK_ENGLISH;
            cancel = CANCEL_ENGLISH;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setMessage((CharSequence)prompt);
        builder.setTitle((CharSequence)title);
        builder.setPositiveButton((CharSequence)ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Util.downloadWeibo(activity);
                try {
                    dialog.dismiss();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        builder.setNegativeButton((CharSequence)cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                try {
                    dialog.dismiss();
                    if (listener != null) {
                        listener.onCancel();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        builder.create().show();
    }

    private static boolean isChineseLocale(Context context) {
        try {
            Locale locale = context.getResources().getConfiguration().locale;
            return Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale) || Locale.SIMPLIFIED_CHINESE.equals(locale) || Locale.TAIWAN.equals(locale);
        }
        catch (Exception e) {
            return true;
        }
    }

    private static void downloadWeibo(Activity activity) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        Uri url = Uri.parse((String)"http://app.sina.cn/appdetail.php?appID=84560");
        intent.setData(url);
        try {
            activity.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

