/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.handler;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.sina.weibo.sdk.log.Log;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.Util;

public class ActivityHandler {
    public static boolean sendToWeibo(Activity act, String packageName, String content, Bundle data) {
        return ActivityHandler.send(act, packageName, "com.sina.weibo.sdk.action.ACTION_WEIBO_ACTIVITY", content, data);
    }

    public static boolean send(Activity act, String pkgName, String action, String key, Bundle data) {
        if (act == null || pkgName == null || pkgName.length() == 0 || action == null || action.length() == 0) {
            Log.e("ActivityHandler", "send fail, invalid arguments");
            return false;
        }
        Intent intent = new Intent();
        intent.setPackage(pkgName);
        intent.setAction(action);
        String appPackage = act.getPackageName();
        intent.putExtra("_weibo_sdkVersion", 22);
        intent.putExtra("_weibo_appPackage", appPackage);
        intent.putExtra("_weibo_appKey", key);
        intent.putExtra("_weibo_flag", 538116905);
        intent.putExtra("_weibo_sign", MD5.hexdigest(Util.getSign((Context)act, appPackage)));
        if (data != null) {
            intent.putExtras(data);
        }
        try {
            act.startActivityForResult(intent, 765);
        }
        catch (ActivityNotFoundException e) {
            Log.e("ActivityHandler", "send fail, target ActivityNotFound");
            return false;
        }
        Log.d("ActivityHandler", "send weibo message, intent=" + intent);
        return true;
    }
}

