/*
 * Decompiled with CFR 0.152.
 */
package retrofit.processor;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor6;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import retrofit.processor.MissingTypeException;
import retrofit.processor.SimpleNameFunction;
import retrofit.processor.TypeMirrorSet;

final class TypeSimplifier {
    private final Types typeUtils;
    private final Map<String, Spelling> imports;
    private final ToStringTypeVisitor TO_STRING_TYPE_VISITOR = new ToStringTypeVisitor();
    private final ToStringTypeVisitor TO_STRING_RAW_TYPE_VISITOR = new ToStringRawTypeVisitor();
    private static final AbstractTypeVisitor6<Boolean, Boolean> CASTING_UNCHECKED_VISITOR = new SimpleTypeVisitor6<Boolean, Boolean>(){
        private final Predicate<TypeMirror> UNCHECKED_TYPE_ARGUMENT = new Predicate<TypeMirror>(){

            public boolean apply(TypeMirror arg) {
                WildcardType wildcard;
                if (arg.getKind() == TypeKind.WILDCARD && ((wildcard = (WildcardType)arg).getExtendsBound() == null || this.isJavaLangObject(wildcard.getExtendsBound()))) {
                    return wildcard.getSuperBound() != null;
                }
                return true;
            }
        };

        @Override
        protected Boolean defaultAction(TypeMirror e, Boolean p) {
            return p;
        }

        @Override
        public Boolean visitUnknown(TypeMirror t, Boolean p) {
            return true;
        }

        @Override
        public Boolean visitArray(ArrayType t, Boolean p) {
            return (Boolean)this.visit(t.getComponentType(), p);
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Boolean p) {
            return p != false || FluentIterable.from(t.getTypeArguments()).anyMatch(this.UNCHECKED_TYPE_ARGUMENT);
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable t, Boolean p) {
            return true;
        }

        private boolean isJavaLangObject(TypeMirror type) {
            if (type.getKind() != TypeKind.DECLARED) {
                return false;
            }
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals("java.lang.Object");
        }
    };

    TypeSimplifier(Types typeUtils, String packageName, Set<TypeMirror> types, TypeMirror base) {
        this.typeUtils = typeUtils;
        TypeMirrorSet typesPlusBase = new TypeMirrorSet(types);
        if (base != null) {
            typesPlusBase.add(base);
        }
        Set<TypeMirror> referenced = TypeSimplifier.referencedClassTypes(typeUtils, typesPlusBase);
        Set<TypeMirror> defined = TypeSimplifier.nonPrivateDeclaredTypes(typeUtils, base);
        this.imports = TypeSimplifier.findImports(typeUtils, packageName, referenced, defined);
    }

    SortedSet<String> typesToImport() {
        TreeSet<String> typesToImport = new TreeSet<String>();
        for (Map.Entry<String, Spelling> entry : this.imports.entrySet()) {
            if (!entry.getValue().importIt) continue;
            typesToImport.add(entry.getKey());
        }
        return typesToImport;
    }

    String simplify(TypeMirror type) {
        return type.accept(this.TO_STRING_TYPE_VISITOR, new StringBuilder()).toString();
    }

    String simplifyRaw(TypeMirror type) {
        return type.accept(this.TO_STRING_RAW_TYPE_VISITOR, new StringBuilder()).toString();
    }

    String formalTypeParametersString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<");
        String sep = "";
        for (TypeParameterElement typeParameterElement : typeParameters) {
            sb.append(sep);
            sep = ", ";
            this.appendTypeParameterWithBounds(sb, typeParameterElement);
        }
        return sb.append(">").toString();
    }

    static String actualTypeParametersString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        return "<" + FluentIterable.from(typeParameters).transform((Function)SimpleNameFunction.INSTANCE).join(Joiner.on((String)", ")) + ">";
    }

    private void appendTypeParameterWithBounds(StringBuilder sb, TypeParameterElement typeParameter) {
        sb.append(typeParameter.getSimpleName());
        String sep = " extends ";
        for (TypeMirror typeMirror : typeParameter.getBounds()) {
            if (typeMirror.toString().equals("java.lang.Object")) continue;
            sb.append(sep);
            sep = " & ";
            typeMirror.accept(this.TO_STRING_TYPE_VISITOR, sb);
        }
    }

    static String classNameOf(TypeElement type) {
        String name = type.getQualifiedName().toString();
        String pkgName = TypeSimplifier.packageNameOf(type);
        return pkgName.isEmpty() ? name : name.substring(pkgName.length() + 1);
    }

    static String packageNameOf(TypeElement type) {
        Element enclosing;
        while (!((enclosing = type.getEnclosingElement()) instanceof PackageElement)) {
            type = (TypeElement)enclosing;
        }
        return ((PackageElement)enclosing).getQualifiedName().toString();
    }

    static String simpleNameOf(String s) {
        if (s.contains(".")) {
            return s.substring(s.lastIndexOf(46) + 1);
        }
        return s;
    }

    private static Map<String, Spelling> findImports(Types typeUtils, String packageName, Set<TypeMirror> referenced, Set<TypeMirror> defined) {
        HashMap<String, Spelling> imports = new HashMap<String, Spelling>();
        TypeMirrorSet typesInScope = new TypeMirrorSet();
        typesInScope.addAll(referenced);
        typesInScope.addAll(defined);
        Set<String> ambiguous = TypeSimplifier.ambiguousNames(typeUtils, typesInScope);
        for (TypeMirror type : referenced) {
            String spelling;
            boolean importIt;
            TypeElement typeElement = (TypeElement)typeUtils.asElement(type);
            String fullName = typeElement.getQualifiedName().toString();
            String simpleName = typeElement.getSimpleName().toString();
            String pkg = TypeSimplifier.packageNameOf(typeElement);
            if (ambiguous.contains(simpleName)) {
                importIt = false;
                spelling = fullName;
            } else if (pkg.equals(packageName) || pkg.equals("java.lang")) {
                importIt = false;
                spelling = fullName.substring(pkg.isEmpty() ? 0 : pkg.length() + 1);
            } else {
                importIt = true;
                spelling = simpleName;
            }
            imports.put(fullName, new Spelling(spelling, importIt));
        }
        return imports;
    }

    private static Set<TypeMirror> referencedClassTypes(Types typeUtil, Set<TypeMirror> types) {
        TypeMirrorSet referenced = new TypeMirrorSet();
        ReferencedClassTypeVisitor referencedClassVisitor = new ReferencedClassTypeVisitor(typeUtil, referenced);
        for (TypeMirror type : types) {
            referencedClassVisitor.visit(type);
        }
        return referenced;
    }

    private static Set<TypeMirror> nonPrivateDeclaredTypes(Types typeUtils, TypeMirror type) {
        if (type == null) {
            return new TypeMirrorSet();
        }
        TypeMirrorSet declared = new TypeMirrorSet();
        declared.add(type);
        List<TypeElement> nestedTypes = ElementFilter.typesIn(typeUtils.asElement(type).getEnclosedElements());
        for (TypeElement typeElement : nestedTypes) {
            if (typeElement.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            declared.add(typeElement.asType());
        }
        for (TypeMirror typeMirror : typeUtils.directSupertypes(type)) {
            declared.addAll(TypeSimplifier.nonPrivateDeclaredTypes(typeUtils, typeMirror));
        }
        return declared;
    }

    private static Set<String> ambiguousNames(Types typeUtils, Set<TypeMirror> types) {
        HashSet<String> ambiguous = new HashSet<String>();
        HashSet<String> simpleNames = new HashSet<String>();
        for (TypeMirror type : types) {
            if (type.getKind() == TypeKind.ERROR) {
                throw new MissingTypeException();
            }
            String simpleName = typeUtils.asElement(type).getSimpleName().toString();
            if (simpleNames.add(simpleName)) continue;
            ambiguous.add(simpleName);
        }
        return ambiguous;
    }

    static boolean isCastingUnchecked(TypeMirror type) {
        return CASTING_UNCHECKED_VISITOR.visit(type, false);
    }

    private static class ReferencedClassTypeVisitor
    extends SimpleTypeVisitor6<Void, Void> {
        private final Types typeUtils;
        private final Set<TypeMirror> referencedTypes;
        private final Set<TypeMirror> seenTypes;

        ReferencedClassTypeVisitor(Types typeUtils, Set<TypeMirror> referenced) {
            this.typeUtils = typeUtils;
            this.referencedTypes = referenced;
            this.seenTypes = new TypeMirrorSet();
        }

        @Override
        public Void visitArray(ArrayType t, Void p) {
            return (Void)this.visit(t.getComponentType(), p);
        }

        @Override
        public Void visitDeclared(DeclaredType t, Void p) {
            if (this.seenTypes.add(t)) {
                this.referencedTypes.add(this.typeUtils.erasure(t));
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    this.visit(typeMirror, p);
                }
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, Void p) {
            for (TypeMirror typeMirror : this.typeUtils.directSupertypes(t)) {
                this.visit(typeMirror, p);
            }
            return (Void)this.visit(t.getLowerBound(), p);
        }

        @Override
        public Void visitWildcard(WildcardType t, Void p) {
            for (TypeMirror bound : new TypeMirror[]{t.getSuperBound(), t.getExtendsBound()}) {
                if (bound == null) continue;
                this.visit(bound, p);
            }
            return null;
        }

        @Override
        public Void visitError(ErrorType t, Void p) {
            throw new MissingTypeException();
        }
    }

    private class ToStringRawTypeVisitor
    extends ToStringTypeVisitor {
        private ToStringRawTypeVisitor() {
        }

        @Override
        void appendTypeArguments(DeclaredType type, StringBuilder sb) {
        }
    }

    private class ToStringTypeVisitor
    extends SimpleTypeVisitor6<StringBuilder, StringBuilder> {
        private ToStringTypeVisitor() {
        }

        @Override
        protected StringBuilder defaultAction(TypeMirror type, StringBuilder sb) {
            return sb.append(type);
        }

        @Override
        public StringBuilder visitArray(ArrayType type, StringBuilder sb) {
            return ((StringBuilder)this.visit(type.getComponentType(), sb)).append("[]");
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType type, StringBuilder sb) {
            TypeElement typeElement = (TypeElement)TypeSimplifier.this.typeUtils.asElement(type);
            String typeString = typeElement.getQualifiedName().toString();
            if (TypeSimplifier.this.imports.containsKey(typeString)) {
                sb.append(((Spelling)((TypeSimplifier)TypeSimplifier.this).imports.get((Object)typeString)).spelling);
            } else {
                sb.append(typeString);
            }
            this.appendTypeArguments(type, sb);
            return sb;
        }

        void appendTypeArguments(DeclaredType type, StringBuilder sb) {
            List<? extends TypeMirror> arguments = type.getTypeArguments();
            if (!arguments.isEmpty()) {
                sb.append("<");
                String sep = "";
                for (TypeMirror typeMirror : arguments) {
                    sb.append(sep);
                    sep = ", ";
                    this.visit(typeMirror, sb);
                }
                sb.append(">");
            }
        }

        @Override
        public StringBuilder visitWildcard(WildcardType type, StringBuilder sb) {
            sb.append("?");
            TypeMirror extendsBound = type.getExtendsBound();
            TypeMirror superBound = type.getSuperBound();
            if (superBound != null) {
                sb.append(" super ");
                this.visit(superBound, sb);
            } else if (extendsBound != null) {
                sb.append(" extends ");
                this.visit(extendsBound, sb);
            }
            return sb;
        }
    }

    private static class Spelling {
        final String spelling;
        final boolean importIt;

        Spelling(String spelling, boolean importIt) {
            this.spelling = spelling;
            this.importIt = importIt;
        }
    }
}

