/*
 * Decompiled with CFR 0.152.
 */
package retrofit.processor;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.log.NullLogChute;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.ResourceCacheImpl;
import retrofit.processor.RetrofitTemplateVars;

abstract class TemplateVars {
    private static final RuntimeInstance velocityRuntimeInstance = new RuntimeInstance();
    private final ImmutableList<Field> fields;

    abstract SimpleNode parsedTemplate();

    TemplateVars() {
        Field[] declaredFields;
        if (this.getClass().getSuperclass() != TemplateVars.class) {
            throw new IllegalArgumentException("Class must extend TemplateVars directly");
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Field field : declaredFields = this.getClass().getDeclaredFields()) {
            if (field.isSynthetic() || TemplateVars.isStaticFinal(field)) continue;
            if (Modifier.isPrivate(field.getModifiers())) {
                throw new IllegalArgumentException("Field cannot be private: " + field);
            }
            if (Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field cannot be static unless also final: " + field);
            }
            if (field.getType().isPrimitive()) {
                throw new IllegalArgumentException("Field cannot be primitive: " + field);
            }
            fields.add((Object)field);
        }
        this.fields = fields.build();
    }

    String toText() {
        SimpleNode parsedTemplate;
        StringWriter writer;
        VelocityContext velocityContext = this.toVelocityContext();
        boolean rendered = velocityRuntimeInstance.render((Context)velocityContext, (Writer)(writer = new StringWriter()), (parsedTemplate = this.parsedTemplate()).getTemplateName(), parsedTemplate);
        if (!rendered) {
            throw new IllegalArgumentException("Template rendering failed");
        }
        return writer.toString();
    }

    private VelocityContext toVelocityContext() {
        VelocityContext velocityContext = new VelocityContext();
        for (Field field : this.fields) {
            Object value = TemplateVars.fieldValue(field, this);
            if (value == null) {
                throw new IllegalArgumentException("Field cannot be null (was it set?): " + field);
            }
            Object old = velocityContext.put(field.getName(), value);
            if (old == null) continue;
            throw new IllegalArgumentException("Two fields called " + field.getName() + "?!");
        }
        return velocityContext;
    }

    static SimpleNode parsedTemplateForResource(String templateStr, String resourceName) {
        try {
            return velocityRuntimeInstance.parse(templateStr, resourceName);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    static SimpleNode parsedTemplateForResource(String resourceName) {
        InputStream in = RetrofitTemplateVars.class.getResourceAsStream(resourceName);
        if (in == null) {
            throw new IllegalArgumentException("Could not find resource: " + resourceName);
        }
        try {
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            return velocityRuntimeInstance.parse((Reader)reader, resourceName);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Object fieldValue(Field field, Object container) {
        try {
            return field.get(container);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    static {
        velocityRuntimeInstance.setProperty("runtime.references.strict", (Object)"true");
        velocityRuntimeInstance.setProperty("runtime.log.logsystem.class", (Object)new NullLogChute());
        velocityRuntimeInstance.setProperty("resource.manager.cache.class", (Object)ResourceCacheImpl.class.getName());
        velocityRuntimeInstance.setProperty("runtime.log.logsystem", (Object)new NullLogChute());
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(TemplateVars.class.getClassLoader());
            velocityRuntimeInstance.init();
        }
        finally {
            currentThread.setContextClassLoader(oldContextLoader);
        }
    }
}

