/*
 * Decompiled with CFR 0.152.
 */
package retrofit.processor;

import com.google.auto.service.AutoService;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import retrofit.Callback;
import retrofit.client.Response;
import retrofit.converter.GsonConverter;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.Field;
import retrofit.http.GET;
import retrofit.http.HEAD;
import retrofit.http.Header;
import retrofit.http.Headers;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Path;
import retrofit.http.Query;
import retrofit.http.QueryMap;
import retrofit.http.Retrofit;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedFile;
import retrofit.mime.TypedString;
import retrofit.processor.AbortProcessingException;
import retrofit.processor.AnnotationOutput;
import retrofit.processor.BuilderSpec;
import retrofit.processor.EclipseHack;
import retrofit.processor.ErrorReporter;
import retrofit.processor.GwtCompatibility;
import retrofit.processor.GwtSerialization;
import retrofit.processor.MissingTypeException;
import retrofit.processor.Reformatter;
import retrofit.processor.RetrofitTemplateVars;
import retrofit.processor.SimpleNameFunction;
import retrofit.processor.TypeMirrorSet;
import retrofit.processor.TypeSimplifier;
import rx.Observable;

@AutoService(value=Processor.class)
public class RetrofitProcessor
extends AbstractProcessor {
    private ErrorReporter errorReporter;
    private final List<String> deferredTypeNames = new ArrayList<String>();
    private Action1<? super AnnotationMirror> onAnnotationForProperty;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)Retrofit.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.errorReporter = new ErrorReporter(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<TypeElement> deferredTypes = new ArrayList<TypeElement>();
        for (String deferred : this.deferredTypeNames) {
            deferredTypes.add(this.processingEnv.getElementUtils().getTypeElement(deferred));
        }
        if (roundEnv.processingOver()) {
            for (TypeElement type : deferredTypes) {
                this.errorReporter.reportError("Did not generate @Retrofit class for " + type.getQualifiedName() + " because it references undefined types", type);
            }
            return false;
        }
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(Retrofit.class);
        ImmutableList types = new ImmutableList.Builder().addAll(deferredTypes).addAll(ElementFilter.typesIn(annotatedElements)).build();
        this.deferredTypeNames.clear();
        for (TypeElement type : types) {
            try {
                this.processType(type);
            }
            catch (AbortProcessingException e) {
            }
            catch (MissingTypeException e) {
                this.deferredTypeNames.add(type.getQualifiedName().toString());
            }
            catch (RuntimeException e) {
                String trace = Throwables.getStackTraceAsString((Throwable)e);
                this.errorReporter.reportError("@Retrofit processor threw an exception: " + trace, type);
            }
        }
        return false;
    }

    private String generatedClassName(TypeElement type, String prefix) {
        String name = type.getSimpleName().toString();
        while (type.getEnclosingElement() instanceof TypeElement) {
            type = (TypeElement)type.getEnclosingElement();
            name = type.getSimpleName() + "_" + name;
        }
        String pkg = TypeSimplifier.packageNameOf(type);
        String dot = pkg.isEmpty() ? "" : ".";
        return pkg + dot + prefix + name;
    }

    private String generatedSubclassName(TypeElement type) {
        return this.generatedClassName(type, "Retrofit_");
    }

    private void onAnnotationForProperty(AnnotationMirror annotation) {
        this.onAnnotationForProperty.call(annotation);
    }

    private void annotationForProperty(Action1<? super AnnotationMirror> onAnnotationForProperty) {
        this.onAnnotationForProperty = onAnnotationForProperty;
    }

    private static boolean isJavaLangObject(TypeElement type) {
        return type.getSuperclass().getKind() == TypeKind.NONE && type.getKind() == ElementKind.CLASS;
    }

    private static ObjectMethodToOverride objectMethodToOverride(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        switch (method.getParameters().size()) {
            case 0: {
                if (name.equals("toString")) {
                    return ObjectMethodToOverride.TO_STRING;
                }
                if (name.equals("hashCode")) {
                    return ObjectMethodToOverride.HASH_CODE;
                }
                if (!name.equals("describeContents")) break;
                return ObjectMethodToOverride.DESCRIBE_CONTENTS;
            }
            case 1: {
                if (!name.equals("equals") || !method.getParameters().get(0).asType().toString().equals("java.lang.Object")) break;
                return ObjectMethodToOverride.EQUALS;
            }
            case 2: {
                if (!name.equals("writeToParcel") || !method.getParameters().get(0).asType().toString().equals("android.os.Parcel") || !method.getParameters().get(1).asType().toString().equals("int")) break;
                return ObjectMethodToOverride.WRITE_TO_PARCEL;
            }
        }
        return ObjectMethodToOverride.NONE;
    }

    private void findLocalAndInheritedMethods(TypeElement type, List<ExecutableElement> methods) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        Elements elementUtils = this.processingEnv.getElementUtils();
        for (TypeMirror typeMirror : type.getInterfaces()) {
            this.findLocalAndInheritedMethods((TypeElement)typeUtils.asElement(typeMirror), methods);
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            this.findLocalAndInheritedMethods((TypeElement)typeUtils.asElement(type.getSuperclass()), methods);
        }
        List<ExecutableElement> theseMethods = ElementFilter.methodsIn(type.getEnclosedElements());
        for (ExecutableElement method : theseMethods) {
            if (method.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            boolean alreadySeen = false;
            Iterator<ExecutableElement> methodIter = methods.iterator();
            while (methodIter.hasNext()) {
                ExecutableElement otherMethod = methodIter.next();
                if (elementUtils.overrides(method, otherMethod, type)) {
                    methodIter.remove();
                    continue;
                }
                if (!method.getSimpleName().equals(otherMethod.getSimpleName()) || !method.getParameters().equals(otherMethod.getParameters())) continue;
                alreadySeen = true;
            }
            if (alreadySeen) continue;
            methods.add(method);
        }
    }

    private void processType(TypeElement type) {
        Retrofit autoValue = type.getAnnotation(Retrofit.class);
        if (autoValue == null) {
            this.errorReporter.abortWithError("annotation processor for @Retrofit was invoked with a type that does not have that annotation; this is probably a compiler bug", type);
        }
        if (type.getKind() != ElementKind.CLASS) {
            this.errorReporter.abortWithError("@" + Retrofit.class.getName() + " only applies to classes", type);
        }
        if (this.ancestorIsRetrofit(type)) {
            this.errorReporter.abortWithError("One @Retrofit class may not extend another", type);
        }
        if (this.implementsAnnotation(type)) {
            this.errorReporter.abortWithError("@Retrofit may not be used to implement an annotation interface; try using @AutoAnnotation instead", type);
        }
        RetrofitTemplateVars vars = new RetrofitTemplateVars();
        vars.pkg = TypeSimplifier.packageNameOf(type);
        vars.origClass = TypeSimplifier.classNameOf(type);
        vars.simpleClassName = TypeSimplifier.simpleNameOf(vars.origClass);
        vars.subclass = TypeSimplifier.simpleNameOf(this.generatedSubclassName(type));
        this.defineVarsForType(type, vars);
        GwtCompatibility gwtCompatibility = new GwtCompatibility(type);
        vars.gwtCompatibleAnnotation = gwtCompatibility.gwtCompatibleAnnotationString();
        String text = vars.toText();
        text = Reformatter.fixup(text);
        this.writeSourceFile(this.generatedSubclassName(type), text, type);
        GwtSerialization gwtSerialization = new GwtSerialization(gwtCompatibility, this.processingEnv, type);
        gwtSerialization.maybeWriteGwtSerializer(vars);
    }

    private void defineVarsForType(TypeElement type, RetrofitTemplateVars vars) {
        TypeElement parcelable;
        Retrofit.Authenticated authenticatedAnnotation;
        Retrofit.Authenticator authenticatorAnnotation;
        Retrofit.RequestInterceptor requestInterceptorAnnotation;
        Retrofit.LogLevel logLevelAnnotation;
        Retrofit.ErrorHandler errorHandlerAnnotation;
        Retrofit.Converter converterAnnotation;
        ImmutableSet<ExecutableElement> toBuilderMethods;
        BuilderSpec builderSpec;
        Optional<BuilderSpec.Builder> builder;
        Types typeUtils = this.processingEnv.getTypeUtils();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        this.findLocalAndInheritedMethods(type, methods);
        RetrofitProcessor.determineObjectMethodsToGenerate(methods, vars);
        ImmutableSet<ExecutableElement> methodsToImplement = this.methodsToImplement(methods);
        TypeMirrorSet types = new TypeMirrorSet();
        types.addAll(this.returnTypesOf((Iterable<ExecutableElement>)methodsToImplement));
        TypeMirror javaUtilArrays = this.getTypeMirror(Arrays.class);
        if (RetrofitProcessor.containsArrayType(types)) {
            types.add(javaUtilArrays);
        }
        if ((builder = (builderSpec = new BuilderSpec(type, this.processingEnv, this.errorReporter)).getBuilder()).isPresent()) {
            types.add(this.getTypeMirror(BitSet.class));
            toBuilderMethods = ((BuilderSpec.Builder)builder.get()).toBuilderMethods(typeUtils, (Set<ExecutableElement>)methodsToImplement);
        } else {
            toBuilderMethods = ImmutableSet.of();
        }
        vars.toBuilderMethods = FluentIterable.from((Iterable)toBuilderMethods).transform((Function)SimpleNameFunction.INSTANCE).toList();
        Sets.SetView propertyMethods = Sets.difference(methodsToImplement, (Set)toBuilderMethods);
        String pkg = TypeSimplifier.packageNameOf(type);
        TypeSimplifier typeSimplifier = new TypeSimplifier(typeUtils, pkg, types, type.asType());
        vars.imports = typeSimplifier.typesToImport();
        vars.arrays = typeSimplifier.simplify(javaUtilArrays);
        vars.bitSet = typeSimplifier.simplifyRaw(this.getTypeMirror(BitSet.class));
        ImmutableMap<ExecutableElement, String> methodToPropertyName = this.methodToPropertyNameMap((Iterable<ExecutableElement>)propertyMethods);
        LinkedHashMap methodToIdentifier = Maps.newLinkedHashMap(methodToPropertyName);
        this.fixReservedIdentifiers(methodToIdentifier);
        ArrayList<Property> props = new ArrayList<Property>();
        for (ExecutableElement method : propertyMethods) {
            String propertyType = typeSimplifier.simplify(method.getReturnType());
            String[] propertyName = (String[])methodToPropertyName.get((Object)method);
            String identifier = (String)methodToIdentifier.get(method);
            ArrayList args = new ArrayList();
            props.add(new Property((String)propertyName, identifier, method, propertyType, typeSimplifier, this.processingEnv));
        }
        this.eclipseHack().reorderProperties(props);
        vars.props = props;
        vars.serialVersionUID = this.getSerialVersionUID(type);
        vars.formalTypes = typeSimplifier.formalTypeParametersString(type);
        vars.actualTypes = TypeSimplifier.actualTypeParametersString(type);
        vars.wildcardTypes = RetrofitProcessor.wildcardTypeParametersString(type);
        Retrofit typeAnnoation = type.getAnnotation(Retrofit.class);
        vars.baseUrl = typeAnnoation.value();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Retrofit.Headers headersAnnotation = type.getAnnotation(Retrofit.Headers.class);
        if (headersAnnotation != null) {
            for (String header : headersAnnotation.value()) {
                String[] tokens = header.split(":");
                headerMap.put(tokens[0].trim(), "\"" + tokens[1].trim() + "\"");
            }
            vars.headers = headerMap;
        }
        HashMap<String, String> retryHeaderMap = new HashMap<String, String>();
        Retrofit.RetryHeaders retryHeadersAnnotation = type.getAnnotation(Retrofit.RetryHeaders.class);
        if (retryHeadersAnnotation != null) {
            for (String header : retryHeadersAnnotation.value()) {
                String[] tokens = header.split(":");
                retryHeaderMap.put(tokens[0].trim(), "\"" + tokens[1].trim() + "\"");
            }
            vars.retryHeaders = retryHeaderMap;
        }
        if ((converterAnnotation = type.getAnnotation(Retrofit.Converter.class)) != null) {
            TypeMirror converter = null;
            try {
                converter = this.getTypeMirror(converterAnnotation.value());
            }
            catch (MirroredTypeException mte) {
                converter = mte.getTypeMirror();
            }
            vars.converter = typeSimplifier.simplify(converter);
            TypeMirror gsonConverterType = this.getTypeMirror(GsonConverter.class);
            if (typeUtils.isSubtype(gsonConverterType, converter)) {
                vars.gsonConverter = vars.converter;
            }
        }
        if ((errorHandlerAnnotation = type.getAnnotation(Retrofit.ErrorHandler.class)) != null) {
            TypeMirror errorHandler = null;
            try {
                errorHandler = this.getTypeMirror(errorHandlerAnnotation.value());
            }
            catch (MirroredTypeException mte) {
                errorHandler = mte.getTypeMirror();
            }
            vars.errorHandler = typeSimplifier.simplify(errorHandler);
        }
        if ((logLevelAnnotation = type.getAnnotation(Retrofit.LogLevel.class)) != null) {
            vars.logLevel = logLevelAnnotation.value();
        }
        if ((requestInterceptorAnnotation = type.getAnnotation(Retrofit.RequestInterceptor.class)) != null) {
            TypeMirror requestInterceptor = null;
            try {
                requestInterceptor = this.getTypeMirror(requestInterceptorAnnotation.value());
            }
            catch (MirroredTypeException mte) {
                requestInterceptor = mte.getTypeMirror();
            }
            vars.requestInterceptor = typeSimplifier.simplify(requestInterceptor);
        }
        if ((authenticatorAnnotation = type.getAnnotation(Retrofit.Authenticator.class)) != null) {
            TypeMirror authenticator = null;
            try {
                authenticator = this.getTypeMirror(authenticatorAnnotation.value());
            }
            catch (MirroredTypeException mte) {
                authenticator = mte.getTypeMirror();
            }
            vars.authenticator = typeSimplifier.simplify(authenticator);
        }
        if ((authenticatedAnnotation = type.getAnnotation(Retrofit.Authenticated.class)) != null) {
            TypeMirror authenticatedType = null;
            try {
                authenticatedType = this.getTypeMirror(authenticatedAnnotation.value());
            }
            catch (MirroredTypeException mte) {
                authenticatedType = mte.getTypeMirror();
            }
            String authenticated = typeSimplifier.simplify(authenticatedType);
            vars.authenticated = authenticated != null && !"".equals(authenticated);
        }
        vars.parcelable = (parcelable = this.processingEnv.getElementUtils().getTypeElement("android.os.Parcelable")) != null && this.processingEnv.getTypeUtils().isAssignable(type.asType(), parcelable.asType());
        if (builder.isPresent()) {
            ((BuilderSpec.Builder)builder.get()).defineVars(vars, typeSimplifier, (Map<ExecutableElement, String>)methodToPropertyName);
        }
    }

    private ImmutableMap<ExecutableElement, String> methodToPropertyNameMap(Iterable<ExecutableElement> propertyMethods) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        boolean allGetters = RetrofitProcessor.allGetters(propertyMethods);
        for (ExecutableElement method : propertyMethods) {
            String methodName = method.getSimpleName().toString();
            String name = allGetters ? this.nameWithoutPrefix(methodName) : methodName;
            builder.put((Object)method, (Object)name);
        }
        ImmutableMap map = builder.build();
        if (allGetters) {
            this.checkDuplicateGetters((Map<ExecutableElement, String>)map);
        }
        return map;
    }

    private static boolean allGetters(Iterable<ExecutableElement> methods) {
        for (ExecutableElement method : methods) {
            boolean is;
            String name = method.getSimpleName().toString();
            boolean get = name.startsWith("get") && !name.equals("get");
            boolean bl = is = name.startsWith("is") && !name.equals("is") && method.getReturnType().getKind() == TypeKind.BOOLEAN;
            if (get || is) continue;
            return false;
        }
        return true;
    }

    private String nameWithoutPrefix(String name) {
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else {
            assert (name.startsWith("is"));
            name = name.substring(2);
        }
        return Introspector.decapitalize(name);
    }

    private void checkDuplicateGetters(Map<ExecutableElement, String> methodToIdentifier) {
    }

    private void fixReservedIdentifiers(Map<ExecutableElement, String> methodToIdentifier) {
        for (Map.Entry<ExecutableElement, String> entry : methodToIdentifier.entrySet()) {
            if (!SourceVersion.isKeyword(entry.getValue())) continue;
            entry.setValue(this.disambiguate(entry.getValue(), methodToIdentifier.values()));
        }
    }

    private String disambiguate(String name, Collection<String> existingNames) {
        int i = 0;
        String candidate;
        while (existingNames.contains(candidate = name + i)) {
            ++i;
        }
        return candidate;
    }

    private Set<TypeMirror> returnTypesOf(Iterable<ExecutableElement> methods) {
        TypeMirrorSet returnTypes = new TypeMirrorSet();
        for (ExecutableElement method : methods) {
            returnTypes.add(method.getReturnType());
        }
        return returnTypes;
    }

    private static boolean containsArrayType(Set<TypeMirror> types) {
        for (TypeMirror type : types) {
            if (type.getKind() != TypeKind.ARRAY) continue;
            return true;
        }
        return false;
    }

    private static void determineObjectMethodsToGenerate(List<ExecutableElement> methods, RetrofitTemplateVars vars) {
        vars.equals = false;
        vars.hashCode = false;
        vars.toString = false;
        for (ExecutableElement method : methods) {
            ObjectMethodToOverride override = RetrofitProcessor.objectMethodToOverride(method);
            boolean canGenerate = method.getModifiers().contains((Object)Modifier.ABSTRACT) || RetrofitProcessor.isJavaLangObject((TypeElement)method.getEnclosingElement());
            switch (override) {
                case EQUALS: {
                    vars.equals = canGenerate;
                    break;
                }
                case HASH_CODE: {
                    vars.hashCode = canGenerate;
                    break;
                }
                case TO_STRING: {
                    vars.toString = canGenerate;
                }
            }
        }
    }

    private ImmutableSet<ExecutableElement> methodsToImplement(List<ExecutableElement> methods) {
        ImmutableSet.Builder toImplement = ImmutableSet.builder();
        boolean errors = false;
        for (ExecutableElement method : methods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT) || RetrofitProcessor.objectMethodToOverride(method) != ObjectMethodToOverride.NONE) continue;
            if (method.getParameters().isEmpty() && method.getReturnType().getKind() != TypeKind.VOID) {
                if (RetrofitProcessor.isReferenceArrayType(method.getReturnType())) {
                    this.errorReporter.reportError("An @Retrofit class cannot define an array-valued property unless it is a primitive array", method);
                    errors = true;
                }
                toImplement.add((Object)method);
                continue;
            }
            toImplement.add((Object)method);
        }
        if (errors) {
            throw new AbortProcessingException();
        }
        return toImplement.build();
    }

    private static boolean isReferenceArrayType(TypeMirror type) {
        return type.getKind() == TypeKind.ARRAY && !((ArrayType)type).getComponentType().getKind().isPrimitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSourceFile(String className, String text, TypeElement originatingType) {
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(className, originatingType);
            Writer writer = sourceFile.openWriter();
            try {
                writer.write(text);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not write generated class " + className + ": " + e);
        }
    }

    private boolean ancestorIsRetrofit(TypeElement type) {
        TypeMirror parentMirror;
        while ((parentMirror = type.getSuperclass()).getKind() != TypeKind.NONE) {
            Types typeUtils = this.processingEnv.getTypeUtils();
            TypeElement parentElement = (TypeElement)typeUtils.asElement(parentMirror);
            if (parentElement.getAnnotation(Retrofit.class) != null) {
                return true;
            }
            type = parentElement;
        }
        return false;
    }

    private boolean implementsAnnotation(TypeElement type) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        return typeUtils.isAssignable(type.asType(), this.getTypeMirror(Annotation.class));
    }

    private String getSerialVersionUID(TypeElement type) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeMirror serializable = this.getTypeMirror(Serializable.class);
        if (typeUtils.isAssignable(type.asType(), serializable)) {
            List<VariableElement> fields = ElementFilter.fieldsIn(type.getEnclosedElements());
            for (VariableElement field : fields) {
                if (!field.getSimpleName().toString().equals("serialVersionUID")) continue;
                Object value = field.getConstantValue();
                if (field.getModifiers().containsAll(Arrays.asList(Modifier.STATIC, Modifier.FINAL)) && field.asType().getKind() == TypeKind.LONG && value != null) {
                    return value + "L";
                }
                this.errorReporter.reportError("serialVersionUID must be a static final long compile-time constant", field);
                break;
            }
        }
        return "";
    }

    private TypeMirror getTypeMirror(Class<?> c) {
        return RetrofitProcessor.getTypeMirror(this.processingEnv, c);
    }

    private TypeMirror getTypeMirror(String canonicalName) {
        return RetrofitProcessor.getTypeMirror(this.processingEnv, canonicalName);
    }

    private static TypeMirror getTypeMirror(ProcessingEnvironment processingEnv, Class<?> c) {
        return RetrofitProcessor.getTypeMirror(processingEnv, c.getCanonicalName());
    }

    private static TypeMirror getTypeMirror(ProcessingEnvironment processingEnv, String canonicalName) {
        return processingEnv.getElementUtils().getTypeElement(canonicalName).asType();
    }

    private static String wildcardTypeParametersString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        return "<" + Joiner.on((String)", ").join((Iterable)FluentIterable.from(typeParameters).transform(Functions.constant((Object)"?"))) + ">";
    }

    private static String catArgsString(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.isEmpty()) {
            return "";
        }
        return "" + Joiner.on((String)" + ").join((Iterable)FluentIterable.from(parameters).transform((Function)new Function<VariableElement, String>(){

            public String apply(VariableElement element) {
                return "" + element.getSimpleName();
            }
        })) + "";
    }

    private static String formalArgsString(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.isEmpty()) {
            return "";
        }
        return "" + Joiner.on((String)", ").join((Iterable)FluentIterable.from(parameters).transform((Function)new Function<VariableElement, String>(){

            public String apply(VariableElement element) {
                return "" + element.getSimpleName();
            }
        })) + "";
    }

    private static String formalTypeArgsString(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.isEmpty()) {
            return "";
        }
        return "" + Joiner.on((String)", ").join((Iterable)FluentIterable.from(parameters).transform((Function)new Function<VariableElement, String>(){

            public String apply(VariableElement element) {
                return "final " + element.asType() + " " + element.getSimpleName();
            }
        })) + "";
    }

    private EclipseHack eclipseHack() {
        return new EclipseHack(this.processingEnv);
    }

    private static enum ObjectMethodToOverride {
        NONE,
        TO_STRING,
        EQUALS,
        HASH_CODE,
        DESCRIBE_CONTENTS,
        WRITE_TO_PARCEL;

    }

    public static class Property {
        private final String name;
        private final String identifier;
        private final ExecutableElement method;
        private final String type;
        private String typeArgs;
        private String typeArgs2;
        private final ImmutableList<String> annotations;
        private final String args;
        private final String path;
        private final Map<String, String> queries;
        private final List<String> queryMaps;
        private final List<String> queryBundles;
        private final boolean isGet;
        private final boolean isPut;
        private final boolean isPost;
        private final boolean isDelete;
        private final boolean isHead;
        private final boolean isObservable;
        private final boolean isResponseType;
        private final boolean isVoid;
        private final boolean isBlocking;
        private final String body;
        private final String callbackType;
        private final TypeMirror callbackTypeMirror;
        private final String callbackArg;
        private final ProcessingEnvironment processingEnv;
        private final TypeSimplifier typeSimplifier;
        private final List<String> permissions;
        private final boolean isAuthenticated;
        private final boolean isSingletonRequestInterceptor;
        private final Map<String, String> headers;
        private final Map<String, String> fields;
        private final Map<String, Part> parts;
        private String callbackName;
        public final String converter;
        public String gsonConverter = "";
        public final String errorHandler;
        public final String logLevel;
        public final String requestInterceptor;

        Property(String name, String identifier, ExecutableElement method, String type, TypeSimplifier typeSimplifier, ProcessingEnvironment processingEnv) {
            this.name = name;
            this.identifier = identifier;
            this.method = method;
            this.type = type;
            this.typeSimplifier = typeSimplifier;
            this.processingEnv = processingEnv;
            this.annotations = this.buildAnnotations(typeSimplifier);
            this.args = RetrofitProcessor.formalTypeArgsString(method);
            this.path = this.buildPath(method);
            this.queries = this.buildQueries(method);
            this.queryMaps = this.buildQueryMaps(method);
            this.queryBundles = this.buildQueryBundles(method);
            this.isGet = this.buildIsGet(method);
            this.isPut = this.buildIsPut(method);
            this.isPost = this.buildIsPost(method);
            this.isDelete = this.buildIsDelete(method);
            this.isHead = this.buildIsHead(method);
            this.isAuthenticated = this.buildIsAuthenticated(method);
            this.isObservable = this.buildIsObservable(method);
            this.body = this.buildBody(method);
            this.callbackTypeMirror = this.buildCallbackTypeMirror(method);
            this.callbackType = this.buildCallbackTypeArgument(method);
            this.callbackArg = this.buildTypeArguments(this.callbackType);
            this.isBlocking = !this.isCallback() && !this.isObservable();
            this.isResponseType = this.buildIsResponseType(method);
            if (this.isObservable()) {
                this.typeArgs = this.buildTypeArguments(type);
                this.typeArgs2 = this.buildTypeArguments(this.typeArgs);
            } else if (this.isCallback()) {
                this.typeArgs = this.callbackType;
                this.typeArgs2 = this.buildTypeArguments(this.typeArgs);
            } else {
                this.typeArgs = type;
            }
            if ("".equals(this.typeArgs)) {
                this.typeArgs = this.callbackType;
            }
            this.isVoid = this.buildIsVoid(method);
            this.permissions = this.buildPermissions(method);
            this.headers = this.buildHeaders(method);
            this.fields = this.buildFields(method);
            this.parts = this.buildParts(method);
            this.converter = this.buildConverter(method);
            this.errorHandler = this.buildErrorHandler(method);
            this.logLevel = this.buildLogLevel(method);
            this.requestInterceptor = this.buildRequestInterceptor(method);
            this.isSingletonRequestInterceptor = this.buildIsSingletonRequestInterceptor(method);
        }

        private String buildRequestInterceptor(ExecutableElement method) {
            String name = "";
            Retrofit.RequestInterceptor requestInterceptorAnnotation = method.getAnnotation(Retrofit.RequestInterceptor.class);
            if (requestInterceptorAnnotation != null) {
                TypeMirror requestInterceptor = null;
                try {
                    requestInterceptor = RetrofitProcessor.getTypeMirror(this.processingEnv, requestInterceptorAnnotation.value());
                }
                catch (MirroredTypeException mte) {
                    requestInterceptor = mte.getTypeMirror();
                }
                name = this.typeSimplifier.simplify(requestInterceptor);
            }
            return name;
        }

        private String buildConverter(ExecutableElement method) {
            String converterName = "";
            Retrofit.Converter converterAnnotation = method.getAnnotation(Retrofit.Converter.class);
            if (converterAnnotation != null) {
                TypeMirror converter = null;
                try {
                    converter = RetrofitProcessor.getTypeMirror(this.processingEnv, converterAnnotation.value());
                }
                catch (MirroredTypeException mte) {
                    converter = mte.getTypeMirror();
                }
                converterName = this.typeSimplifier.simplify(converter);
                TypeMirror gsonConverterType = RetrofitProcessor.getTypeMirror(this.processingEnv, GsonConverter.class);
                Types typeUtils = this.processingEnv.getTypeUtils();
                if (typeUtils.isSubtype(gsonConverterType, converter)) {
                    this.gsonConverter = converterName;
                }
            }
            return converterName;
        }

        private String buildErrorHandler(ExecutableElement method) {
            String name = "";
            Retrofit.ErrorHandler errorHandlerAnnotation = method.getAnnotation(Retrofit.ErrorHandler.class);
            if (errorHandlerAnnotation != null) {
                TypeMirror errorHandler = null;
                try {
                    errorHandler = RetrofitProcessor.getTypeMirror(this.processingEnv, errorHandlerAnnotation.value());
                }
                catch (MirroredTypeException mte) {
                    errorHandler = mte.getTypeMirror();
                }
                name = this.typeSimplifier.simplify(errorHandler);
            }
            return name;
        }

        private String buildLogLevel(ExecutableElement method) {
            Retrofit.LogLevel logLevelAnnotation = method.getAnnotation(Retrofit.LogLevel.class);
            if (logLevelAnnotation != null) {
                return "";
            }
            return "";
        }

        private boolean buildIsObservable(ExecutableElement method) {
            List<? extends TypeMirror> params;
            Types typeUtils = this.processingEnv.getTypeUtils();
            TypeMirror obsType = RetrofitProcessor.getTypeMirror(this.processingEnv, Observable.class);
            TypeMirror returnType = method.getReturnType();
            if (returnType instanceof DeclaredType && (params = ((DeclaredType)returnType).getTypeArguments()).size() == 1) {
                obsType = typeUtils.getDeclaredType((TypeElement)typeUtils.asElement(obsType), params.get(0));
                return typeUtils.isSubtype(returnType, obsType);
            }
            return false;
        }

        private boolean buildIsVoid(ExecutableElement method) {
            return method.getReturnType().getKind() == TypeKind.VOID;
        }

        private boolean buildIsResponseType(ExecutableElement method) {
            List<? extends TypeMirror> params;
            Types typeUtils = this.processingEnv.getTypeUtils();
            TypeMirror responseType = RetrofitProcessor.getTypeMirror(this.processingEnv, Response.class);
            TypeMirror returnType = method.getReturnType();
            if (this.isObservable()) {
                List<? extends TypeMirror> params2 = ((DeclaredType)returnType).getTypeArguments();
                if (params2.size() == 1) {
                    returnType = params2.get(0);
                    return typeUtils.isSubtype(returnType, responseType);
                }
            } else if (this.isCallback() && (params = ((DeclaredType)this.callbackTypeMirror).getTypeArguments()).size() == 1) {
                returnType = params.get(0);
                return typeUtils.isSubtype(returnType, responseType);
            }
            return typeUtils.isSubtype(returnType, responseType);
        }

        private String buildTypeArguments(String type) {
            Pattern pattern = Pattern.compile("<(.*)>");
            Matcher m = pattern.matcher(type);
            if (m.find()) {
                return m.group(1);
            }
            return "";
        }

        private TypeMirror buildCallbackTypeMirror(ExecutableElement method) {
            Types typeUtils = this.processingEnv.getTypeUtils();
            TypeMirror callback = RetrofitProcessor.getTypeMirror(this.processingEnv, Callback.class);
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                List<? extends TypeMirror> params;
                TypeMirror type = variableElement.asType();
                if (!(type instanceof DeclaredType) || (params = ((DeclaredType)type).getTypeArguments()).size() != 1 || !typeUtils.isSubtype(type, callback = typeUtils.getDeclaredType((TypeElement)typeUtils.asElement(callback), params.get(0)))) continue;
                this.callbackName = variableElement.getSimpleName().toString();
                return callback;
            }
            return null;
        }

        private String buildCallbackTypeArgument(ExecutableElement method) {
            Types typeUtils = this.processingEnv.getTypeUtils();
            TypeMirror callback = RetrofitProcessor.getTypeMirror(this.processingEnv, Callback.class);
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                List<? extends TypeMirror> params;
                TypeMirror type = variableElement.asType();
                if (!(type instanceof DeclaredType) || (params = ((DeclaredType)type).getTypeArguments()).size() != 1 || !typeUtils.isSubtype(type, callback = typeUtils.getDeclaredType((TypeElement)typeUtils.asElement(callback), params.get(0)))) continue;
                return this.typeSimplifier.simplify(params.get(0));
            }
            return "";
        }

        private String buildTypeArgument(TypeMirror type) {
            if (type != null) {
                List<? extends TypeMirror> params = ((DeclaredType)type).getTypeArguments();
                return this.typeSimplifier.simplify(params.get(0));
            }
            return "";
        }

        public boolean buildIsGet(ExecutableElement method) {
            return method.getAnnotation(Retrofit.GET.class) != null || method.getAnnotation(HEAD.class) != null;
        }

        public boolean buildIsPost(ExecutableElement method) {
            return method.getAnnotation(Retrofit.POST.class) != null || method.getAnnotation(HEAD.class) != null;
        }

        public boolean buildIsPut(ExecutableElement method) {
            return method.getAnnotation(Retrofit.PUT.class) != null || method.getAnnotation(HEAD.class) != null;
        }

        public boolean buildIsDelete(ExecutableElement method) {
            return method.getAnnotation(Retrofit.DELETE.class) != null || method.getAnnotation(HEAD.class) != null;
        }

        public boolean buildIsHead(ExecutableElement method) {
            return method.getAnnotation(Retrofit.HEAD.class) != null || method.getAnnotation(HEAD.class) != null;
        }

        public boolean buildIsAuthenticated(ExecutableElement method) {
            return method.getAnnotation(Retrofit.Authenticated.class) != null;
        }

        public boolean buildIsSingletonRequestInterceptor(ExecutableElement method) {
            Singleton singleton = null;
            Retrofit.RequestInterceptor requestInterceptorAnnotation = method.getAnnotation(Retrofit.RequestInterceptor.class);
            if (requestInterceptorAnnotation != null) {
                TypeMirror requestInterceptor = null;
                try {
                    requestInterceptor = RetrofitProcessor.getTypeMirror(this.processingEnv, requestInterceptorAnnotation.value());
                }
                catch (MirroredTypeException mte) {
                    requestInterceptor = mte.getTypeMirror();
                }
                Types typeUtils = this.processingEnv.getTypeUtils();
                TypeElement requestInterceptorType = (TypeElement)typeUtils.asElement(requestInterceptor);
                singleton = requestInterceptorType.getAnnotation(Singleton.class);
            }
            return singleton != null;
        }

        public String buildBody(ExecutableElement method) {
            String body = "";
            if (method.getAnnotation(Retrofit.POST.class) == null && method.getAnnotation(POST.class) == null) {
                return body;
            }
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                if (variableElement.getAnnotation(Retrofit.Body.class) == null && method.getAnnotation(Body.class) == null) continue;
                body = variableElement.getSimpleName().toString();
            }
            return body;
        }

        public List<String> buildPermissions(ExecutableElement method) {
            Retrofit.GET get = method.getAnnotation(Retrofit.GET.class);
            Retrofit.PUT put = method.getAnnotation(Retrofit.PUT.class);
            Retrofit.POST post = method.getAnnotation(Retrofit.POST.class);
            Retrofit.DELETE delete = method.getAnnotation(Retrofit.DELETE.class);
            Retrofit.HEAD head = method.getAnnotation(Retrofit.HEAD.class);
            if (get != null) {
                return Arrays.asList(get.permissions());
            }
            if (put != null) {
                return Arrays.asList(put.permissions());
            }
            if (post != null) {
                return Arrays.asList(post.permissions());
            }
            if (delete != null) {
                return Arrays.asList(delete.permissions());
            }
            if (head != null) {
                return Arrays.asList(head.permissions());
            }
            return Collections.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        public Map<String, String> buildHeaders(ExecutableElement method) {
            String header;
            void var8_10;
            String[] headers;
            HashMap<String, String> map = new HashMap<String, String>();
            Retrofit.Headers headersAnnotation = method.getAnnotation(Retrofit.Headers.class);
            Headers headers1Annotation = method.getAnnotation(Headers.class);
            if (headersAnnotation != null) {
                headers = headersAnnotation.value();
            } else if (headers1Annotation != null) {
                headers = headers1Annotation.value();
            } else {
                return Collections.emptyMap();
            }
            String[] stringArray = headers;
            int n = stringArray.length;
            boolean bl = false;
            while (var8_10 < n) {
                header = stringArray[var8_10];
                String[] tokens = header.split(":");
                map.put(tokens[0].trim(), "\"" + tokens[1].trim() + "\"");
                ++var8_10;
            }
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                header = variableElement.getAnnotation(Retrofit.Header.class);
                Header header1 = variableElement.getAnnotation(Header.class);
                String key = null;
                if (header != null) {
                    key = header.value().equals("") ? variableElement.getSimpleName().toString() : header.value();
                } else {
                    if (header1 == null) continue;
                    key = header1.value().equals("") ? variableElement.getSimpleName().toString() : header1.value();
                }
                map.put(key, variableElement.getSimpleName().toString());
            }
            return map;
        }

        public Map<String, String> buildFields(ExecutableElement method) {
            HashMap<String, String> map = new HashMap<String, String>();
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                Retrofit.Field field = variableElement.getAnnotation(Retrofit.Field.class);
                Field field1 = variableElement.getAnnotation(Field.class);
                String key = null;
                if (field != null) {
                    key = field.value().equals("") ? variableElement.getSimpleName().toString() : field.value();
                } else {
                    if (field1 == null) continue;
                    key = field1.value().equals("") ? variableElement.getSimpleName().toString() : field1.value();
                }
                map.put(key, variableElement.getSimpleName().toString());
            }
            return map;
        }

        public Map<String, Part> buildParts(ExecutableElement method) {
            HashMap<String, Part> map = new HashMap<String, Part>();
            Types typeUtils = this.processingEnv.getTypeUtils();
            TypeMirror fileType = RetrofitProcessor.getTypeMirror(this.processingEnv, File.class);
            TypeMirror typedFileType = RetrofitProcessor.getTypeMirror(this.processingEnv, TypedFile.class);
            TypeMirror typedStringType = RetrofitProcessor.getTypeMirror(this.processingEnv, TypedString.class);
            TypeMirror typedByteArrayType = RetrofitProcessor.getTypeMirror(this.processingEnv, TypedByteArray.class);
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                String mimeType = "";
                String value = "";
                Retrofit.Part partAnnotation = variableElement.getAnnotation(Retrofit.Part.class);
                retrofit.http.Part part1Annotation = variableElement.getAnnotation(retrofit.http.Part.class);
                if (partAnnotation != null) {
                    value = partAnnotation.value();
                    mimeType = partAnnotation.mimeType();
                } else {
                    if (part1Annotation == null) continue;
                    value = part1Annotation.value();
                }
                TypeMirror type = variableElement.asType();
                boolean isFile = typeUtils.isSubtype(type, fileType);
                boolean isTypedFile = typeUtils.isSubtype(type, typedFileType);
                boolean isTypedString = typeUtils.isSubtype(type, typedStringType);
                boolean isTypedByteArray = typeUtils.isSubtype(type, typedByteArrayType);
                String key = value.equals("") ? variableElement.getSimpleName().toString() : value;
                map.put(key, new Part(variableElement.getSimpleName().toString(), mimeType, isFile, isTypedFile, isTypedString, isTypedByteArray));
            }
            return map;
        }

        public String buildPath(ExecutableElement method) {
            String fullPath = this.buildRawPath(method);
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                Retrofit.Path path = variableElement.getAnnotation(Retrofit.Path.class);
                Path path1 = variableElement.getAnnotation(Path.class);
                if (path != null && !path.value().equals("")) {
                    fullPath = fullPath.replace("{" + path.value() + "}", "\" + " + variableElement.getSimpleName().toString() + " + \"");
                    continue;
                }
                if (path1 != null && !path1.value().equals("")) {
                    fullPath = fullPath.replace("{" + path1.value() + "}", "\" + " + variableElement.getSimpleName().toString() + " + \"");
                    continue;
                }
                fullPath = fullPath.replace("{" + variableElement.getSimpleName().toString() + "}", "\" + " + variableElement.getSimpleName().toString() + " + \"");
            }
            return fullPath.replaceAll("\\?.+", "");
        }

        public String buildRawPath(ExecutableElement method) {
            String rawPath = null;
            Retrofit.GET get = method.getAnnotation(Retrofit.GET.class);
            Retrofit.PUT put = method.getAnnotation(Retrofit.PUT.class);
            Retrofit.POST post = method.getAnnotation(Retrofit.POST.class);
            Retrofit.DELETE delete = method.getAnnotation(Retrofit.DELETE.class);
            Retrofit.HEAD head = method.getAnnotation(Retrofit.HEAD.class);
            if (get != null) {
                rawPath = get.value();
            }
            if (put != null) {
                rawPath = put.value();
            }
            if (post != null) {
                rawPath = post.value();
            }
            if (delete != null) {
                rawPath = delete.value();
            }
            if (head != null) {
                rawPath = head.value();
            }
            GET get1 = method.getAnnotation(GET.class);
            PUT put1 = method.getAnnotation(PUT.class);
            POST post1 = method.getAnnotation(POST.class);
            DELETE delete1 = method.getAnnotation(DELETE.class);
            HEAD head1 = method.getAnnotation(HEAD.class);
            if (get1 != null) {
                rawPath = get1.value();
            }
            if (put1 != null) {
                rawPath = put1.value();
            }
            if (post1 != null) {
                rawPath = post1.value();
            }
            if (delete1 != null) {
                rawPath = delete1.value();
            }
            if (head1 != null) {
                rawPath = head1.value();
            }
            return rawPath;
        }

        public Map<String, String> buildQueries(ExecutableElement method) {
            HashMap<String, String> map = new HashMap<String, String>();
            String fullPath = this.buildRawPath(method);
            if (fullPath.indexOf("?") != -1) {
                String[] queries;
                fullPath = fullPath.replaceAll("^.*\\?", "");
                for (String string : queries = fullPath.split("&")) {
                    String[] keyValue = string.split("=");
                    map.put(keyValue[0], "\"" + keyValue[1] + "\"");
                }
            }
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                String value = "";
                Retrofit.Query query = variableElement.getAnnotation(Retrofit.Query.class);
                Query query1 = variableElement.getAnnotation(Query.class);
                if (query != null) {
                    value = query.value();
                } else {
                    if (query1 == null) continue;
                    value = query1.value();
                }
                String key = value.equals("") ? variableElement.getSimpleName().toString() : value;
                map.put(key, variableElement.getSimpleName().toString());
            }
            return map;
        }

        public List<String> buildQueryMaps(ExecutableElement method) {
            ArrayList<String> queryMaps = new ArrayList<String>();
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                Retrofit.QueryMap queryMap = variableElement.getAnnotation(Retrofit.QueryMap.class);
                QueryMap queryMap1 = variableElement.getAnnotation(QueryMap.class);
                if (queryMap == null && queryMap1 == null) continue;
                queryMaps.add(variableElement.getSimpleName().toString());
            }
            return queryMaps;
        }

        public List<String> buildQueryBundles(ExecutableElement method) {
            ArrayList<String> queryBundles = new ArrayList<String>();
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                Retrofit.QueryBundle queryBundle = variableElement.getAnnotation(Retrofit.QueryBundle.class);
                if (queryBundle == null) continue;
                queryBundles.add(variableElement.getSimpleName().toString());
            }
            return queryBundles;
        }

        private ImmutableList<String> buildAnnotations(TypeSimplifier typeSimplifier) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (AnnotationMirror annotationMirror : this.method.getAnnotationMirrors()) {
                TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (annotationElement.getQualifiedName().toString().equals(Override.class.getName())) continue;
                AnnotationOutput annotationOutput = new AnnotationOutput(typeSimplifier);
                builder.add((Object)annotationOutput.sourceFormForAnnotation(annotationMirror));
            }
            return builder.build();
        }

        public String toString() {
            return this.identifier;
        }

        public String getName() {
            return this.name;
        }

        public String getGetter() {
            return this.method.getSimpleName().toString();
        }

        TypeElement getOwner() {
            return (TypeElement)this.method.getEnclosingElement();
        }

        TypeMirror getReturnType() {
            return this.method.getReturnType();
        }

        public String getType() {
            return this.type;
        }

        public String getTypeArgs() {
            return this.typeArgs;
        }

        public String getTypeArgs2() {
            return this.typeArgs2;
        }

        public TypeKind getKind() {
            return this.method.getReturnType().getKind();
        }

        public String getCastType() {
            return this.primitive() ? this.box(this.method.getReturnType().getKind()) : this.getType();
        }

        private String box(TypeKind kind) {
            switch (kind) {
                case BOOLEAN: {
                    return "Boolean";
                }
                case BYTE: {
                    return "Byte";
                }
                case SHORT: {
                    return "Short";
                }
                case INT: {
                    return "Integer";
                }
                case LONG: {
                    return "Long";
                }
                case CHAR: {
                    return "Character";
                }
                case FLOAT: {
                    return "Float";
                }
                case DOUBLE: {
                    return "Double";
                }
            }
            throw new RuntimeException("Unknown primitive of kind " + (Object)((Object)kind));
        }

        public boolean primitive() {
            return this.method.getReturnType().getKind().isPrimitive();
        }

        public boolean isCallback() {
            return this.callbackType != null && !"".equals(this.callbackType);
        }

        public String getCallbackType() {
            return this.callbackType;
        }

        public String getCallbackArg() {
            return this.callbackArg;
        }

        public String getCallbackName() {
            return this.callbackName;
        }

        public boolean isObservable() {
            return this.isObservable;
        }

        public boolean isVoid() {
            return this.isVoid;
        }

        public boolean isBlocking() {
            return this.isBlocking;
        }

        public boolean isResponseType() {
            return this.isResponseType;
        }

        public String getBody() {
            return this.body;
        }

        public String getConverter() {
            return this.converter;
        }

        public String getGsonConverter() {
            return this.gsonConverter;
        }

        public String getErrorHandler() {
            return this.errorHandler;
        }

        public String getRequestInterceptor() {
            return this.requestInterceptor;
        }

        public String getLogLevel() {
            return this.logLevel;
        }

        public List<String> getPermissions() {
            return this.permissions;
        }

        public boolean isGet() {
            return this.isGet;
        }

        public boolean isPut() {
            return this.isPut;
        }

        public boolean isPost() {
            return this.isPost;
        }

        public boolean isDelete() {
            return this.isDelete;
        }

        public boolean isHead() {
            return this.isHead;
        }

        public boolean isAuthenticated() {
            return this.isAuthenticated;
        }

        public boolean isSingletonRequestInterceptor() {
            return this.isSingletonRequestInterceptor;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public String getArgs() {
            return this.args;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, String> getQueries() {
            return this.queries;
        }

        public List<String> getQueryMaps() {
            return this.queryMaps;
        }

        public List<String> getQueryBundles() {
            return this.queryBundles;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Map<String, String> getFields() {
            return this.fields;
        }

        public Map<String, Part> getParts() {
            return this.parts;
        }

        public boolean isNullable() {
            for (AnnotationMirror annotationMirror : this.method.getAnnotationMirrors()) {
                String name = annotationMirror.getAnnotationType().asElement().getSimpleName().toString();
                if (!name.equals("Nullable")) continue;
                return true;
            }
            return false;
        }

        public String getAccess() {
            Set<Modifier> mods = this.method.getModifiers();
            if (mods.contains((Object)Modifier.PUBLIC)) {
                return "public ";
            }
            if (mods.contains((Object)Modifier.PROTECTED)) {
                return "protected ";
            }
            return "";
        }
    }

    public static class Part {
        private final String name;
        private final String mimeType;
        private final boolean isFile;
        private final boolean isTypedFile;
        private final boolean isTypedString;
        private final boolean isTypedByteArray;

        public Part(String name, String mimeType, boolean isFile, boolean isTypedFile, boolean isTypedString, boolean isTypedByteArray) {
            this.name = name;
            this.mimeType = mimeType;
            this.isFile = isFile;
            this.isTypedFile = isTypedFile;
            this.isTypedString = isTypedString;
            this.isTypedByteArray = isTypedByteArray;
        }

        public String getName() {
            return this.name;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public boolean isFile() {
            return this.isFile;
        }

        public boolean isTypedFile() {
            return this.isTypedFile;
        }

        public boolean isTypedString() {
            return this.isTypedString;
        }

        public boolean isTypedByteArray() {
            return this.isTypedByteArray;
        }
    }

    public static interface Action1<T> {
        public void call(T var1);
    }
}

