/*
 * Decompiled with CFR 0.152.
 */
package retrofit.processor;

import com.google.auto.common.MoreElements;
import com.google.auto.common.SuperficialValidation;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import retrofit.http.Retrofit;

@AutoService(value=Processor.class)
public class RetrofitBuilderProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)Retrofit.Builder.class.getCanonicalName(), (Object)Retrofit.Validate.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> builderTypes = roundEnv.getElementsAnnotatedWith(Retrofit.Builder.class);
        if (!SuperficialValidation.validateElements(builderTypes)) {
            return false;
        }
        for (Element element : builderTypes) {
            if (!MoreElements.isAnnotationPresent((Element)element, Retrofit.Builder.class)) continue;
            this.validate(element, "@Retrofit.Builder can only be applied to a class or interface inside an @Retrofit class");
        }
        Set<? extends Element> validateMethods = roundEnv.getElementsAnnotatedWith(Retrofit.Validate.class);
        if (!SuperficialValidation.validateElements(validateMethods)) {
            return false;
        }
        for (Element element : validateMethods) {
            if (!MoreElements.isAnnotationPresent((Element)element, Retrofit.Validate.class)) continue;
            this.validate(element, "@Retrofit.Validate can only be applied to a method inside an @Retrofit class");
        }
        return false;
    }

    private void validate(Element annotatedType, String errorMessage) {
        Element container = annotatedType.getEnclosingElement();
        if (!MoreElements.isAnnotationPresent((Element)container, Retrofit.class)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, errorMessage, annotatedType);
        }
    }
}

