/*
 * Decompiled with CFR 0.152.
 */
package retrofit.processor;

class Reformatter {
    Reformatter() {
    }

    static String fixup(String s) {
        s = Reformatter.removeTrailingSpace(s);
        s = Reformatter.compressBlankLines(s);
        s = Reformatter.compressSpace(s);
        return s;
    }

    private static String removeTrailingSpace(String s) {
        if (!s.endsWith("\n")) {
            s = s + '\n';
        }
        StringBuilder sb = new StringBuilder(s.length());
        int start = 0;
        while (start < s.length()) {
            int i;
            int nl = s.indexOf(10, start);
            for (i = nl - 1; i >= start && s.charAt(i) == ' '; --i) {
            }
            sb.append(s.substring(start, i + 1)).append('\n');
            start = nl + 1;
        }
        return sb.toString();
    }

    private static String compressBlankLines(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int braces = 0;
        int parens = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '(': {
                    ++parens;
                    break;
                }
                case ')': {
                    --parens;
                    break;
                }
                case '{': {
                    ++braces;
                    break;
                }
                case '}': {
                    --braces;
                    break;
                }
                case '\n': {
                    int j;
                    for (j = i + 1; j < s.length() && s.charAt(j) == '\n'; ++j) {
                    }
                    if (j <= i + 1) break;
                    if (parens == 0 && braces <= 1) {
                        sb.append("\n");
                    }
                    i = j - 1;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String compressSpace(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        Tokenizer tokenizer = new Tokenizer(s);
        int len = s.length();
        int start = 0;
        while (start < len) {
            int end = tokenizer.tokenEnd(start);
            if (s.charAt(start) == ' ') {
                char nextC;
                if (sb.charAt(sb.length() - 1) != '(' && ",;)".indexOf(nextC = s.charAt(end)) < 0) {
                    sb.append(' ');
                }
            } else {
                sb.append(s.substring(start, end));
            }
            start = end;
        }
        return sb.toString();
    }

    private static class Tokenizer {
        private final String s;

        Tokenizer(String s) {
            if (!s.endsWith("\n")) {
                s = s + "\n";
            }
            this.s = s;
        }

        int tokenEnd(int start) {
            if (start >= this.s.length()) {
                return this.s.length();
            }
            switch (this.s.charAt(start)) {
                case '\n': 
                case ' ': {
                    return this.spaceEnd(start);
                }
                case '/': {
                    if (this.s.charAt(start + 1) == '*') {
                        return this.blockCommentEnd(start);
                    }
                    if (this.s.charAt(start + 1) == '/') {
                        return this.lineCommentEnd(start);
                    }
                    return start + 1;
                }
                case '\"': 
                case '\'': {
                    return this.quoteEnd(start);
                }
            }
            return start + 1;
        }

        int spaceEnd(int start) {
            int i;
            assert (this.s.charAt(start) == ' ' || this.s.charAt(start) == '\n');
            for (i = start + 1; i < this.s.length() && this.s.charAt(i) == ' '; ++i) {
            }
            return i;
        }

        int blockCommentEnd(int start) {
            assert (this.s.charAt(start) == '/' && this.s.charAt(start + 1) == '*');
            int i = start + 1;
            while (this.s.charAt(i) != '*' || this.s.charAt(i + 1) != '/') {
                ++i;
            }
            return i;
        }

        int lineCommentEnd(int start) {
            assert (this.s.charAt(start) == '/' && this.s.charAt(start + 1) == '/');
            int end = this.s.indexOf(10, start + 2);
            assert (end > 0);
            return end;
        }

        int quoteEnd(int start) {
            char quote = this.s.charAt(start);
            assert (quote == '\'' || quote == '\"');
            int i = start + 1;
            while (this.s.charAt(i) != quote) {
                if (this.s.charAt(i) == '\\') {
                    ++i;
                }
                ++i;
            }
            return i + 1;
        }
    }
}

