/*
 * Decompiled with CFR 0.152.
 */
package retrofit.processor;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

class GwtCompatibility {
    private final Optional<AnnotationMirror> gwtCompatibleAnnotation;

    GwtCompatibility(TypeElement type) {
        Optional gwtCompatibleAnnotation = Optional.absent();
        List<? extends AnnotationMirror> annotations = type.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            Name name = annotationMirror.getAnnotationType().asElement().getSimpleName();
            if (!name.contentEquals("GwtCompatible")) continue;
            gwtCompatibleAnnotation = Optional.of((Object)annotationMirror);
        }
        this.gwtCompatibleAnnotation = gwtCompatibleAnnotation;
    }

    Optional<AnnotationMirror> gwtCompatibleAnnotation() {
        return this.gwtCompatibleAnnotation;
    }

    String gwtCompatibleAnnotationString() {
        if (this.gwtCompatibleAnnotation.isPresent()) {
            String annotationArguments;
            AnnotationMirror annotation = (AnnotationMirror)this.gwtCompatibleAnnotation.get();
            TypeElement annotationElement = (TypeElement)annotation.getAnnotationType().asElement();
            if (annotation.getElementValues().isEmpty()) {
                annotationArguments = "";
            } else {
                ArrayList elements = Lists.newArrayList();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : Collections.unmodifiableMap(annotation.getElementValues()).entrySet()) {
                    elements.add(entry.getKey().getSimpleName() + " = " + entry.getValue());
                }
                annotationArguments = "(" + Joiner.on((String)", ").join((Iterable)elements) + ")";
            }
            return "@" + annotationElement.getQualifiedName() + annotationArguments;
        }
        return "";
    }
}

