/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import bolts.Task;
import com.parse.ParseAuthenticationProvider;
import com.parse.ParseException;
import com.parse.internal.AsyncCallback;
import com.parse.twitter.Twitter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

class TwitterAuthenticationProvider
extends ParseAuthenticationProvider {
    public static final String AUTH_TYPE = "twitter";
    private static final String SCREEN_NAME_KEY = "screen_name";
    private static final String ID_KEY = "id";
    private static final String AUTH_TOKEN_SECRET_KEY = "auth_token_secret";
    private static final String AUTH_TOKEN_KEY = "auth_token";
    private static final String CONSUMER_KEY_KEY = "consumer_key";
    private static final String CONSUMER_SECRET_KEY = "consumer_secret";
    private WeakReference<Context> baseContext;
    private final Twitter twitter;
    private ParseAuthenticationProvider.ParseAuthenticationCallback currentOperationCallback;

    public TwitterAuthenticationProvider(Twitter twitter) {
        this.twitter = twitter;
    }

    private void authenticate(final ParseAuthenticationProvider.ParseAuthenticationCallback callback) {
        Context context;
        if (this.currentOperationCallback != null) {
            this.cancel();
        }
        this.currentOperationCallback = callback;
        Context context2 = context = this.baseContext == null ? null : (Context)this.baseContext.get();
        if (context == null) {
            throw new IllegalStateException("Context must be non-null for Twitter authentication to proceed.");
        }
        this.twitter.authorize(context, new AsyncCallback(){

            @Override
            public void onCancel() {
                TwitterAuthenticationProvider.this.handleCancel(callback);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Throwable error) {
                if (TwitterAuthenticationProvider.this.currentOperationCallback != callback) {
                    return;
                }
                try {
                    callback.onError(error);
                }
                finally {
                    TwitterAuthenticationProvider.this.currentOperationCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(Object result) {
                if (TwitterAuthenticationProvider.this.currentOperationCallback != callback) {
                    return;
                }
                try {
                    Map<String, String> authData = TwitterAuthenticationProvider.this.getAuthData(TwitterAuthenticationProvider.this.twitter.getUserId(), TwitterAuthenticationProvider.this.twitter.getScreenName(), TwitterAuthenticationProvider.this.twitter.getAuthToken(), TwitterAuthenticationProvider.this.twitter.getAuthTokenSecret());
                    callback.onSuccess(authData);
                }
                finally {
                    TwitterAuthenticationProvider.this.currentOperationCallback = null;
                }
            }
        });
    }

    @Override
    public Task<Map<String, String>> authenticateAsync() {
        final Task.TaskCompletionSource tcs = Task.create();
        this.authenticate(new ParseAuthenticationProvider.ParseAuthenticationCallback(){

            @Override
            public void onSuccess(Map<String, String> authData) {
                tcs.setResult(authData);
            }

            @Override
            public void onCancel() {
                tcs.setCancelled();
            }

            @Override
            public void onError(Throwable error) {
                tcs.setError((Exception)new ParseException(error));
            }
        });
        return tcs.getTask();
    }

    public Map<String, String> getAuthData(String userId, String screenName, String authToken, String authTokenSecret) {
        HashMap<String, String> authData = new HashMap<String, String>();
        authData.put(AUTH_TOKEN_KEY, authToken);
        authData.put(AUTH_TOKEN_SECRET_KEY, authTokenSecret);
        authData.put(ID_KEY, userId);
        authData.put(SCREEN_NAME_KEY, screenName);
        authData.put(CONSUMER_KEY_KEY, this.twitter.getConsumerKey());
        authData.put(CONSUMER_SECRET_KEY, this.twitter.getConsumerSecret());
        return authData;
    }

    @Override
    public void cancel() {
        this.handleCancel(this.currentOperationCallback);
    }

    @Override
    public void deauthenticate() {
        this.twitter.setAuthToken(null);
        this.twitter.setAuthTokenSecret(null);
        this.twitter.setScreenName(null);
        this.twitter.setUserId(null);
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Twitter getTwitter() {
        return this.twitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCancel(ParseAuthenticationProvider.ParseAuthenticationCallback callback) {
        if (this.currentOperationCallback != callback || callback == null) {
            return;
        }
        try {
            callback.onCancel();
        }
        finally {
            this.currentOperationCallback = null;
        }
    }

    @Override
    public boolean restoreAuthentication(Map<String, String> authData) {
        if (authData == null) {
            this.twitter.setAuthToken(null);
            this.twitter.setAuthTokenSecret(null);
            this.twitter.setScreenName(null);
            this.twitter.setUserId(null);
            return true;
        }
        try {
            this.twitter.setAuthToken(authData.get(AUTH_TOKEN_KEY));
            this.twitter.setAuthTokenSecret(authData.get(AUTH_TOKEN_SECRET_KEY));
            this.twitter.setUserId(authData.get(ID_KEY));
            this.twitter.setScreenName(authData.get(SCREEN_NAME_KEY));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public TwitterAuthenticationProvider setContext(Context context) {
        this.baseContext = new WeakReference<Context>(context);
        return this;
    }
}

