/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import com.parse.AnonymousAuthenticationProvider;
import com.parse.LogInCallback;
import com.parse.LogOutCallback;
import com.parse.Parse;
import com.parse.ParseAnonymousUtils;
import com.parse.ParseAuthenticationProvider;
import com.parse.ParseClassName;
import com.parse.ParseDecoder;
import com.parse.ParseEncoder;
import com.parse.ParseException;
import com.parse.ParseFileUtils;
import com.parse.ParseObject;
import com.parse.ParseOperationSet;
import com.parse.ParseQuery;
import com.parse.ParseRESTUserCommand;
import com.parse.ParseSession;
import com.parse.ParseTaskUtils;
import com.parse.ParseTextUtils;
import com.parse.PointerEncoder;
import com.parse.RequestPasswordResetCallback;
import com.parse.SignUpCallback;
import com.parse.TaskQueue;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

@ParseClassName(value="_User")
public class ParseUser
extends ParseObject {
    static final String FILENAME_CURRENT_USER = "currentUser";
    static final String PIN_CURRENT_USER = "_currentUser";
    private static final String KEY_SESSION_TOKEN = "sessionToken";
    private static final String KEY_AUTH_DATA = "authData";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_EMAIL = "email";
    private static final List<String> READ_ONLY_KEYS = Collections.unmodifiableList(Arrays.asList("sessionToken", "authData"));
    private static final Object MUTEX_CURRENT_USER = new Object();
    static ParseUser currentUser;
    private static final TaskQueue QUEUE_CURRENT_USER;
    private static Map<String, ParseAuthenticationProvider> authenticationProviders;
    private static boolean currentUserMatchesDisk;
    private boolean isNew;
    private boolean isLazy = false;
    private boolean isCurrentUser = false;
    private static final Object isAutoUserEnabledMutex;
    private static boolean autoUserEnabled;
    private static final Object isRevocableSessionEnabledMutex;
    private static boolean isRevocableSessionEnabled;

    public static ParseQuery<ParseUser> getQuery() {
        return ParseQuery.getQuery(ParseUser.class);
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    @Override
    boolean isKeyMutable(String key) {
        return !READ_ONLY_KEYS.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParseUser logInLazyUser(String authType, Map<String, String> authData) {
        ParseUser user = ParseObject.create(ParseUser.class);
        Object object = user.mutex;
        synchronized (object) {
            user.isCurrentUser = true;
            user.isLazy = true;
            user.putAuthData(authType, authData);
        }
        object = MUTEX_CURRENT_USER;
        synchronized (object) {
            currentUserMatchesDisk = false;
            currentUser = user;
        }
        return user;
    }

    State.Builder newStateBuilder(String className) {
        return new State.Builder(className);
    }

    @Override
    State getState() {
        return (State)super.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLazy() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isLazy;
        }
    }

    @Override
    boolean isContainerObject(String key, Object object) {
        if (KEY_AUTH_DATA.equals(key)) {
            return false;
        }
        return super.isContainerObject(key, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticated() {
        Object object = this.mutex;
        synchronized (object) {
            ParseUser current = ParseUser.getCurrentUser();
            return this.isLazy() || this.getState().sessionToken() != null && current != null && this.getObjectId().equals(current.getObjectId());
        }
    }

    @Override
    public void remove(String key) {
        if (KEY_USERNAME.equals(key)) {
            throw new IllegalArgumentException("Can't remove the username key.");
        }
        super.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends ParseObject.State> JSONObject toJSONObjectForDataFile(T state, ParseEncoder objectEncoder) {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> authData;
            JSONObject objectJSON = super.toJSONObjectForDataFile(state, objectEncoder);
            String sessionToken = ((State)state).sessionToken();
            if (sessionToken != null) {
                try {
                    objectJSON.put("session_token", (Object)sessionToken);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not encode value for key: session_token");
                }
            }
            if ((authData = ((State)state).authData()).size() > 0) {
                try {
                    objectJSON.put("auth_data", objectEncoder.encode(authData));
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not attach key: auth_data");
                }
            }
            return objectJSON;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ParseObject.State mergeFromDiskJSON(ParseObject.State state, JSONObject json) {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject newAuthData;
            State.Builder builder = (State.Builder)state.newBuilder();
            String newSessionToken = json.optString("session_token", null);
            if (newSessionToken != null) {
                builder.sessionToken(newSessionToken);
                json.remove("session_token");
            }
            if ((newAuthData = json.optJSONObject("auth_data")) != null) {
                try {
                    Iterator i = newAuthData.keys();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        if (!newAuthData.isNull(key)) {
                            builder.putAuthData(key, (Map)ParseDecoder.get().decode(newAuthData.getJSONObject(key)));
                        }
                        this.synchronizeAuthData(key);
                    }
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                json.remove("auth_data");
            }
            return super.mergeFromDiskJSON(builder.build(), json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mergeFromObject(ParseObject other) {
        Object object = this.mutex;
        synchronized (object) {
            if (this == other) {
                return;
            }
            if (other instanceof ParseUser) {
                ParseUser otherUser = (ParseUser)other;
                this.isNew = otherUser.isNew();
            }
            super.mergeFromObject(other);
        }
    }

    @Override
    JSONObject toRest(ParseObject.State state, List<ParseOperationSet> operationSetQueue, ParseEncoder objectEncoder) {
        List<ParseOperationSet> cleanOperationSetQueue = operationSetQueue;
        for (int i = 0; i < operationSetQueue.size(); ++i) {
            ParseOperationSet operations = operationSetQueue.get(i);
            if (!operations.containsKey(KEY_PASSWORD)) continue;
            if (cleanOperationSetQueue == operationSetQueue) {
                cleanOperationSetQueue = new LinkedList<ParseOperationSet>(operationSetQueue);
            }
            ParseOperationSet cleanOperations = new ParseOperationSet(operations);
            cleanOperations.remove(KEY_PASSWORD);
            cleanOperationSetQueue.set(i, cleanOperations);
        }
        return super.toRest(state, cleanOperationSetQueue, objectEncoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpAuthData() {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> authData = this.getState().authData();
            if (authData.size() == 0) {
                return;
            }
            Iterator<Map.Entry<String, Map<String, String>>> i = authData.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Map<String, String>> entry = i.next();
                if (entry.getValue() != null) continue;
                i.remove();
                if (!authenticationProviders.containsKey(entry.getKey())) continue;
                authenticationProviders.get(entry.getKey()).restoreAuthentication(null);
            }
            State newState = this.getState().newBuilder().authData(authData).build();
            this.setState(newState);
        }
    }

    @Override
    Task<Void> handleSaveResultAsync(ParseObject.State result, ParseOperationSet operationsBeforeSave) {
        boolean success;
        boolean bl = success = result != null;
        if (success) {
            operationsBeforeSave.remove(KEY_PASSWORD);
        }
        return super.handleSaveResultAsync(result, operationsBeforeSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentUser() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isCurrentUser;
        }
    }

    public String getSessionToken() {
        return this.getState().sessionToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> setSessionTokenInBackground(String newSessionToken) {
        Object object = this.mutex;
        synchronized (object) {
            State.Builder builder = this.getState().newBuilder().sessionToken(newSessionToken);
            this.setState(builder.build());
            return ParseUser.saveCurrentUserAsync(this).makeVoid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> getAuthData() {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> authData = this.getMap(KEY_AUTH_DATA);
            if (authData == null) {
                authData = new HashMap();
            }
            return authData;
        }
    }

    private Map<String, String> getAuthData(String authType) {
        return this.getAuthData().get(authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAuthData(String authType, Map<String, String> authData) {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> newAuthData = this.getAuthData();
            newAuthData.put(authType, authData);
            this.performPut(KEY_AUTH_DATA, newAuthData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAuthData(String authType) {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> newAuthData = this.getAuthData();
            newAuthData.remove(authType);
            this.performPut(KEY_AUTH_DATA, newAuthData);
        }
    }

    public void setUsername(String username) {
        this.put(KEY_USERNAME, username);
    }

    public String getUsername() {
        return this.getString(KEY_USERNAME);
    }

    public void setPassword(String password) {
        this.put(KEY_PASSWORD, password);
    }

    String getPassword() {
        return this.getString(KEY_PASSWORD);
    }

    public void setEmail(String email) {
        this.put(KEY_EMAIL, email);
    }

    public String getEmail() {
        return this.getString(KEY_EMAIL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNew() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isNew;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object value) {
        Object object = this.mutex;
        synchronized (object) {
            if (KEY_USERNAME.equals(key)) {
                this.stripAnonymity();
            }
            super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripAnonymity() {
        Object object = this.mutex;
        synchronized (object) {
            if (ParseAnonymousUtils.isLinked(this)) {
                if (this.getObjectId() != null) {
                    this.putAuthData("anonymous", null);
                } else {
                    this.removeAuthData("anonymous");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreAnonymity(Map<String, String> anonymousData) {
        Object object = this.mutex;
        synchronized (object) {
            if (anonymousData != null) {
                this.putAuthData("anonymous", anonymousData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateSave() {
        ParseUser current;
        Object object = this.mutex;
        synchronized (object) {
            if (this.getObjectId() == null) {
                throw new IllegalArgumentException("Cannot save a ParseUser until it has been signed up. Call signUp first.");
            }
            if (this.isAuthenticated() || !this.isDirty() || this.isCurrentUser()) {
                return;
            }
        }
        if (!Parse.isLocalDatastoreEnabled() && (current = ParseUser.getCurrentUser()) != null && this.getObjectId().equals(current.getObjectId())) {
            return;
        }
        throw new IllegalArgumentException("Cannot save a ParseUser that is not authenticated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Task<Void> saveAsync(String sessionToken, Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            Task<Void> task = this.isLazy() ? this.resolveLazinessAsync(toAwait).makeVoid() : super.saveAsync(sessionToken, toAwait);
            return task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    if (ParseUser.this.isCurrentUser()) {
                        ParseUser.this.cleanUpAuthData();
                        return ParseUser.saveCurrentUserAsync(ParseUser.this).makeVoid();
                    }
                    return Task.forResult(null);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateDelete() {
        Object object = this.mutex;
        synchronized (object) {
            super.validateDelete();
            if (!this.isAuthenticated() && this.isDirty()) {
                throw new IllegalArgumentException("Cannot delete a ParseUser that is not authenticated.");
            }
        }
    }

    public ParseUser fetch() throws ParseException {
        return (ParseUser)super.fetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends ParseObject> Task<T> fetchAsync(String sessionToken, Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isLazy()) {
                return Task.forResult((Object)this);
            }
            return super.fetchAsync(sessionToken, toAwait).onSuccessTask(new Continuation<T, Task<T>>(){

                public Task<T> then(final Task<T> fetchAsyncTask) throws Exception {
                    if (ParseUser.this.isCurrentUser()) {
                        ParseUser.this.cleanUpAuthData();
                        return ParseUser.saveCurrentUserAsync(ParseUser.this).continueWithTask(new Continuation<ParseUser, Task<T>>(){

                            public Task<T> then(Task<ParseUser> task) throws Exception {
                                return fetchAsyncTask;
                            }
                        });
                    }
                    return fetchAsyncTask;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseRESTUserCommand currentServiceLogInCommand(State state, ParseOperationSet operations) throws ParseException {
        JSONObject params;
        Object object = this.mutex;
        synchronized (object) {
            params = this.toJSONObjectForSaving(this.getState(), operations, PointerEncoder.get());
        }
        return ParseRESTUserCommand.serviceLogInUserCommand(params, state.sessionToken(), ParseUser.isRevocableSessionEnabled());
    }

    public Task<Void> signUpInBackground() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseUser.this.signUpAsync((Task<Void>)task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> signUpAsync(Task<Void> toAwait) {
        final ParseUser user = ParseUser.getCurrentUser();
        Object object = this.mutex;
        synchronized (object) {
            String sessionToken;
            String string = sessionToken = user != null ? user.getSessionToken() : null;
            if (ParseTextUtils.isEmpty(this.getUsername())) {
                return Task.forError((Exception)new IllegalArgumentException("Username cannot be missing or blank"));
            }
            if (ParseTextUtils.isEmpty(this.getPassword())) {
                return Task.forError((Exception)new IllegalArgumentException("Password cannot be missing or blank"));
            }
            if (this.getObjectId() != null) {
                Map<String, Map<String, String>> authData = this.getAuthData();
                if (authData.containsKey("anonymous") && authData.get("anonymous") == null) {
                    return this.saveAsync(sessionToken, toAwait);
                }
                return Task.forError((Exception)new IllegalArgumentException("Cannot sign up a user that has already signed up."));
            }
            if (this.operationSetQueue.size() > 1) {
                return Task.forError((Exception)new IllegalArgumentException("Cannot sign up a user that is already signing up."));
            }
            if (user != null && ParseAnonymousUtils.isLinked(user)) {
                if (this == user) {
                    return Task.forError((Exception)new IllegalArgumentException("Attempt to merge currentUser with itself."));
                }
                this.checkForChangesToMutableContainers();
                user.checkForChangesToMutableContainers();
                final String oldUsername = user.getUsername();
                final String oldPassword = user.getPassword();
                final Map<String, String> anonymousData = user.getAuthData("anonymous");
                user.copyChangesFrom(this);
                user.setUsername(this.getUsername());
                user.setPassword(this.getPassword());
                this.revert();
                return user.saveAsync(sessionToken, toAwait).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (task.isCancelled() || task.isFaulted()) {
                            Object object = user.mutex;
                            synchronized (object) {
                                if (oldUsername != null) {
                                    user.setUsername(oldUsername);
                                }
                                if (oldPassword != null) {
                                    user.setPassword(oldPassword);
                                }
                                user.restoreAnonymity(anonymousData);
                            }
                            return task;
                        }
                        ParseUser.this.revert(ParseUser.KEY_PASSWORD);
                        ParseUser.this.mergeFromObject(user);
                        return ParseUser.saveCurrentUserAsync(ParseUser.this).makeVoid();
                    }
                });
            }
            return Task.call((Callable)new Callable<ParseOperationSet>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ParseOperationSet call() throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        return ParseUser.this.startSave();
                    }
                }
            }).continueWithTask(TaskQueue.waitFor(toAwait)).onSuccessTask((Continuation)new Continuation<ParseOperationSet, Task<Void>>(){

                public Task<Void> then(Task<ParseOperationSet> task) throws Exception {
                    final ParseOperationSet operations = (ParseOperationSet)task.getResult();
                    JSONObject objectJSON = ParseUser.this.toJSONObjectForSaving(ParseUser.this.getState(), operations, PointerEncoder.get());
                    ParseRESTUserCommand command = ParseRESTUserCommand.signUpUserCommand(objectJSON, sessionToken, ParseUser.isRevocableSessionEnabled());
                    return command.executeAsync().continueWithTask((Continuation)new Continuation<JSONObject, Task<Void>>(){

                        public Task<Void> then(final Task<JSONObject> signUpTask) throws Exception {
                            return ParseUser.this.handleSaveResultAsync((JSONObject)signUpTask.getResult(), operations).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Task<Void> then(Task<Void> task) throws Exception {
                                    if (!signUpTask.isCancelled() && !signUpTask.isFaulted()) {
                                        Object object = ParseUser.this.mutex;
                                        synchronized (object) {
                                            ParseUser.this.isNew = true;
                                            ParseUser.this.isLazy = false;
                                        }
                                        return ParseUser.saveCurrentUserAsync(ParseUser.this).makeVoid();
                                    }
                                    return signUpTask.makeVoid();
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    public void signUp() throws ParseException {
        ParseTaskUtils.wait(this.signUpInBackground());
    }

    public void signUpInBackground(SignUpCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.signUpInBackground(), callback);
    }

    public static Task<ParseUser> logInInBackground(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException("Must specify a username for the user to log in with");
        }
        if (password == null) {
            throw new IllegalArgumentException("Must specify a password for the user to log in with");
        }
        ParseRESTUserCommand command = ParseRESTUserCommand.logInUserCommand(username, password, ParseUser.isRevocableSessionEnabled());
        return command.executeAsync().onSuccessTask((Continuation)new Continuation<JSONObject, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<JSONObject> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                if (json == JSONObject.NULL) {
                    throw new ParseException(101, "invalid login credentials");
                }
                ParseUser user = (ParseUser)ParseObject.fromJSON(json, "_User", true);
                return ParseUser.saveCurrentUserAsync(user);
            }
        });
    }

    public static ParseUser logIn(String username, String password) throws ParseException {
        return ParseTaskUtils.wait(ParseUser.logInInBackground(username, password));
    }

    public static void logInInBackground(String username, String password, LogInCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseUser.logInInBackground(username, password), callback);
    }

    public static Task<ParseUser> becomeInBackground(String sessionToken) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("Must specify a sessionToken for the user to log in with");
        }
        ParseRESTUserCommand command = ParseRESTUserCommand.getCurrentUserCommand(sessionToken);
        return command.executeAsync().onSuccessTask((Continuation)new Continuation<JSONObject, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<JSONObject> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                if (json == JSONObject.NULL) {
                    return Task.forError((Exception)new ParseException(101, "invalid login credentials"));
                }
                ParseUser user = (ParseUser)ParseObject.fromJSON(json, "_User", true);
                return ParseUser.saveCurrentUserAsync(user);
            }
        });
    }

    public static ParseUser become(String sessionToken) throws ParseException {
        return ParseTaskUtils.wait(ParseUser.becomeInBackground(sessionToken));
    }

    public static void becomeInBackground(String sessionToken, LogInCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseUser.becomeInBackground(sessionToken), callback);
    }

    static Task<ParseUser> getCurrentUserAsync() {
        return ParseUser.getCurrentUserAsync(ParseUser.isAutomaticUserEnabled());
    }

    public static ParseUser getCurrentUser() {
        return ParseUser.getCurrentUser(ParseUser.isAutomaticUserEnabled());
    }

    private static ParseUser getCurrentUser(boolean shouldAutoCreateUser) {
        try {
            return ParseTaskUtils.wait(ParseUser.getCurrentUserAsync(shouldAutoCreateUser));
        }
        catch (ParseException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Task<ParseUser> getCurrentUserAsync(final boolean shouldAutoCreateUser) {
        Object object = MUTEX_CURRENT_USER;
        synchronized (object) {
            if (currentUser != null) {
                return Task.forResult((Object)currentUser);
            }
        }
        return QUEUE_CURRENT_USER.enqueue(new Continuation<Void, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<Void> toAwait) throws Exception {
                return ParseUser.getCurrentUserAsync(shouldAutoCreateUser, (Task<Void>)toAwait);
            }
        });
    }

    private static Task<ParseUser> getCurrentUserAsync(final boolean shouldAutoCreateUser, Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<ParseUser>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<ParseUser> then(Task<Void> ignored) throws Exception {
                Task task;
                boolean matchesDisk;
                ParseUser current;
                Object object = MUTEX_CURRENT_USER;
                synchronized (object) {
                    current = currentUser;
                    matchesDisk = currentUserMatchesDisk;
                }
                if (current != null) {
                    return Task.forResult((Object)current);
                }
                if (matchesDisk) {
                    if (shouldAutoCreateUser) {
                        return Task.forResult((Object)ParseAnonymousUtils.lazyLogIn());
                    }
                    return null;
                }
                if (Parse.isLocalDatastoreEnabled()) {
                    ParseQuery<ParseUser> query = ParseQuery.getQuery(ParseUser.class).fromPin(ParseUser.PIN_CURRENT_USER).ignoreACLs();
                    task = query.findInBackground().onSuccessTask((Continuation)new Continuation<List<ParseUser>, Task<ParseUser>>(){

                        public Task<ParseUser> then(Task<List<ParseUser>> task) throws Exception {
                            List results = (List)task.getResult();
                            if (results != null) {
                                if (results.size() == 1) {
                                    return Task.forResult(results.get(0));
                                }
                                return ParseObject.unpinAllInBackground(ParseUser.PIN_CURRENT_USER).cast();
                            }
                            return Task.forResult(null);
                        }
                    }).onSuccessTask((Continuation)new Continuation<ParseUser, Task<ParseUser>>(){

                        public Task<ParseUser> then(Task<ParseUser> task) throws Exception {
                            ParseUser ldsUser = (ParseUser)task.getResult();
                            if (ldsUser != null) {
                                return task;
                            }
                            return ParseObject.migrateFromDiskToLDS(ParseUser.FILENAME_CURRENT_USER, ParseUser.PIN_CURRENT_USER).cast();
                        }
                    });
                } else {
                    task = Task.forResult((Object)((ParseUser)ParseObject.getFromDisk(ParseUser.FILENAME_CURRENT_USER)));
                }
                return task.continueWith((Continuation)new Continuation<ParseUser, ParseUser>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public ParseUser then(Task<ParseUser> task) throws Exception {
                        ParseUser current = (ParseUser)task.getResult();
                        boolean matchesDisk = !task.isFaulted();
                        Object object = MUTEX_CURRENT_USER;
                        synchronized (object) {
                            currentUser = current;
                            currentUserMatchesDisk = matchesDisk;
                        }
                        if (current != null) {
                            object = current.mutex;
                            synchronized (object) {
                                current.isCurrentUser = true;
                                current.isLazy = ParseAnonymousUtils.isLinked(current);
                            }
                            return current;
                        }
                        if (shouldAutoCreateUser) {
                            return ParseAnonymousUtils.lazyLogIn();
                        }
                        return null;
                    }
                });
            }
        });
    }

    static String getCurrentSessionToken() {
        ParseUser current = ParseUser.getCurrentUser();
        return current != null ? current.getSessionToken() : null;
    }

    static Task<String> getCurrentSessionTokenAsync() {
        return ParseUser.getCurrentUserAsync(false).onSuccess((Continuation)new Continuation<ParseUser, String>(){

            public String then(Task<ParseUser> task) throws Exception {
                ParseUser user = (ParseUser)task.getResult();
                return user != null ? user.getSessionToken() : null;
            }
        });
    }

    private static Task<ParseUser> saveCurrentUserAsync(final ParseUser user) {
        return QUEUE_CURRENT_USER.enqueue(new Continuation<Void, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<Void> toAwait) throws Exception {
                return ParseUser.saveCurrentUserAsync(user, (Task<Void>)toAwait);
            }
        });
    }

    private static Task<ParseUser> saveCurrentUserAsync(final ParseUser user, Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<Void> then(Task<Void> ignored) throws Exception {
                ParseUser oldCurrentUser;
                Object object = MUTEX_CURRENT_USER;
                synchronized (object) {
                    oldCurrentUser = currentUser;
                }
                if (oldCurrentUser != null && oldCurrentUser != user) {
                    oldCurrentUser.logOutInternal();
                }
                object = user.mutex;
                synchronized (object) {
                    user.isCurrentUser = true;
                    user.synchronizeAllAuthData();
                }
                Task task = Parse.isLocalDatastoreEnabled() ? ParseObject.unpinAllInBackground(ParseUser.PIN_CURRENT_USER).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return user.pinInBackground(ParseUser.PIN_CURRENT_USER, false);
                    }
                }) : Task.call((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        user.saveToDisk(ParseUser.FILENAME_CURRENT_USER);
                        return null;
                    }
                }, (Executor)Task.BACKGROUND_EXECUTOR);
                return task;
            }
        }).continueWith((Continuation)new Continuation<Void, ParseUser>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ParseUser then(Task<Void> task) throws Exception {
                Object object = MUTEX_CURRENT_USER;
                synchronized (object) {
                    currentUserMatchesDisk = !task.isFaulted();
                    currentUser = user;
                }
                return user;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Task<Void> pinCurrentUserIfNeededAsync(ParseUser user) {
        Object object = MUTEX_CURRENT_USER;
        synchronized (object) {
            if (!user.isCurrentUser() || currentUserMatchesDisk) {
                return Task.forResult(null);
            }
        }
        return ParseUser.saveCurrentUserAsync(user).makeVoid();
    }

    public static Task<Void> logOutInBackground() {
        return QUEUE_CURRENT_USER.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParseUser.logOutInBackground((Task<Void>)toAwait);
            }
        });
    }

    private static Task<Void> logOutInBackground(Task<Void> toAwait) {
        final Task<ParseUser> userTask = ParseUser.getCurrentUserAsync(false);
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                Task logOutTask = userTask.onSuccessTask((Continuation)new Continuation<ParseUser, Task<Void>>(){

                    public Task<Void> then(Task<ParseUser> task) throws Exception {
                        ParseUser user = (ParseUser)task.getResult();
                        if (user == null) {
                            return task.cast();
                        }
                        return user.logOutAsync();
                    }
                });
                Task diskTask = userTask.continueWith((Continuation)new Continuation<ParseUser, Boolean>(){

                    public Boolean then(Task<ParseUser> task) throws Exception {
                        return ParseFileUtils.deleteQuietly(new File(Parse.getParseDir(), ParseUser.FILENAME_CURRENT_USER));
                    }
                }, (Executor)Task.BACKGROUND_EXECUTOR).continueWithTask((Continuation)new Continuation<Boolean, Task<Boolean>>(){

                    public Task<Boolean> then(Task<Boolean> task) throws Exception {
                        if (Parse.isLocalDatastoreEnabled()) {
                            return ParseObject.unpinAllInBackground(ParseUser.PIN_CURRENT_USER).continueWith((Continuation)new Continuation<Void, Boolean>(){

                                public Boolean then(Task<Void> task) throws Exception {
                                    return !task.isFaulted();
                                }
                            });
                        }
                        return task;
                    }
                }).onSuccess((Continuation)new Continuation<Boolean, Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void then(Task<Boolean> task) throws Exception {
                        boolean deleted = (Boolean)task.getResult();
                        Object object = MUTEX_CURRENT_USER;
                        synchronized (object) {
                            currentUserMatchesDisk = deleted;
                            currentUser = null;
                        }
                        return null;
                    }
                });
                return Task.whenAll(Arrays.asList(logOutTask, diskTask));
            }
        });
    }

    public static void logOutInBackground(LogOutCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseUser.logOutInBackground(), callback);
    }

    public static void logOut() {
        try {
            ParseTaskUtils.wait(ParseUser.logOutInBackground());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private Task<Void> logOutAsync() {
        String oldSessionToken = this.logOutInternal();
        return this.revokeSessionTokenAsync(oldSessionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String logOutInternal() {
        String oldSessionToken;
        Object object = this.mutex;
        synchronized (object) {
            oldSessionToken = this.getState().sessionToken();
            for (Map.Entry<String, Map<String, String>> entry : this.getAuthData().entrySet()) {
                this.logOutWith(entry.getKey());
            }
            State.Builder builder = this.getState().newBuilder().sessionToken(null);
            this.isCurrentUser = false;
            this.isNew = false;
            this.setState(builder.build());
        }
        return oldSessionToken;
    }

    private Task<Void> revokeSessionTokenAsync(String sessionToken) {
        if (sessionToken == null || !ParseUser.isRevocableSessionToken(sessionToken)) {
            return Task.forResult(null);
        }
        return ParseRESTUserCommand.logOutUserCommand(sessionToken).executeAsync().makeVoid();
    }

    public static Task<Void> requestPasswordResetInBackground(String email) {
        ParseRESTUserCommand command = ParseRESTUserCommand.resetUserPasswordCommand(email);
        return command.executeAsync().makeVoid();
    }

    public static void requestPasswordReset(String email) throws ParseException {
        ParseTaskUtils.wait(ParseUser.requestPasswordResetInBackground(email));
    }

    public static void requestPasswordResetInBackground(String email, RequestPasswordResetCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseUser.requestPasswordResetInBackground(email), callback);
    }

    public ParseUser fetchIfNeeded() throws ParseException {
        return (ParseUser)super.fetchIfNeeded();
    }

    boolean isLinked(String authType) {
        Map<String, Map<String, String>> authData = this.getAuthData();
        return authData.containsKey(authType) && authData.get(authType) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeAuthData(String authType) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isCurrentUser()) {
                return;
            }
            ParseAuthenticationProvider provider = authenticationProviders.get(authType);
            if (provider == null) {
                return;
            }
            this.synchronizeAuthData(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizeAuthData(ParseAuthenticationProvider provider) {
        Object object = this.mutex;
        synchronized (object) {
            String authType = provider.getAuthType();
            boolean success = provider.restoreAuthentication(this.getAuthData(authType));
            if (!success) {
                this.unlinkFromAsync(authType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeAllAuthData() {
        Object object = this.mutex;
        synchronized (object) {
            for (Map.Entry<String, Map<String, String>> entry : this.getAuthData().entrySet()) {
                this.synchronizeAuthData(entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> unlinkFromAsync(final String authType) {
        Object object = this.mutex;
        synchronized (object) {
            if (authType == null) {
                return Task.forResult(null);
            }
            return Task.forResult(null).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Task<Void> then(Task<Void> task) throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        if (ParseUser.this.getAuthData().containsKey(authType)) {
                            ParseUser.this.putAuthData(authType, null);
                            return ParseUser.this.saveInBackground();
                        }
                        return Task.forResult(null);
                    }
                }
            });
        }
    }

    static void registerAuthenticationProvider(ParseAuthenticationProvider provider) {
        authenticationProviders.put(provider.getAuthType(), provider);
        if (provider instanceof AnonymousAuthenticationProvider) {
            return;
        }
        ParseUser user = ParseUser.getCurrentUser();
        if (user != null) {
            user.synchronizeAuthData(provider);
        }
    }

    static Task<ParseUser> logInWithAsync(final String authType, final Map<String, String> authData) {
        Continuation<Void, Task<ParseUser>> logInWithTask = new Continuation<Void, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<Void> task) throws Exception {
                final ParseRESTUserCommand command = ParseRESTUserCommand.serviceLogInUserCommand(authType, authData, ParseUser.isRevocableSessionEnabled());
                return command.executeAsync().onSuccessTask((Continuation)new Continuation<JSONObject, Task<ParseUser>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Task<ParseUser> then(Task<JSONObject> task) throws Exception {
                        JSONObject result = (JSONObject)task.getResult();
                        ParseUser user = (ParseUser)ParseObject.fromJSON(result, "_User", true);
                        Object object = user.mutex;
                        synchronized (object) {
                            State.Builder builder = user.getState().newBuilder().putAuthData(authType, authData);
                            user.isNew = command.getStatusCode() == 201;
                            user.setState(builder.build());
                        }
                        return ParseUser.saveCurrentUserAsync(user);
                    }
                });
            }
        };
        return ParseUser.getCurrentUserAsync().onSuccessTask((Continuation)new Continuation<ParseUser, Task<ParseUser>>((Continuation)logInWithTask){
            final /* synthetic */ Continuation val$logInWithTask;
            {
                this.val$logInWithTask = continuation;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<ParseUser> then(Task<ParseUser> task) throws Exception {
                final ParseUser user = (ParseUser)task.getResult();
                if (user != null) {
                    Object object = user.mutex;
                    synchronized (object) {
                        if (ParseAnonymousUtils.isLinked(user)) {
                            if (user.isLazy()) {
                                final Map oldAnonymousData = user.getAuthData("anonymous");
                                return user.taskQueue.enqueue(new Continuation<Void, Task<ParseUser>>(){

                                    public Task<ParseUser> then(Task<Void> toAwait) throws Exception {
                                        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public Task<Void> then(Task<Void> task) throws Exception {
                                                Object object = user.mutex;
                                                synchronized (object) {
                                                    user.stripAnonymity();
                                                    user.putAuthData(authType, authData);
                                                    return user.resolveLazinessAsync((Task<Void>)task).makeVoid();
                                                }
                                            }
                                        }).continueWithTask((Continuation)new Continuation<Void, Task<ParseUser>>(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public Task<ParseUser> then(Task<Void> task) throws Exception {
                                                Object object = user.mutex;
                                                synchronized (object) {
                                                    if (task.isFaulted()) {
                                                        user.removeAuthData(authType);
                                                        user.restoreAnonymity(oldAnonymousData);
                                                        return Task.forError((Exception)task.getError());
                                                    }
                                                    if (task.isCancelled()) {
                                                        return Task.cancelled();
                                                    }
                                                    return Task.forResult((Object)user);
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                            return user.linkWithAsync(authType, authData, user.getSessionToken()).continueWithTask((Continuation)new Continuation<Void, Task<ParseUser>>(){

                                public Task<ParseUser> then(Task<Void> task) throws Exception {
                                    Exception error;
                                    if (task.isFaulted() && (error = task.getError()) instanceof ParseException && ((ParseException)error).getCode() == 208) {
                                        return Task.forResult(null).continueWithTask(val$logInWithTask);
                                    }
                                    if (task.isCancelled()) {
                                        return Task.cancelled();
                                    }
                                    return Task.forResult((Object)user);
                                }
                            });
                        }
                    }
                }
                return Task.forResult(null).continueWithTask(this.val$logInWithTask);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> linkWithAsync(final String authType, Map<String, String> authData, final Task<Void> toAwait, final String sessionToken) {
        final Map<String, String> oldAnonymousData = this.getAuthData("anonymous");
        Object object = this.mutex;
        synchronized (object) {
            this.stripAnonymity();
            this.putAuthData(authType, authData);
            return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

                public Task<Void> then(Task<String> task) throws Exception {
                    return ParseUser.this.saveAsync(sessionToken, (Task<Void>)toAwait);
                }
            }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Task<Void> then(Task<Void> task) throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        if (task.isFaulted() || task.isCancelled()) {
                            ParseUser.this.restoreAnonymity(oldAnonymousData);
                            return task;
                        }
                        ParseUser.this.synchronizeAuthData(authType);
                        return task;
                    }
                }
            });
        }
    }

    Task<Void> linkWithAsync(final String authType, final Map<String, String> authData, final String sessionToken) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseUser.this.linkWithAsync(authType, authData, (Task<Void>)task, sessionToken);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOutWith(String authType) {
        Object object = this.mutex;
        synchronized (object) {
            ParseAuthenticationProvider provider = authenticationProviders.get(authType);
            if (provider != null && this.isLinked(authType)) {
                provider.deauthenticate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<ParseUser> resolveLazinessAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isLazy()) {
                return Task.forResult(null);
            }
            if (this.getAuthData().size() == 0) {
                return this.signUpAsync(toAwait).onSuccess((Continuation)new Continuation<Void, ParseUser>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public ParseUser then(Task<Void> task) throws Exception {
                        Object object = ParseUser.this.mutex;
                        synchronized (object) {
                            ParseUser.this.isLazy = false;
                            return ParseUser.this;
                        }
                    }
                });
            }
            final Capture operations = new Capture();
            return Task.call((Callable)new Callable<ParseOperationSet>(){

                @Override
                public ParseOperationSet call() throws Exception {
                    return ParseUser.this.startSave();
                }
            }).onSuccessTask(TaskQueue.waitFor(toAwait)).onSuccessTask((Continuation)new Continuation<ParseOperationSet, Task<ParseUser>>(){

                public Task<ParseUser> then(Task<ParseOperationSet> task) throws Exception {
                    operations.set(task.getResult());
                    final ParseRESTUserCommand command = ParseUser.this.currentServiceLogInCommand(ParseUser.this.getState(), (ParseOperationSet)operations.get());
                    return command.executeAsync().onSuccessTask((Continuation)new Continuation<JSONObject, Task<ParseUser>>(){

                        public Task<ParseUser> then(Task<JSONObject> task) throws Exception {
                            final JSONObject commandResult = (JSONObject)task.getResult();
                            final boolean isNew = command.getStatusCode() == 201;
                            Task resultTask = Parse.isLocalDatastoreEnabled() && !isNew ? Task.forResult((Object)commandResult) : ParseUser.this.handleSaveResultAsync(commandResult, (ParseOperationSet)operations.get()).onSuccess((Continuation)new Continuation<Void, JSONObject>(){

                                public JSONObject then(Task<Void> task) throws Exception {
                                    return commandResult;
                                }
                            });
                            return resultTask.onSuccessTask((Continuation)new Continuation<JSONObject, Task<ParseUser>>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Task<ParseUser> then(Task<JSONObject> task) throws Exception {
                                    JSONObject commandResult = (JSONObject)task.getResult();
                                    Object object = ParseUser.this.mutex;
                                    synchronized (object) {
                                        if (isNew) {
                                            ParseUser.this.isLazy = false;
                                            return Task.forResult((Object)ParseUser.this);
                                        }
                                    }
                                    ParseUser newUser = (ParseUser)ParseObject.fromJSON(commandResult, "_User", true);
                                    return ParseUser.saveCurrentUserAsync(newUser);
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    @Override
    <T extends ParseObject> Task<T> fetchFromLocalDatastoreAsync() {
        if (this.isLazy()) {
            return Task.forResult((Object)this);
        }
        return super.fetchFromLocalDatastoreAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableAutomaticUser() {
        Object object = isAutoUserEnabledMutex;
        synchronized (object) {
            autoUserEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableAutomaticUser() {
        Object object = isAutoUserEnabledMutex;
        synchronized (object) {
            autoUserEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isAutomaticUserEnabled() {
        Object object = isAutoUserEnabledMutex;
        synchronized (object) {
            return autoUserEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> enableRevocableSessionInBackground() {
        Object object = isRevocableSessionEnabledMutex;
        synchronized (object) {
            isRevocableSessionEnabled = true;
        }
        return ParseUser.getCurrentUserAsync(false).onSuccessTask((Continuation)new Continuation<ParseUser, Task<Void>>(){

            public Task<Void> then(Task<ParseUser> task) throws Exception {
                ParseUser user = (ParseUser)task.getResult();
                if (user == null) {
                    return Task.forResult(null);
                }
                return user.upgradeToRevocableSessionAsync();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableRevocableSession() {
        Object object = isRevocableSessionEnabledMutex;
        synchronized (object) {
            isRevocableSessionEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRevocableSessionEnabled() {
        Object object = isRevocableSessionEnabledMutex;
        synchronized (object) {
            return isRevocableSessionEnabled;
        }
    }

    static boolean isRevocableSessionToken(String sessionToken) {
        return sessionToken.contains("r:");
    }

    Task<Void> upgradeToRevocableSessionAsync() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParseUser.this.upgradeToRevocableSessionAsync((Task<Void>)toAwait);
            }
        });
    }

    private Task<Void> upgradeToRevocableSessionAsync(Task<Void> toAwait) {
        final String sessionToken = this.getSessionToken();
        if (sessionToken == null || ParseUser.isRevocableSessionToken(sessionToken)) {
            return toAwait;
        }
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<JSONObject>>(){

            public Task<JSONObject> then(Task<Void> task) throws Exception {
                return ParseRESTUserCommand.upgradeRevocableSessionCommand(sessionToken).executeAsync().cast();
            }
        }).onSuccessTask((Continuation)new Continuation<JSONObject, Task<Void>>(){

            public Task<Void> then(Task<JSONObject> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                ParseSession session = (ParseSession)ParseObject.fromJSON(json, "_Session", true);
                return ParseUser.this.setSessionTokenInBackground(session.getSessionToken());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCurrentUserFromMemory() {
        Object object = MUTEX_CURRENT_USER;
        synchronized (object) {
            currentUser = null;
            currentUserMatchesDisk = false;
        }
    }

    static {
        QUEUE_CURRENT_USER = new TaskQueue();
        authenticationProviders = new HashMap<String, ParseAuthenticationProvider>();
        currentUserMatchesDisk = false;
        isAutoUserEnabledMutex = new Object();
        isRevocableSessionEnabledMutex = new Object();
    }

    static class State
    extends ParseObject.State {
        private State(Builder builder) {
            super(builder);
        }

        public Builder newBuilder() {
            return new Builder(this);
        }

        public String sessionToken() {
            return (String)this.get(ParseUser.KEY_SESSION_TOKEN);
        }

        public Map<String, Map<String, String>> authData() {
            HashMap authData = (HashMap)this.get(ParseUser.KEY_AUTH_DATA);
            if (authData == null) {
                authData = new HashMap();
            }
            return authData;
        }

        static class Builder
        extends ParseObject.State.Init<Builder> {
            public Builder(String className) {
                super(className);
            }

            Builder(State state) {
                super(state);
            }

            @Override
            Builder self() {
                return this;
            }

            @Override
            public State build() {
                return new State(this);
            }

            public Builder sessionToken(String sessionToken) {
                return (Builder)this.put(ParseUser.KEY_SESSION_TOKEN, sessionToken);
            }

            public Builder authData(Map<String, Map<String, String>> authData) {
                return (Builder)this.put(ParseUser.KEY_AUTH_DATA, authData);
            }

            public Builder putAuthData(String authType, Map<String, String> authData) {
                HashMap<String, Map<String, String>> newAuthData = (HashMap<String, Map<String, String>>)this.serverData.get(ParseUser.KEY_AUTH_DATA);
                if (newAuthData == null) {
                    newAuthData = new HashMap<String, Map<String, String>>();
                }
                newAuthData.put(authType, authData);
                this.serverData.put(ParseUser.KEY_AUTH_DATA, newAuthData);
                return this;
            }
        }
    }
}

