/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseDeleteOperation;
import com.parse.ParseEncoder;
import com.parse.ParseFieldOperation;
import com.parse.ParseFieldOperations;
import com.parse.ParseObject;
import com.parse.ParseSetOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRemoveOperation
implements ParseFieldOperation {
    protected HashSet<Object> objects = new HashSet();

    public ParseRemoveOperation(Collection<?> coll) {
        this.objects.addAll(coll);
    }

    public JSONObject encode(ParseEncoder objectEncoder) throws JSONException {
        JSONObject output = new JSONObject();
        output.put("__op", (Object)"Remove");
        output.put("objects", objectEncoder.encode(new ArrayList<Object>(this.objects)));
        return output;
    }

    @Override
    public ParseFieldOperation mergeWithPrevious(ParseFieldOperation previous) {
        if (previous == null) {
            return this;
        }
        if (previous instanceof ParseDeleteOperation) {
            return new ParseSetOperation(this.objects);
        }
        if (previous instanceof ParseSetOperation) {
            Object value = ((ParseSetOperation)previous).getValue();
            if (value instanceof JSONArray || value instanceof List) {
                return new ParseSetOperation(this.apply(value, null));
            }
            throw new IllegalArgumentException("You can only add an item to a List or JSONArray.");
        }
        if (previous instanceof ParseRemoveOperation) {
            HashSet<Object> result = new HashSet<Object>(((ParseRemoveOperation)previous).objects);
            result.addAll(this.objects);
            return new ParseRemoveOperation(result);
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }

    @Override
    public Object apply(Object oldValue, String key) {
        if (oldValue == null) {
            return new ArrayList();
        }
        if (oldValue instanceof JSONArray) {
            ArrayList<Object> old = ParseFieldOperations.jsonArrayAsArrayList((JSONArray)oldValue);
            ArrayList newValue = (ArrayList)this.apply(old, key);
            return new JSONArray((Collection)newValue);
        }
        if (oldValue instanceof List) {
            ArrayList result = new ArrayList((List)oldValue);
            result.removeAll(this.objects);
            ArrayList<Object> objectsToBeRemoved = new ArrayList<Object>(this.objects);
            objectsToBeRemoved.removeAll(result);
            HashSet<String> objectIds = new HashSet<String>();
            for (Object obj : objectsToBeRemoved) {
                if (!(obj instanceof ParseObject)) continue;
                objectIds.add(((ParseObject)obj).getObjectId());
            }
            Iterator resultIterator = result.iterator();
            while (resultIterator.hasNext()) {
                Object obj;
                obj = resultIterator.next();
                if (!(obj instanceof ParseObject) || !objectIds.contains(((ParseObject)obj).getObjectId())) continue;
                resultIterator.remove();
            }
            return result;
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }
}

